"use strict";

var _document = _interopRequireDefault(require("./helpers/document"));

var _utils = require("../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

test('.toBeInTheDocument', function () {
  _document.default.body.innerHTML = `
    <span data-testid="html-element"><span>Html Element</span></span>
    <svg data-testid="svg-element"></svg>`;

  var htmlElement = _document.default.querySelector('[data-testid="html-element"]');

  var svgElement = _document.default.querySelector('[data-testid="svg-element"]');

  var detachedElement = _document.default.createElement('div');

  var fakeElement = {
    thisIsNot: 'an html element'
  };
  var undefinedElement = undefined;
  var nullElement = null;
  expect(htmlElement).toBeInTheDocument();
  expect(svgElement).toBeInTheDocument();
  expect(detachedElement).not.toBeInTheDocument();
  expect(nullElement).not.toBeInTheDocument(); // negative test cases wrapped in throwError assertions for coverage.

  var expectToBe = /expect.*\.toBeInTheDocument/;
  var expectNotToBe = /expect.*not\.toBeInTheDocument/;
  expect(function () {
    return expect(htmlElement).not.toBeInTheDocument();
  }).toThrowError(expectNotToBe);
  expect(function () {
    return expect(svgElement).not.toBeInTheDocument();
  }).toThrowError(expectNotToBe);
  expect(function () {
    return expect(detachedElement).toBeInTheDocument();
  }).toThrowError(expectToBe);
  expect(function () {
    return expect(fakeElement).toBeInTheDocument();
  }).toThrowError(_utils.HtmlElementTypeError);
  expect(function () {
    return expect(undefinedElement).toBeInTheDocument();
  }).toThrowError(_utils.HtmlElementTypeError);
  expect(function () {
    return expect(nullElement).toBeInTheDocument();
  }).toThrowError(_utils.HtmlElementTypeError);
});