"use strict";

var _testUtils = require("./helpers/test-utils");

test('.toBeInTheDOM', function () {
  // @deprecated intentionally hiding warnings for test clarity
  var spy = jest.spyOn(console, 'warn').mockImplementation(function () {});

  var _render = (0, _testUtils.render)(`
    <span data-testid="count-container">
      <span data-testid="count-value"></span>
      <svg data-testid="svg-element"></svg>
    </span>`),
      queryByTestId = _render.queryByTestId;

  var containerElement = queryByTestId('count-container');
  var valueElement = queryByTestId('count-value');
  var nonExistantElement = queryByTestId('not-exists');
  var svgElement = queryByTestId('svg-element');
  var fakeElement = {
    thisIsNot: 'an html element' // Testing toBeInTheDOM without container

  };
  expect(valueElement).toBeInTheDOM();
  expect(svgElement).toBeInTheDOM();
  expect(nonExistantElement).not.toBeInTheDOM(); // negative test cases wrapped in throwError assertions for coverage.

  expect(function () {
    return expect(valueElement).not.toBeInTheDOM();
  }).toThrowError();
  expect(function () {
    return expect(svgElement).not.toBeInTheDOM();
  }).toThrowError();
  expect(function () {
    return expect(nonExistantElement).toBeInTheDOM();
  }).toThrowError();
  expect(function () {
    return expect(fakeElement).toBeInTheDOM();
  }).toThrowError(); // Testing toBeInTheDOM with container

  expect(valueElement).toBeInTheDOM(containerElement);
  expect(svgElement).toBeInTheDOM(containerElement);
  expect(containerElement).not.toBeInTheDOM(valueElement);
  expect(function () {
    return expect(valueElement).not.toBeInTheDOM(containerElement);
  }).toThrowError();
  expect(function () {
    return expect(svgElement).not.toBeInTheDOM(containerElement);
  }).toThrowError();
  expect(function () {
    return expect(nonExistantElement).toBeInTheDOM(containerElement);
  }).toThrowError();
  expect(function () {
    return expect(fakeElement).toBeInTheDOM(containerElement);
  }).toThrowError();
  expect(function () {
    expect(valueElement).toBeInTheDOM(fakeElement);
  }).toThrowError();
  spy.mockRestore();
});