"use strict";

var _testUtils = require("./helpers/test-utils");

var _render = (0, _testUtils.render)(`
<span data-testid="grandparent">
  <span data-testid="parent">
    <span data-testid="child"></span>
  </span>
  <svg data-testid="svg-element"></svg>
</span>
`),
    queryByTestId = _render.queryByTestId;

var grandparent = queryByTestId('grandparent');
var parent = queryByTestId('parent');
var child = queryByTestId('child');
var svgElement = queryByTestId('svg-element');
var nonExistantElement = queryByTestId('not-exists');
var fakeElement = {
  thisIsNot: 'an html element'
};
test('.toContainElement positive test cases', function () {
  expect(grandparent).toContainElement(parent);
  expect(grandparent).toContainElement(child);
  expect(grandparent).toContainElement(svgElement);
  expect(parent).toContainElement(child);
  expect(parent).not.toContainElement(grandparent);
  expect(parent).not.toContainElement(svgElement);
  expect(child).not.toContainElement(parent);
  expect(child).not.toContainElement(grandparent);
  expect(child).not.toContainElement(svgElement);
  expect(grandparent).not.toContainElement(nonExistantElement);
});
test('.toContainElement negative test cases', function () {
  expect(function () {
    return expect(nonExistantElement).not.toContainElement(child);
  }).toThrowError();
  expect(function () {
    return expect(parent).toContainElement(grandparent);
  }).toThrowError();
  expect(function () {
    return expect(nonExistantElement).toContainElement(grandparent);
  }).toThrowError();
  expect(function () {
    return expect(grandparent).toContainElement(nonExistantElement);
  }).toThrowError();
  expect(function () {
    return expect(nonExistantElement).toContainElement(nonExistantElement);
  }).toThrowError();
  expect(function () {
    return expect(nonExistantElement).toContainElement(fakeElement);
  }).toThrowError();
  expect(function () {
    return expect(fakeElement).toContainElement(nonExistantElement);
  }).toThrowError();
  expect(function () {
    return expect(fakeElement).not.toContainElement(nonExistantElement);
  }).toThrowError();
  expect(function () {
    return expect(fakeElement).toContainElement(grandparent);
  }).toThrowError();
  expect(function () {
    return expect(grandparent).toContainElement(fakeElement);
  }).toThrowError();
  expect(function () {
    return expect(fakeElement).toContainElement(fakeElement);
  }).toThrowError();
  expect(function () {
    return expect(grandparent).not.toContainElement(child);
  }).toThrowError();
  expect(function () {
    return expect(grandparent).not.toContainElement(svgElement);
  }).toThrowError();
  expect(function () {
    return expect(grandparent).not.toContainElement(undefined);
  }).toThrowError();
});