"use strict";

var _testUtils = require("./helpers/test-utils");

/* eslint-disable max-statements */
test('.toContainHTML', function () {
  var _render = (0, _testUtils.render)(`
    <span data-testid="grandparent">
      <span data-testid="parent">
        <span data-testid="child"></span>
      </span>
      <svg data-testid="svg-element"></svg>
    </span>
    `),
      queryByTestId = _render.queryByTestId;

  var grandparent = queryByTestId('grandparent');
  var parent = queryByTestId('parent');
  var child = queryByTestId('child');
  var nonExistantElement = queryByTestId('not-exists');
  var fakeElement = {
    thisIsNot: 'an html element'
  };
  var stringChildElement = '<span data-testid="child"></span>';
  var incorrectStringHtml = '<span data-testid="child"></div>';
  var nonExistantString = '<span> Does not exists </span>';
  var svgElement = queryByTestId('svg-element');
  expect(grandparent).toContainHTML(stringChildElement);
  expect(parent).toContainHTML(stringChildElement);
  expect(child).toContainHTML(stringChildElement);
  expect(grandparent).not.toContainHTML(nonExistantString);
  expect(parent).not.toContainHTML(nonExistantString);
  expect(child).not.toContainHTML(nonExistantString);
  expect(child).not.toContainHTML(nonExistantString);
  expect(grandparent).not.toContainHTML(incorrectStringHtml);
  expect(parent).not.toContainHTML(incorrectStringHtml);
  expect(child).not.toContainHTML(incorrectStringHtml);
  expect(child).not.toContainHTML(incorrectStringHtml); // negative test cases wrapped in throwError assertions for coverage.

  expect(function () {
    return expect(nonExistantElement).not.toContainHTML(stringChildElement);
  }).toThrowError();
  expect(function () {
    return expect(nonExistantElement).not.toContainHTML(nonExistantElement);
  }).toThrowError();
  expect(function () {
    return expect(stringChildElement).not.toContainHTML(fakeElement);
  }).toThrowError();
  expect(function () {
    return expect(svgElement).toContainHTML(stringChildElement);
  }).toThrowError();
  expect(function () {
    return expect(grandparent).not.toContainHTML(stringChildElement);
  }).toThrowError();
  expect(function () {
    return expect(parent).not.toContainHTML(stringChildElement);
  }).toThrowError();
  expect(function () {
    return expect(child).not.toContainHTML(stringChildElement);
  }).toThrowError();
  expect(function () {
    return expect(child).not.toContainHTML(stringChildElement);
  }).toThrowError();
  expect(function () {
    return expect(child).toContainHTML(nonExistantString);
  }).toThrowError();
  expect(function () {
    return expect(parent).toContainHTML(nonExistantString);
  }).toThrowError();
  expect(function () {
    return expect(grandparent).toContainHTML(nonExistantString);
  }).toThrowError();
  expect(function () {
    return expect(child).toContainHTML(nonExistantElement);
  }).toThrowError();
  expect(function () {
    return expect(parent).toContainHTML(nonExistantElement);
  }).toThrowError();
  expect(function () {
    return expect(grandparent).toContainHTML(nonExistantElement);
  }).toThrowError();
  expect(function () {
    return expect(nonExistantElement).toContainHTML(incorrectStringHtml);
  }).toThrowError();
  expect(function () {
    return expect(grandparent).toContainHTML(incorrectStringHtml);
  }).toThrowError();
  expect(function () {
    return expect(child).toContainHTML(incorrectStringHtml);
  }).toThrowError();
  expect(function () {
    return expect(parent).toContainHTML(incorrectStringHtml);
  }).toThrowError();
});