"use strict";

var _testUtils = require("./helpers/test-utils");

test('.toHaveAttribute', function () {
  var _render = (0, _testUtils.render)(`
    <button data-testid="ok-button" type="submit" disabled>
      OK
    </button>
    <svg data-testid="svg-element" width="12"></svg>
  `),
      queryByTestId = _render.queryByTestId;

  expect(queryByTestId('ok-button')).toHaveAttribute('disabled');
  expect(queryByTestId('ok-button')).toHaveAttribute('type');
  expect(queryByTestId('ok-button')).not.toHaveAttribute('class');
  expect(queryByTestId('ok-button')).toHaveAttribute('type', 'submit');
  expect(queryByTestId('ok-button')).not.toHaveAttribute('type', 'button');
  expect(queryByTestId('svg-element')).toHaveAttribute('width');
  expect(queryByTestId('svg-element')).toHaveAttribute('width', '12');
  expect(queryByTestId('ok-button')).not.toHaveAttribute('height');
  expect(function () {
    return expect(queryByTestId('ok-button')).not.toHaveAttribute('disabled');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('ok-button')).not.toHaveAttribute('type');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('ok-button')).toHaveAttribute('class');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('ok-button')).not.toHaveAttribute('type', 'submit');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('ok-button')).toHaveAttribute('type', 'button');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('svg-element')).not.toHaveAttribute('width');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('svg-element')).not.toHaveAttribute('width', '12');
  }).toThrowError();
  expect(function () {
    return expect({
      thisIsNot: 'an html element'
    }).not.toHaveAttribute();
  }).toThrowError();
});