"use strict";

var _testUtils = require("./helpers/test-utils");

/* eslint max-statements:off */
test('.toHaveClass', function () {
  var _render = (0, _testUtils.render)(`
    <div>
      <button data-testid="delete-button" class="btn extra btn-danger">
        Delete item
      </button>
      <button data-testid="cancel-button">
        Cancel
      </button>
      <svg data-testid="svg-spinner" class="spinner clockwise">
        <path />
      </svg>
      <div data-testid="no-classes"></div>
    </div>
  `),
      queryByTestId = _render.queryByTestId;

  expect(queryByTestId('delete-button')).toHaveClass('btn');
  expect(queryByTestId('delete-button')).toHaveClass('btn-danger');
  expect(queryByTestId('delete-button')).toHaveClass('extra');
  expect(queryByTestId('delete-button')).not.toHaveClass('xtra');
  expect(queryByTestId('delete-button')).not.toHaveClass('btn xtra');
  expect(queryByTestId('delete-button')).not.toHaveClass('btn', 'xtra');
  expect(queryByTestId('delete-button')).not.toHaveClass('btn', 'extra xtra');
  expect(queryByTestId('delete-button')).toHaveClass('btn btn-danger');
  expect(queryByTestId('delete-button')).toHaveClass('btn', 'btn-danger');
  expect(queryByTestId('delete-button')).toHaveClass('btn extra', 'btn-danger extra');
  expect(queryByTestId('delete-button')).not.toHaveClass('btn-link');
  expect(queryByTestId('cancel-button')).not.toHaveClass('btn-danger');
  expect(queryByTestId('svg-spinner')).toHaveClass('spinner');
  expect(queryByTestId('svg-spinner')).toHaveClass('clockwise');
  expect(queryByTestId('svg-spinner')).not.toHaveClass('wise');
  expect(queryByTestId('no-classes')).not.toHaveClass();
  expect(queryByTestId('no-classes')).not.toHaveClass(' ');
  expect(function () {
    return expect(queryByTestId('delete-button')).not.toHaveClass('btn');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('delete-button')).not.toHaveClass('btn-danger');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('delete-button')).not.toHaveClass('extra');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('delete-button')).toHaveClass('xtra');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('delete-button')).toHaveClass('xtra');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('delete-button')).toHaveClass('btn', 'extra xtra');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('delete-button')).not.toHaveClass('btn btn-danger');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('delete-button')).not.toHaveClass('btn', 'btn-danger');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('delete-button')).toHaveClass('btn-link');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('cancel-button')).toHaveClass('btn-danger');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('svg-spinner')).not.toHaveClass('spinner');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('svg-spinner')).toHaveClass('wise');
  }).toThrowError();
  expect(function () {
    return expect(queryByTestId('delete-button')).toHaveClass();
  }).toThrowError(/At least one expected class must be provided/);
  expect(function () {
    return expect(queryByTestId('delete-button')).toHaveClass('');
  }).toThrowError(/At least one expected class must be provided/);
  expect(function () {
    return expect(queryByTestId('no-classes')).toHaveClass();
  }).toThrowError(/At least one expected class must be provided/);
  expect(function () {
    return expect(queryByTestId('delete-button')).not.toHaveClass();
  }).toThrowError(/(none)/);
  expect(function () {
    return expect(queryByTestId('delete-button')).not.toHaveClass('  ');
  }).toThrowError(/(none)/);
});