"use strict";

var _testUtils = require("./helpers/test-utils");

test('.toHaveFocus', function () {
  var _render = (0, _testUtils.render)(`
      <div>
        <label for="focused">test</label>
        <input id="focused" type="text" />
        <button type="submit" id="not-focused">Not Focused</button>
      </div>`),
      container = _render.container;

  var focused = container.querySelector('#focused');
  var notFocused = container.querySelector('#not-focused');
  focused.focus();
  expect(focused).toHaveFocus();
  expect(notFocused).not.toHaveFocus();
  expect(function () {
    return expect(focused).not.toHaveFocus();
  }).toThrowError();
  expect(function () {
    return expect(notFocused).toHaveFocus();
  }).toThrowError();
});