"use strict";

var _testUtils = require("./helpers/test-utils");

var _document = _interopRequireDefault(require("./helpers/document"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('.toHaveStyle', function () {
  test('handles positive test cases', function () {
    var _render = (0, _testUtils.render)(`
          <div class="label" style="background-color: blue; height: 100%">
            Hello World
          </div>
        `),
        container = _render.container;

    var style = _document.default.createElement('style');

    style.innerHTML = `
          .label {
            background-color: black;
            color: white;
            float: left;
          }
        `;

    _document.default.body.appendChild(style);

    _document.default.body.appendChild(container);

    expect(container.querySelector('.label')).toHaveStyle(`
          height: 100%;
          color: white;
          background-color: blue;
        `);
    expect(container.querySelector('.label')).toHaveStyle(`
          background-color: blue;
          color: white;
        `);
    expect(container.querySelector('.label')).toHaveStyle('background-color:blue;color:white');
    expect(container.querySelector('.label')).not.toHaveStyle(`
          color: white;
          font-weight: bold;
        `);
  });
  test('handles negative test cases', function () {
    var _render2 = (0, _testUtils.render)(`
    <div class="label" style="background-color: blue; height: 100%">
      Hello World
    </div>
  `),
        container = _render2.container;

    var style = _document.default.createElement('style');

    style.innerHTML = `
    .label {
      background-color: black;
      color: white;
      float: left;
    }
  `;

    _document.default.body.appendChild(style);

    _document.default.body.appendChild(container);

    expect(function () {
      return expect(container.querySelector('.label')).toHaveStyle('font-weight: bold');
    }).toThrowError();
    expect(function () {
      return expect(container.querySelector('.label')).not.toHaveStyle('color: white');
    }).toThrowError(); // Make sure the test fails if the css syntax is not valid

    expect(function () {
      return expect(container.querySelector('.label')).not.toHaveStyle('font-weight bold');
    }).toThrowError();
    expect(function () {
      return expect(container.querySelector('.label')).toHaveStyle('color white');
    }).toThrowError();

    _document.default.body.removeChild(style);

    _document.default.body.removeChild(container);
  });
  test('properly normalizes colors', function () {
    var _render3 = (0, _testUtils.render)(`
      <span data-testid="color-example" style="background-color: #123456">Hello World</span>
    `),
        queryByTestId = _render3.queryByTestId;

    expect(queryByTestId('color-example')).toHaveStyle('background-color: #123456');
  });
  test('properly normalizes colors for border', function () {
    var _render4 = (0, _testUtils.render)(`
    <span data-testid="color-example" style="border: 1px solid #fff">Hello World</span>
  `),
        queryByTestId = _render4.queryByTestId;

    expect(queryByTestId('color-example')).toHaveStyle('border: 1px solid #fff');
  });
});