"use strict";

var _testUtils = require("./helpers/test-utils");

describe('.toHaveTextContent', function () {
  test('handles positive test cases', function () {
    var _render = (0, _testUtils.render)(`<span data-testid="count-value">2</span>`),
        queryByTestId = _render.queryByTestId;

    expect(queryByTestId('count-value')).toHaveTextContent('2');
    expect(queryByTestId('count-value')).toHaveTextContent(2);
    expect(queryByTestId('count-value')).toHaveTextContent(/2/);
    expect(queryByTestId('count-value')).not.toHaveTextContent('21');
  });
  test('handles negative test cases', function () {
    var _render2 = (0, _testUtils.render)(`<span data-testid="count-value">2</span>`),
        queryByTestId = _render2.queryByTestId;

    expect(function () {
      return expect(queryByTestId('count-value2')).toHaveTextContent('2');
    }).toThrowError();
    expect(function () {
      return expect(queryByTestId('count-value')).toHaveTextContent('3');
    }).toThrowError();
    expect(function () {
      return expect(queryByTestId('count-value')).not.toHaveTextContent('2');
    }).toThrowError();
  });
  test('normalizes whitespace by default', function () {
    var _render3 = (0, _testUtils.render)(`
      <span>
        Step
          1
            of
              4
      </span>
    `),
        container = _render3.container;

    expect(container.querySelector('span')).toHaveTextContent('Step 1 of 4');
  });
  test('allows whitespace normalization to be turned off', function () {
    var _render4 = (0, _testUtils.render)(`<span>&nbsp;&nbsp;Step 1 of 4</span>`),
        container = _render4.container;

    expect(container.querySelector('span')).toHaveTextContent('  Step 1 of 4', {
      normalizeWhitespace: false
    });
  });
  test('can handle multiple levels', function () {
    var _render5 = (0, _testUtils.render)(`<span id="parent"><span>Step 1 
    
    of 4</span></span>`),
        container = _render5.container;

    expect(container.querySelector('#parent')).toHaveTextContent('Step 1 of 4');
  });
  test('can handle multiple levels with content spread across decendants', function () {
    var _render6 = (0, _testUtils.render)(`
        <span id="parent">
            <span>Step</span>
            <span>      1</span>
            <span><span>of</span></span>


            4</span>
        </span>
    `),
        container = _render6.container;

    expect(container.querySelector('#parent')).toHaveTextContent('Step 1 of 4');
  });
  test('does not throw error with empty content', function () {
    var _render7 = (0, _testUtils.render)(`<span></span>`),
        container = _render7.container;

    expect(container.querySelector('span')).toHaveTextContent('');
  });
  test('is case-sensitive', function () {
    var _render8 = (0, _testUtils.render)('<span>Sensitive text</span>'),
        container = _render8.container;

    expect(container.querySelector('span')).toHaveTextContent('Sensitive text');
    expect(container.querySelector('span')).not.toHaveTextContent('sensitive text');
  });
});