"use strict";

var _utils = require("../utils");

var _document = _interopRequireDefault(require("./helpers/document"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

test('deprecate', function () {
  var spy = jest.spyOn(console, 'warn').mockImplementation(function () {});
  var name = 'test';
  var replacement = 'test';
  var message = `Warning: ${name} has been deprecated and will be removed in future updates.`;
  (0, _utils.deprecate)(name, replacement);
  expect(spy).toHaveBeenCalledWith(message, replacement);
  (0, _utils.deprecate)(name);
  expect(spy).toHaveBeenCalledWith(message, undefined);
  spy.mockRestore();
});
describe('checkHtmlElement', function () {
  it('does not throw an error for correct html element', function () {
    expect(function () {
      var element = _document.default.createElement('p');

      (0, _utils.checkHtmlElement)(element, function () {}, {});
    }).not.toThrow();
  });
  it('does not throw an error for correct svg element', function () {
    expect(function () {
      var element = _document.default.createElementNS('http://www.w3.org/2000/svg', 'rect');

      (0, _utils.checkHtmlElement)(element, function () {}, {});
    }).not.toThrow();
  });
  it('does not throw for body', function () {
    expect(function () {
      (0, _utils.checkHtmlElement)(_document.default.body, function () {}, {});
    }).not.toThrow();
  });
  it('throws for undefined', function () {
    expect(function () {
      (0, _utils.checkHtmlElement)(undefined, function () {}, {});
    }).toThrow(_utils.HtmlElementTypeError);
  });
  it('throws for document', function () {
    expect(function () {
      (0, _utils.checkHtmlElement)(_document.default, function () {}, {});
    }).toThrow(_utils.HtmlElementTypeError);
  });
  it('throws for function', function () {
    expect(function () {
      (0, _utils.checkHtmlElement)(function () {}, function () {}, {});
    }).toThrow(_utils.HtmlElementTypeError);
  });
});