"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toBeInTheDocument = toBeInTheDocument;

var _jestMatcherUtils = require("jest-matcher-utils");

var _utils = require("./utils");

function toBeInTheDocument(element) {
  var _this = this;

  if (element !== null || !this.isNot) {
    (0, _utils.checkHtmlElement)(element, toBeInTheDocument, this);
  }

  var pass = element === null ? false : element.ownerDocument.contains(element);
  return {
    pass,
    message: function message() {
      return [(0, _jestMatcherUtils.matcherHint)(`${_this.isNot ? '.not' : ''}.toBeInTheDocument`, 'element', ''), '', (0, _jestMatcherUtils.RECEIVED_COLOR)(`${(0, _jestMatcherUtils.stringify)(element.ownerDocument.cloneNode(false))} ${_this.isNot ? 'contains:' : 'does not contain:'} ${(0, _jestMatcherUtils.stringify)(element ? element.cloneNode(false) : element)}
        `)].join('\n');
    }
  };
}