"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toBeInTheDOM = toBeInTheDOM;

var _jestMatcherUtils = require("jest-matcher-utils");

var _utils = require("./utils");

function toBeInTheDOM(element, container) {
  var _this = this;

  (0, _utils.deprecate)('toBeInTheDOM', 'Please use toBeInTheDocument for searching the entire document and toContainElement for searching a specific container.');

  if (element) {
    (0, _utils.checkHtmlElement)(element, toBeInTheDOM, this);
  }

  if (container) {
    (0, _utils.checkHtmlElement)(container, toBeInTheDOM, this);
  }

  return {
    pass: container ? container.contains(element) : !!element,
    message: function message() {
      return [(0, _jestMatcherUtils.matcherHint)(`${_this.isNot ? '.not' : ''}.toBeInTheDOM`, 'element', ''), '', 'Received:', `  ${(0, _jestMatcherUtils.printReceived)(element ? element.cloneNode(false) : element)}`].join('\n');
    }
  };
}