"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toBeVisible = toBeVisible;

var _jestMatcherUtils = require("jest-matcher-utils");

var _utils = require("./utils");

function isStyleVisible(element) {
  var getComputedStyle = element.ownerDocument.defaultView.getComputedStyle;

  var _getComputedStyle = getComputedStyle(element),
      display = _getComputedStyle.display,
      visibility = _getComputedStyle.visibility,
      opacity = _getComputedStyle.opacity;

  return display !== 'none' && visibility !== 'hidden' && visibility !== 'collapse' && opacity !== '0' && opacity !== 0;
}

function isElementVisible(element) {
  return isStyleVisible(element) && !element.hasAttribute('hidden') && (!element.parentElement || isElementVisible(element.parentElement));
}

function toBeVisible(element) {
  var _this = this;

  (0, _utils.checkHtmlElement)(element, toBeVisible, this);
  var isVisible = isElementVisible(element);
  return {
    pass: isVisible,
    message: function message() {
      var is = isVisible ? 'is' : 'is not';
      return [(0, _jestMatcherUtils.matcherHint)(`${_this.isNot ? '.not' : ''}.toBeVisible`, 'element', ''), '', `Received element ${is} visible:`, `  ${(0, _jestMatcherUtils.printReceived)(element.cloneNode(false))}`].join('\n');
    }
  };
}