"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toHaveAttribute = toHaveAttribute;

var _jestMatcherUtils = require("jest-matcher-utils");

var _utils = require("./utils");

function printAttribute(name, value) {
  return value === undefined ? name : `${name}=${(0, _jestMatcherUtils.stringify)(value)}`;
}

function getAttributeComment(name, value) {
  return value === undefined ? `element.hasAttribute(${(0, _jestMatcherUtils.stringify)(name)})` : `element.getAttribute(${(0, _jestMatcherUtils.stringify)(name)}) === ${(0, _jestMatcherUtils.stringify)(value)}`;
}

function toHaveAttribute(htmlElement, name, expectedValue) {
  var _this = this;

  (0, _utils.checkHtmlElement)(htmlElement, toHaveAttribute, this);
  var isExpectedValuePresent = expectedValue !== undefined;
  var hasAttribute = htmlElement.hasAttribute(name);
  var receivedValue = htmlElement.getAttribute(name);
  return {
    pass: isExpectedValuePresent ? hasAttribute && receivedValue === expectedValue : hasAttribute,
    message: function message() {
      var to = _this.isNot ? 'not to' : 'to';
      var receivedAttribute = hasAttribute ? printAttribute(name, receivedValue) : null;
      var matcher = (0, _jestMatcherUtils.matcherHint)(`${_this.isNot ? '.not' : ''}.toHaveAttribute`, 'element', (0, _jestMatcherUtils.printExpected)(name), {
        secondArgument: isExpectedValuePresent ? (0, _jestMatcherUtils.printExpected)(expectedValue) : undefined,
        comment: getAttributeComment(name, expectedValue)
      });
      return (0, _utils.getMessage)(matcher, `Expected the element ${to} have attribute`, printAttribute(name, expectedValue), 'Received', receivedAttribute);
    }
  };
}