"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toHaveClass = toHaveClass;

var _jestMatcherUtils = require("jest-matcher-utils");

var _utils = require("./utils");

function splitClassNames(str) {
  if (!str) {
    return [];
  }

  return str.split(/\s+/).filter(function (s) {
    return s.length > 0;
  });
}

function isSubset(subset, superset) {
  return subset.every(function (item) {
    return superset.includes(item);
  });
}

function toHaveClass(htmlElement) {
  var _this = this;

  (0, _utils.checkHtmlElement)(htmlElement, toHaveClass, this);
  var received = splitClassNames(htmlElement.getAttribute('class'));

  for (var _len = arguments.length, expectedClassNames = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    expectedClassNames[_key - 1] = arguments[_key];
  }

  var expected = expectedClassNames.reduce(function (acc, className) {
    return acc.concat(splitClassNames(className));
  }, []);
  return expected.length > 0 ? {
    pass: isSubset(expected, received),
    message: function message() {
      var to = _this.isNot ? 'not to' : 'to';
      return (0, _utils.getMessage)((0, _jestMatcherUtils.matcherHint)(`${_this.isNot ? '.not' : ''}.toHaveClass`, 'element', (0, _jestMatcherUtils.printExpected)(expected.join(' '))), `Expected the element ${to} have class`, expected.join(' '), 'Received', received.join(' '));
    }
  } : {
    pass: this.isNot ? received.length > 0 : false,
    message: function message() {
      return _this.isNot ? (0, _utils.getMessage)((0, _jestMatcherUtils.matcherHint)('.not.toHaveClass', 'element', ''), 'Expected the element to have classes', '(none)', 'Received', received.join(' ')) : [(0, _jestMatcherUtils.matcherHint)(`.toHaveClass`, 'element'), 'At least one expected class must be provided.'].join('\n');
    }
  };
}