"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toHaveStyle = toHaveStyle;

var _jestMatcherUtils = require("jest-matcher-utils");

var _jestDiff = _interopRequireDefault(require("jest-diff"));

var _chalk = _interopRequireDefault(require("chalk"));

var _utils = require("./utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function getStyleDeclaration(document, css) {
  var copy = document.createElement('div');
  copy.style = css;
  var styles = copy.style;
  return Array.from(styles).reduce(function (acc, name) {
    return _extends({}, acc, {
      [name]: styles[name]
    });
  }, {});
}

function isSubset(styles, computedStyle) {
  return Object.entries(styles).every(function (_ref) {
    var prop = _ref[0],
        value = _ref[1];
    return computedStyle.getPropertyValue(prop) === value;
  });
}

function printoutStyles(styles) {
  return Object.keys(styles).sort().map(function (prop) {
    return `${prop}: ${styles[prop]};`;
  }).join('\n');
} // Highlights only style rules that were expected but were not found in the
// received computed styles


function expectedDiff(expected, computedStyles) {
  var received = Array.from(computedStyles).filter(function (prop) {
    return expected[prop];
  }).reduce(function (obj, prop) {
    return Object.assign(obj, {
      [prop]: computedStyles.getPropertyValue(prop)
    });
  }, {});
  var diffOutput = (0, _jestDiff.default)(printoutStyles(expected), printoutStyles(received)); // Remove the "+ Received" annotation because this is a one-way diff

  return diffOutput.replace(`${_chalk.default.red('+ Received')}\n`, '');
}

function toHaveStyle(htmlElement, css) {
  var _this = this;

  (0, _utils.checkHtmlElement)(htmlElement, toHaveStyle, this);
  (0, _utils.checkValidCSS)(css, toHaveStyle, this);
  var getComputedStyle = htmlElement.ownerDocument.defaultView.getComputedStyle;
  var expected = getStyleDeclaration(htmlElement.ownerDocument, css);
  var received = getComputedStyle(htmlElement);
  return {
    pass: isSubset(expected, received),
    message: function message() {
      var matcher = `${_this.isNot ? '.not' : ''}.toHaveStyle`;
      return [(0, _jestMatcherUtils.matcherHint)(matcher, 'element', ''), expectedDiff(expected, received)].join('\n\n');
    }
  };
}