"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toHaveTextContent = toHaveTextContent;

var _jestMatcherUtils = require("jest-matcher-utils");

var _utils = require("./utils");

function toHaveTextContent(htmlElement, checkWith, options) {
  var _this = this;

  if (options === void 0) {
    options = {
      normalizeWhitespace: true
    };
  }

  (0, _utils.checkHtmlElement)(htmlElement, toHaveTextContent, this);
  var textContent = options.normalizeWhitespace ? (0, _utils.normalize)(htmlElement.textContent) : htmlElement.textContent.replace(/\u00a0/g, ' '); // Replace &nbsp; with normal spaces

  return {
    pass: (0, _utils.matches)(textContent, checkWith),
    message: function message() {
      var to = _this.isNot ? 'not to' : 'to';
      return (0, _utils.getMessage)((0, _jestMatcherUtils.matcherHint)(`${_this.isNot ? '.not' : ''}.toHaveTextContent`, 'element', ''), `Expected element ${to} have text content`, checkWith, 'Received', textContent);
    }
  };
}