"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

require("jest-dom/extend-expect");

var _react = _interopRequireDefault(require("react"));

var _ = require("../");

afterEach(_.cleanup);
test('render calls useEffect immediately', () => {
  const effectCb = jest.fn();
  (0, _.render)(_react.default.createElement(function () {
    _react.default.useEffect(effectCb);

    return null;
  }, null));
  expect(effectCb).toHaveBeenCalledTimes(1);
});
test('findByTestId returns the element', async () => {
  const ref = _react.default.createRef();

  const {
    findByTestId
  } = (0, _.render)(_react.default.createElement("div", {
    ref: ref,
    "data-testid": "foo"
  }));
  expect((await findByTestId('foo'))).toBe(ref.current);
});
test('fireEvent triggers useEffect calls', () => {
  const effectCb = jest.fn();
  const {
    container: {
      firstChild: buttonNode
    }
  } = (0, _.render)(_react.default.createElement(function () {
    _react.default.useEffect(effectCb);

    const [count, setCount] = _react.default.useState(0);

    return _react.default.createElement("button", {
      onClick: () => setCount(count + 1)
    }, count);
  }, null));
  effectCb.mockClear();

  _.fireEvent.click(buttonNode);

  expect(buttonNode).toHaveTextContent('1');
  expect(effectCb).toHaveBeenCalledTimes(1);
});
test('calls to hydrate will run useEffects', () => {
  const effectCb = jest.fn();
  (0, _.render)(_react.default.createElement(function () {
    _react.default.useEffect(effectCb);

    return null;
  }, null), {
    hydrate: true
  });
  expect(effectCb).toHaveBeenCalledTimes(1);
});