"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _ = require("../");

afterEach(_.cleanup);

const fetchAMessage = () => new Promise(resolve => {
  // we are using random timeout here to simulate a real-time example
  // of an async operation calling a callback at a non-deterministic time
  const randomTimeout = Math.floor(Math.random() * 100);
  setTimeout(() => {
    resolve({
      returnedMessage: 'Hello World'
    });
  }, randomTimeout);
});

class ComponentWithLoader extends _react.default.Component {
  constructor(...args) {
    super(...args);
    this.state = {
      loading: true
    };
  }

  async componentDidMount() {
    const data = await fetchAMessage();
    this.setState({
      data,
      loading: false
    }); // eslint-disable-line
  }

  render() {
    if (this.state.loading) {
      return _react.default.createElement("div", null, "Loading...");
    }

    return _react.default.createElement("div", {
      "data-testid": "message"
    }, "Loaded this message: ", this.state.data.returnedMessage, "!");
  }

}

test('it waits for the data to be loaded', async () => {
  const {
    queryByText,
    queryByTestId
  } = (0, _.render)(_react.default.createElement(ComponentWithLoader, null));
  expect(queryByText('Loading...')).toBeTruthy();
  await (0, _.wait)(() => expect(queryByText('Loading...')).toBeNull());
  expect(queryByTestId('message').textContent).toMatch(/Hello World/);
});