"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _axios = _interopRequireDefault(require("axios"));

var _ = require("../");

afterEach(_.cleanup); // instead of importing it, we'll define it inline here
// import Fetch from '../fetch'

class Fetch extends _react.default.Component {
  constructor(...args) {
    super(...args);
    this.state = {};

    this.fetch = async () => {
      const response = await _axios.default.get(this.props.url);
      this.setState({
        data: response.data
      });
    };
  }

  componentDidUpdate(prevProps) {
    if (this.props.url !== prevProps.url) {
      this.fetch();
    }
  }

  render() {
    const {
      data
    } = this.state;
    return _react.default.createElement("div", null, _react.default.createElement("button", {
      onClick: this.fetch
    }, "Fetch"), data ? _react.default.createElement("span", null, data.greeting) : null);
  }

}

test('Fetch makes an API call and displays the greeting when load-greeting is clicked', async () => {
  // Arrange
  _axios.default.get.mockResolvedValueOnce({
    data: {
      greeting: 'hello there'
    }
  });

  const url = '/greeting';
  const {
    container,
    getByText
  } = (0, _.render)(_react.default.createElement(Fetch, {
    url: url
  })); // Act

  _.fireEvent.click(getByText('Fetch'));

  await (0, _.wait)(); // Assert

  expect(_axios.default.get).toHaveBeenCalledTimes(1);
  expect(_axios.default.get).toHaveBeenCalledWith(url); // this assertion is funny because if the textContent were not "hello there"
  // then the `getByText` would throw anyway... 🤔

  expect(getByText('hello there').textContent).toBe('hello there');
  expect(container.firstChild).toMatchSnapshot();
});