"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _ = require("../");

afterEach(_.cleanup);

function Login({
  onSubmit
}) {
  return _react.default.createElement("div", null, _react.default.createElement("form", {
    onSubmit: e => {
      e.preventDefault();
      const {
        username,
        password
      } = e.target.elements;
      onSubmit({
        username: username.value,
        password: password.value
      });
    }
  }, _react.default.createElement("label", {
    htmlFor: "username-input"
  }, "Username"), _react.default.createElement("input", {
    id: "username-input",
    placeholder: "Username...",
    name: "username"
  }), _react.default.createElement("label", {
    id: "password-label"
  }, "Password"), _react.default.createElement("input", {
    placeholder: "Password...",
    type: "password",
    name: "password",
    "aria-labelledby": "password-label"
  }), _react.default.createElement("button", {
    type: "submit"
  }, "Submit")));
}

test('login form submits', () => {
  const fakeUser = {
    username: 'jackiechan',
    password: 'hiya! 🥋'
  };
  const handleSubmit = jest.fn();
  const {
    getByLabelText,
    getByText
  } = (0, _.render)(_react.default.createElement(Login, {
    onSubmit: handleSubmit
  }));
  const usernameNode = getByLabelText(/username/i);
  const passwordNode = getByLabelText(/password/i);
  const submitButtonNode = getByText(/submit/i); // Act

  usernameNode.value = fakeUser.username;
  passwordNode.value = fakeUser.password;

  _.fireEvent.click(submitButtonNode); // Assert


  expect(handleSubmit).toHaveBeenCalledTimes(1);
  expect(handleSubmit).toHaveBeenCalledWith(fakeUser);
});
/* eslint jsx-a11y/label-has-for:0, jsx-a11y/aria-proptypes:0 */