"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

require("jest-dom/extend-expect");

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _ = require("../");

afterEach(_.cleanup);
test('renders div into document', () => {
  const ref = _react.default.createRef();

  const {
    container
  } = (0, _.render)(_react.default.createElement("div", {
    ref: ref
  }));
  expect(container.firstChild).toBe(ref.current);
});
test('works great with react portals', () => {
  class MyPortal extends _react.default.Component {
    constructor(...args) {
      super(...args);
      this.portalNode = document.createElement('div');
      this.portalNode.dataset.testid = 'my-portal';
    }

    componentDidMount() {
      document.body.appendChild(this.portalNode);
    }

    componentWillUnmount() {
      this.portalNode.parentNode.removeChild(this.portalNode);
    }

    render() {
      return _reactDom.default.createPortal(_react.default.createElement(Greet, {
        greeting: "Hello",
        subject: "World"
      }), this.portalNode);
    }

  }

  function Greet({
    greeting,
    subject
  }) {
    return _react.default.createElement("div", null, _react.default.createElement("strong", null, greeting, " ", subject));
  }

  const {
    unmount,
    getByTestId,
    getByText
  } = (0, _.render)(_react.default.createElement(MyPortal, null));
  expect(getByText('Hello World')).toBeInTheDocument();
  const portalNode = getByTestId('my-portal');
  expect(portalNode).toBeInTheDocument();
  unmount();
  expect(portalNode).not.toBeInTheDocument();
});
test('returns baseElement which defaults to document.body', () => {
  const {
    baseElement
  } = (0, _.render)(_react.default.createElement("div", null));
  expect(baseElement).toBe(document.body);
});
it('cleansup document', () => {
  const spy = jest.fn();
  const divId = 'my-div';

  class Test extends _react.default.Component {
    componentWillUnmount() {
      expect(document.getElementById(divId)).toBeInTheDocument();
      spy();
    }

    render() {
      return _react.default.createElement("div", {
        id: divId
      });
    }

  }

  (0, _.render)(_react.default.createElement(Test, null));
  (0, _.cleanup)();
  expect(document.body.innerHTML).toBe('');
  expect(spy).toHaveBeenCalledTimes(1);
});
it('supports fragments', () => {
  class Test extends _react.default.Component {
    render() {
      return _react.default.createElement("div", null, _react.default.createElement("code", null, "DocumentFragment"), " is pretty cool!");
    }

  }

  const {
    asFragment
  } = (0, _.render)(_react.default.createElement(Test, null));
  expect(asFragment()).toMatchSnapshot();
  (0, _.cleanup)();
  expect(document.body.innerHTML).toBe('');
});
test('renders options.wrapper around node', () => {
  const {
    container,
    getByTestId
  } = (0, _.render)(_react.default.createElement("div", {
    "data-testid": "inner"
  }), {
    wrapper: ({
      children
    }) => _react.default.createElement("div", {
      "data-testid": "wrapper"
    }, children)
  });
  expect(getByTestId('wrapper')).toBeInTheDocument();
  expect(container.firstChild).toMatchInlineSnapshot(`
<div
  data-testid="wrapper"
>
  <div
    data-testid="inner"
  />
</div>
`);
});