"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _ = require("../");

require("jest-dom/extend-expect");

afterEach(_.cleanup);
test('rerender will re-render the element', () => {
  const Greeting = props => _react.default.createElement("div", null, props.message);

  const {
    container,
    rerender
  } = (0, _.render)(_react.default.createElement(Greeting, {
    message: "hi"
  }));
  expect(container.firstChild).toHaveTextContent('hi');
  rerender(_react.default.createElement(Greeting, {
    message: "hey"
  }));
  expect(container.firstChild).toHaveTextContent('hey');
});
test('hydrate will not update props until next render', () => {
  const container = document.body.appendChild(document.createElement('div'));
  container.innerHTML = '<input />';
  const input = container.querySelector('input');
  const firstValue = 'hello';
  if (!input) throw new Error('No element');
  input.value = firstValue;
  const {
    rerender
  } = (0, _.render)(_react.default.createElement("input", {
    value: "",
    onChange: () => null
  }), {
    container,
    hydrate: true
  });
  const secondValue = 'goodbye';
  expect(input.value).toBe(firstValue);
  rerender(_react.default.createElement("input", {
    value: secondValue,
    onChange: () => null
  }));
  expect(input.value).toBe(secondValue);
});