(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react'), require('react-dom')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react', 'react-dom'], factory) :
  (global = global || self, factory(global.ReactTestingLibrary = {}, global.React, global.ReactDom));
}(this, function (exports, React, ReactDOM) { 'use strict';

  React = React && React.hasOwnProperty('default') ? React['default'] : React;
  ReactDOM = ReactDOM && ReactDOM.hasOwnProperty('default') ? ReactDOM['default'] : ReactDOM;

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function unwrapExports (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var runtime_1 = createCommonjsModule(function (module) {
    /**
     * Copyright (c) 2014-present, Facebook, Inc.
     *
     * This source code is licensed under the MIT license found in the
     * LICENSE file in the root directory of this source tree.
     */
    var runtime = function (exports) {

      var Op = Object.prototype;
      var hasOwn = Op.hasOwnProperty;
      var undefined$1; // More compressible than void 0.

      var $Symbol = typeof Symbol === "function" ? Symbol : {};
      var iteratorSymbol = $Symbol.iterator || "@@iterator";
      var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
      var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

      function wrap(innerFn, outerFn, self, tryLocsList) {
        // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
        var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
        var generator = Object.create(protoGenerator.prototype);
        var context = new Context(tryLocsList || []); // The ._invoke method unifies the implementations of the .next,
        // .throw, and .return methods.

        generator._invoke = makeInvokeMethod(innerFn, self, context);
        return generator;
      }

      exports.wrap = wrap; // Try/catch helper to minimize deoptimizations. Returns a completion
      // record like context.tryEntries[i].completion. This interface could
      // have been (and was previously) designed to take a closure to be
      // invoked without arguments, but in all the cases we care about we
      // already have an existing method we want to call, so there's no need
      // to create a new function object. We can even get away with assuming
      // the method takes exactly one argument, since that happens to be true
      // in every case, so we don't have to touch the arguments object. The
      // only additional allocation required is the completion record, which
      // has a stable shape and so hopefully should be cheap to allocate.

      function tryCatch(fn, obj, arg) {
        try {
          return {
            type: "normal",
            arg: fn.call(obj, arg)
          };
        } catch (err) {
          return {
            type: "throw",
            arg: err
          };
        }
      }

      var GenStateSuspendedStart = "suspendedStart";
      var GenStateExecuting = "executing";
      var GenStateCompleted = "completed"; // Returning this object from the innerFn has the same effect as
      // breaking out of the dispatch switch statement.

      var ContinueSentinel = {}; // Dummy constructor functions that we use as the .constructor and
      // .constructor.prototype properties for functions that return Generator
      // objects. For full spec compliance, you may wish to configure your
      // minifier not to mangle the names of these two functions.

      function Generator() {}

      function GeneratorFunction() {}

      function GeneratorFunctionPrototype() {} // This is a polyfill for %IteratorPrototype% for environments that
      // don't natively support it.


      var IteratorPrototype = {};

      IteratorPrototype[iteratorSymbol] = function () {
        return this;
      };

      var getProto = Object.getPrototypeOf;
      var NativeIteratorPrototype = getProto && getProto(getProto(values([])));

      if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
        // This environment has a native %IteratorPrototype%; use it instead
        // of the polyfill.
        IteratorPrototype = NativeIteratorPrototype;
      }

      var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
      GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
      GeneratorFunctionPrototype.constructor = GeneratorFunction;
      GeneratorFunctionPrototype[toStringTagSymbol] = GeneratorFunction.displayName = "GeneratorFunction"; // Helper for defining the .next, .throw, and .return methods of the
      // Iterator interface in terms of a single ._invoke method.

      function defineIteratorMethods(prototype) {
        ["next", "throw", "return"].forEach(function (method) {
          prototype[method] = function (arg) {
            return this._invoke(method, arg);
          };
        });
      }

      exports.isGeneratorFunction = function (genFun) {
        var ctor = typeof genFun === "function" && genFun.constructor;
        return ctor ? ctor === GeneratorFunction || // For the native GeneratorFunction constructor, the best we can
        // do is to check its .name property.
        (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
      };

      exports.mark = function (genFun) {
        if (Object.setPrototypeOf) {
          Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
        } else {
          genFun.__proto__ = GeneratorFunctionPrototype;

          if (!(toStringTagSymbol in genFun)) {
            genFun[toStringTagSymbol] = "GeneratorFunction";
          }
        }

        genFun.prototype = Object.create(Gp);
        return genFun;
      }; // Within the body of any async function, `await x` is transformed to
      // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
      // `hasOwn.call(value, "__await")` to determine if the yielded value is
      // meant to be awaited.


      exports.awrap = function (arg) {
        return {
          __await: arg
        };
      };

      function AsyncIterator(generator) {
        function invoke(method, arg, resolve, reject) {
          var record = tryCatch(generator[method], generator, arg);

          if (record.type === "throw") {
            reject(record.arg);
          } else {
            var result = record.arg;
            var value = result.value;

            if (value && typeof value === "object" && hasOwn.call(value, "__await")) {
              return Promise.resolve(value.__await).then(function (value) {
                invoke("next", value, resolve, reject);
              }, function (err) {
                invoke("throw", err, resolve, reject);
              });
            }

            return Promise.resolve(value).then(function (unwrapped) {
              // When a yielded Promise is resolved, its final value becomes
              // the .value of the Promise<{value,done}> result for the
              // current iteration.
              result.value = unwrapped;
              resolve(result);
            }, function (error) {
              // If a rejected Promise was yielded, throw the rejection back
              // into the async generator function so it can be handled there.
              return invoke("throw", error, resolve, reject);
            });
          }
        }

        var previousPromise;

        function enqueue(method, arg) {
          function callInvokeWithMethodAndArg() {
            return new Promise(function (resolve, reject) {
              invoke(method, arg, resolve, reject);
            });
          }

          return previousPromise = // If enqueue has been called before, then we want to wait until
          // all previous Promises have been resolved before calling invoke,
          // so that results are always delivered in the correct order. If
          // enqueue has not been called before, then it is important to
          // call invoke immediately, without waiting on a callback to fire,
          // so that the async generator function has the opportunity to do
          // any necessary setup in a predictable way. This predictability
          // is why the Promise constructor synchronously invokes its
          // executor callback, and why async functions synchronously
          // execute code before the first await. Since we implement simple
          // async functions in terms of async generators, it is especially
          // important to get this right, even though it requires care.
          previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, // Avoid propagating failures to Promises returned by later
          // invocations of the iterator.
          callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
        } // Define the unified helper method that is used to implement .next,
        // .throw, and .return (see defineIteratorMethods).


        this._invoke = enqueue;
      }

      defineIteratorMethods(AsyncIterator.prototype);

      AsyncIterator.prototype[asyncIteratorSymbol] = function () {
        return this;
      };

      exports.AsyncIterator = AsyncIterator; // Note that simple async functions are implemented on top of
      // AsyncIterator objects; they just return a Promise for the value of
      // the final result produced by the iterator.

      exports.async = function (innerFn, outerFn, self, tryLocsList) {
        var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList));
        return exports.isGeneratorFunction(outerFn) ? iter // If outerFn is a generator, return the full iterator.
        : iter.next().then(function (result) {
          return result.done ? result.value : iter.next();
        });
      };

      function makeInvokeMethod(innerFn, self, context) {
        var state = GenStateSuspendedStart;
        return function (method, arg) {
          if (state === GenStateExecuting) {
            throw new Error("Generator is already running");
          }

          if (state === GenStateCompleted) {
            if (method === "throw") {
              throw arg;
            } // Be forgiving, per 25.3.3.3.3 of the spec:
            // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume


            return doneResult();
          }

          context.method = method;
          context.arg = arg;

          while (true) {
            var delegate = context.delegate;

            if (delegate) {
              var delegateResult = maybeInvokeDelegate(delegate, context);

              if (delegateResult) {
                if (delegateResult === ContinueSentinel) continue;
                return delegateResult;
              }
            }

            if (context.method === "next") {
              // Setting context._sent for legacy support of Babel's
              // function.sent implementation.
              context.sent = context._sent = context.arg;
            } else if (context.method === "throw") {
              if (state === GenStateSuspendedStart) {
                state = GenStateCompleted;
                throw context.arg;
              }

              context.dispatchException(context.arg);
            } else if (context.method === "return") {
              context.abrupt("return", context.arg);
            }

            state = GenStateExecuting;
            var record = tryCatch(innerFn, self, context);

            if (record.type === "normal") {
              // If an exception is thrown from innerFn, we leave state ===
              // GenStateExecuting and loop back for another invocation.
              state = context.done ? GenStateCompleted : "suspendedYield";

              if (record.arg === ContinueSentinel) {
                continue;
              }

              return {
                value: record.arg,
                done: context.done
              };
            } else if (record.type === "throw") {
              state = GenStateCompleted; // Dispatch the exception by looping back around to the
              // context.dispatchException(context.arg) call above.

              context.method = "throw";
              context.arg = record.arg;
            }
          }
        };
      } // Call delegate.iterator[context.method](context.arg) and handle the
      // result, either by returning a { value, done } result from the
      // delegate iterator, or by modifying context.method and context.arg,
      // setting context.delegate to null, and returning the ContinueSentinel.


      function maybeInvokeDelegate(delegate, context) {
        var method = delegate.iterator[context.method];

        if (method === undefined$1) {
          // A .throw or .return when the delegate iterator has no .throw
          // method always terminates the yield* loop.
          context.delegate = null;

          if (context.method === "throw") {
            // Note: ["return"] must be used for ES3 parsing compatibility.
            if (delegate.iterator["return"]) {
              // If the delegate iterator has a return method, give it a
              // chance to clean up.
              context.method = "return";
              context.arg = undefined$1;
              maybeInvokeDelegate(delegate, context);

              if (context.method === "throw") {
                // If maybeInvokeDelegate(context) changed context.method from
                // "return" to "throw", let that override the TypeError below.
                return ContinueSentinel;
              }
            }

            context.method = "throw";
            context.arg = new TypeError("The iterator does not provide a 'throw' method");
          }

          return ContinueSentinel;
        }

        var record = tryCatch(method, delegate.iterator, context.arg);

        if (record.type === "throw") {
          context.method = "throw";
          context.arg = record.arg;
          context.delegate = null;
          return ContinueSentinel;
        }

        var info = record.arg;

        if (!info) {
          context.method = "throw";
          context.arg = new TypeError("iterator result is not an object");
          context.delegate = null;
          return ContinueSentinel;
        }

        if (info.done) {
          // Assign the result of the finished delegate to the temporary
          // variable specified by delegate.resultName (see delegateYield).
          context[delegate.resultName] = info.value; // Resume execution at the desired location (see delegateYield).

          context.next = delegate.nextLoc; // If context.method was "throw" but the delegate handled the
          // exception, let the outer generator proceed normally. If
          // context.method was "next", forget context.arg since it has been
          // "consumed" by the delegate iterator. If context.method was
          // "return", allow the original .return call to continue in the
          // outer generator.

          if (context.method !== "return") {
            context.method = "next";
            context.arg = undefined$1;
          }
        } else {
          // Re-yield the result returned by the delegate method.
          return info;
        } // The delegate iterator is finished, so forget it and continue with
        // the outer generator.


        context.delegate = null;
        return ContinueSentinel;
      } // Define Generator.prototype.{next,throw,return} in terms of the
      // unified ._invoke helper method.


      defineIteratorMethods(Gp);
      Gp[toStringTagSymbol] = "Generator"; // A Generator should always return itself as the iterator object when the
      // @@iterator function is called on it. Some browsers' implementations of the
      // iterator prototype chain incorrectly implement this, causing the Generator
      // object to not be returned from this call. This ensures that doesn't happen.
      // See https://github.com/facebook/regenerator/issues/274 for more details.

      Gp[iteratorSymbol] = function () {
        return this;
      };

      Gp.toString = function () {
        return "[object Generator]";
      };

      function pushTryEntry(locs) {
        var entry = {
          tryLoc: locs[0]
        };

        if (1 in locs) {
          entry.catchLoc = locs[1];
        }

        if (2 in locs) {
          entry.finallyLoc = locs[2];
          entry.afterLoc = locs[3];
        }

        this.tryEntries.push(entry);
      }

      function resetTryEntry(entry) {
        var record = entry.completion || {};
        record.type = "normal";
        delete record.arg;
        entry.completion = record;
      }

      function Context(tryLocsList) {
        // The root entry object (effectively a try statement without a catch
        // or a finally block) gives us a place to store values thrown from
        // locations where there is no enclosing try statement.
        this.tryEntries = [{
          tryLoc: "root"
        }];
        tryLocsList.forEach(pushTryEntry, this);
        this.reset(true);
      }

      exports.keys = function (object) {
        var keys = [];

        for (var key in object) {
          keys.push(key);
        }

        keys.reverse(); // Rather than returning an object with a next method, we keep
        // things simple and return the next function itself.

        return function next() {
          while (keys.length) {
            var key = keys.pop();

            if (key in object) {
              next.value = key;
              next.done = false;
              return next;
            }
          } // To avoid creating an additional object, we just hang the .value
          // and .done properties off the next function object itself. This
          // also ensures that the minifier will not anonymize the function.


          next.done = true;
          return next;
        };
      };

      function values(iterable) {
        if (iterable) {
          var iteratorMethod = iterable[iteratorSymbol];

          if (iteratorMethod) {
            return iteratorMethod.call(iterable);
          }

          if (typeof iterable.next === "function") {
            return iterable;
          }

          if (!isNaN(iterable.length)) {
            var i = -1,
                next = function next() {
              while (++i < iterable.length) {
                if (hasOwn.call(iterable, i)) {
                  next.value = iterable[i];
                  next.done = false;
                  return next;
                }
              }

              next.value = undefined$1;
              next.done = true;
              return next;
            };

            return next.next = next;
          }
        } // Return an iterator with no values.


        return {
          next: doneResult
        };
      }

      exports.values = values;

      function doneResult() {
        return {
          value: undefined$1,
          done: true
        };
      }

      Context.prototype = {
        constructor: Context,
        reset: function reset(skipTempReset) {
          this.prev = 0;
          this.next = 0; // Resetting context._sent for legacy support of Babel's
          // function.sent implementation.

          this.sent = this._sent = undefined$1;
          this.done = false;
          this.delegate = null;
          this.method = "next";
          this.arg = undefined$1;
          this.tryEntries.forEach(resetTryEntry);

          if (!skipTempReset) {
            for (var name in this) {
              // Not sure about the optimal order of these conditions:
              if (name.charAt(0) === "t" && hasOwn.call(this, name) && !isNaN(+name.slice(1))) {
                this[name] = undefined$1;
              }
            }
          }
        },
        stop: function stop() {
          this.done = true;
          var rootEntry = this.tryEntries[0];
          var rootRecord = rootEntry.completion;

          if (rootRecord.type === "throw") {
            throw rootRecord.arg;
          }

          return this.rval;
        },
        dispatchException: function dispatchException(exception) {
          if (this.done) {
            throw exception;
          }

          var context = this;

          function handle(loc, caught) {
            record.type = "throw";
            record.arg = exception;
            context.next = loc;

            if (caught) {
              // If the dispatched exception was caught by a catch block,
              // then let that catch block handle the exception normally.
              context.method = "next";
              context.arg = undefined$1;
            }

            return !!caught;
          }

          for (var i = this.tryEntries.length - 1; i >= 0; --i) {
            var entry = this.tryEntries[i];
            var record = entry.completion;

            if (entry.tryLoc === "root") {
              // Exception thrown outside of any try block that could handle
              // it, so set the completion value of the entire function to
              // throw the exception.
              return handle("end");
            }

            if (entry.tryLoc <= this.prev) {
              var hasCatch = hasOwn.call(entry, "catchLoc");
              var hasFinally = hasOwn.call(entry, "finallyLoc");

              if (hasCatch && hasFinally) {
                if (this.prev < entry.catchLoc) {
                  return handle(entry.catchLoc, true);
                } else if (this.prev < entry.finallyLoc) {
                  return handle(entry.finallyLoc);
                }
              } else if (hasCatch) {
                if (this.prev < entry.catchLoc) {
                  return handle(entry.catchLoc, true);
                }
              } else if (hasFinally) {
                if (this.prev < entry.finallyLoc) {
                  return handle(entry.finallyLoc);
                }
              } else {
                throw new Error("try statement without catch or finally");
              }
            }
          }
        },
        abrupt: function abrupt(type, arg) {
          for (var i = this.tryEntries.length - 1; i >= 0; --i) {
            var entry = this.tryEntries[i];

            if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
              var finallyEntry = entry;
              break;
            }
          }

          if (finallyEntry && (type === "break" || type === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
            // Ignore the finally entry if control is not jumping to a
            // location outside the try/catch block.
            finallyEntry = null;
          }

          var record = finallyEntry ? finallyEntry.completion : {};
          record.type = type;
          record.arg = arg;

          if (finallyEntry) {
            this.method = "next";
            this.next = finallyEntry.finallyLoc;
            return ContinueSentinel;
          }

          return this.complete(record);
        },
        complete: function complete(record, afterLoc) {
          if (record.type === "throw") {
            throw record.arg;
          }

          if (record.type === "break" || record.type === "continue") {
            this.next = record.arg;
          } else if (record.type === "return") {
            this.rval = this.arg = record.arg;
            this.method = "return";
            this.next = "end";
          } else if (record.type === "normal" && afterLoc) {
            this.next = afterLoc;
          }

          return ContinueSentinel;
        },
        finish: function finish(finallyLoc) {
          for (var i = this.tryEntries.length - 1; i >= 0; --i) {
            var entry = this.tryEntries[i];

            if (entry.finallyLoc === finallyLoc) {
              this.complete(entry.completion, entry.afterLoc);
              resetTryEntry(entry);
              return ContinueSentinel;
            }
          }
        },
        "catch": function _catch(tryLoc) {
          for (var i = this.tryEntries.length - 1; i >= 0; --i) {
            var entry = this.tryEntries[i];

            if (entry.tryLoc === tryLoc) {
              var record = entry.completion;

              if (record.type === "throw") {
                var thrown = record.arg;
                resetTryEntry(entry);
              }

              return thrown;
            }
          } // The context.catch method must only be called with a location
          // argument that corresponds to a known catch block.


          throw new Error("illegal catch attempt");
        },
        delegateYield: function delegateYield(iterable, resultName, nextLoc) {
          this.delegate = {
            iterator: values(iterable),
            resultName: resultName,
            nextLoc: nextLoc
          };

          if (this.method === "next") {
            // Deliberately forget the last sent value so that we don't
            // accidentally pass it on to the delegate.
            this.arg = undefined$1;
          }

          return ContinueSentinel;
        }
      }; // Regardless of whether this script is executing as a CommonJS module
      // or not, return the runtime object so that we can declare the variable
      // regeneratorRuntime in the outer scope, which allows this module to be
      // injected easily by `bin/regenerator --include-runtime script.js`.

      return exports;
    }( // If this script is executing as a CommonJS module, use module.exports
    // as the regeneratorRuntime namespace. Otherwise create a new empty
    // object. Either way, the resulting object will be used to initialize
    // the regeneratorRuntime variable at the top of this file.
    module.exports);

    try {
      regeneratorRuntime = runtime;
    } catch (accidentalStrictMode) {
      // This module should not be running in strict mode, so the above
      // assignment should always work unless something is misconfigured. Just
      // in case runtime.js accidentally runs in strict mode, we can escape
      // strict mode using a global Function call. This could conceivably fail
      // if a Content Security Policy forbids using Function, but in that case
      // the proper solution is to fix the accidental strict mode problem. If
      // you've misconfigured your bundler to force strict mode and applied a
      // CSP to forbid Function, and you're not willing to fix either of those
      // problems, please detail your unique predicament in a GitHub issue.
      Function("r", "regeneratorRuntime = r")(runtime);
    }
  });

  var regenerator = runtime_1;

  function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
      var info = gen[key](arg);
      var value = info.value;
    } catch (error) {
      reject(error);
      return;
    }

    if (info.done) {
      resolve(value);
    } else {
      Promise.resolve(value).then(_next, _throw);
    }
  }

  function _asyncToGenerator(fn) {
    return function () {
      var self = this,
          args = arguments;
      return new Promise(function (resolve, reject) {
        var gen = fn.apply(self, args);

        function _next(value) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
        }

        function _throw(err) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
        }

        _next(undefined);
      });
    };
  }

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    subClass.__proto__ = superClass;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function (o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function (o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _isNativeFunction(fn) {
    return Function.toString.call(fn).indexOf("[native code]") !== -1;
  }

  function isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;

    try {
      Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }

  function _construct() {
    if (isNativeReflectConstruct()) {
      _construct = Reflect.construct;
    } else {
      _construct = function (Parent, args, Class) {
        var a = [null];
        a.push.apply(a, args);
        var Constructor = Function.bind.apply(Parent, a);
        var instance = new Constructor();
        if (Class) _setPrototypeOf(instance, Class.prototype);
        return instance;
      };
    }

    return _construct.apply(null, arguments);
  }

  function _wrapNativeSuper(Class) {
    var _cache = typeof Map === "function" ? new Map() : undefined;

    _wrapNativeSuper = function (Class) {
      if (Class === null || !_isNativeFunction(Class)) return Class;

      if (typeof Class !== "function") {
        throw new TypeError("Super expression must either be null or a function");
      }

      if (typeof _cache !== "undefined") {
        if (_cache.has(Class)) return _cache.get(Class);

        _cache.set(Class, Wrapper);
      }

      function Wrapper() {
        return _construct(Class, arguments, _getPrototypeOf(this).constructor);
      }

      Wrapper.prototype = Object.create(Class.prototype, {
        constructor: {
          value: Wrapper,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
      return _setPrototypeOf(Wrapper, Class);
    };

    return _wrapNativeSuper(Class);
  }

  var colorName = {
    "aliceblue": [240, 248, 255],
    "antiquewhite": [250, 235, 215],
    "aqua": [0, 255, 255],
    "aquamarine": [127, 255, 212],
    "azure": [240, 255, 255],
    "beige": [245, 245, 220],
    "bisque": [255, 228, 196],
    "black": [0, 0, 0],
    "blanchedalmond": [255, 235, 205],
    "blue": [0, 0, 255],
    "blueviolet": [138, 43, 226],
    "brown": [165, 42, 42],
    "burlywood": [222, 184, 135],
    "cadetblue": [95, 158, 160],
    "chartreuse": [127, 255, 0],
    "chocolate": [210, 105, 30],
    "coral": [255, 127, 80],
    "cornflowerblue": [100, 149, 237],
    "cornsilk": [255, 248, 220],
    "crimson": [220, 20, 60],
    "cyan": [0, 255, 255],
    "darkblue": [0, 0, 139],
    "darkcyan": [0, 139, 139],
    "darkgoldenrod": [184, 134, 11],
    "darkgray": [169, 169, 169],
    "darkgreen": [0, 100, 0],
    "darkgrey": [169, 169, 169],
    "darkkhaki": [189, 183, 107],
    "darkmagenta": [139, 0, 139],
    "darkolivegreen": [85, 107, 47],
    "darkorange": [255, 140, 0],
    "darkorchid": [153, 50, 204],
    "darkred": [139, 0, 0],
    "darksalmon": [233, 150, 122],
    "darkseagreen": [143, 188, 143],
    "darkslateblue": [72, 61, 139],
    "darkslategray": [47, 79, 79],
    "darkslategrey": [47, 79, 79],
    "darkturquoise": [0, 206, 209],
    "darkviolet": [148, 0, 211],
    "deeppink": [255, 20, 147],
    "deepskyblue": [0, 191, 255],
    "dimgray": [105, 105, 105],
    "dimgrey": [105, 105, 105],
    "dodgerblue": [30, 144, 255],
    "firebrick": [178, 34, 34],
    "floralwhite": [255, 250, 240],
    "forestgreen": [34, 139, 34],
    "fuchsia": [255, 0, 255],
    "gainsboro": [220, 220, 220],
    "ghostwhite": [248, 248, 255],
    "gold": [255, 215, 0],
    "goldenrod": [218, 165, 32],
    "gray": [128, 128, 128],
    "green": [0, 128, 0],
    "greenyellow": [173, 255, 47],
    "grey": [128, 128, 128],
    "honeydew": [240, 255, 240],
    "hotpink": [255, 105, 180],
    "indianred": [205, 92, 92],
    "indigo": [75, 0, 130],
    "ivory": [255, 255, 240],
    "khaki": [240, 230, 140],
    "lavender": [230, 230, 250],
    "lavenderblush": [255, 240, 245],
    "lawngreen": [124, 252, 0],
    "lemonchiffon": [255, 250, 205],
    "lightblue": [173, 216, 230],
    "lightcoral": [240, 128, 128],
    "lightcyan": [224, 255, 255],
    "lightgoldenrodyellow": [250, 250, 210],
    "lightgray": [211, 211, 211],
    "lightgreen": [144, 238, 144],
    "lightgrey": [211, 211, 211],
    "lightpink": [255, 182, 193],
    "lightsalmon": [255, 160, 122],
    "lightseagreen": [32, 178, 170],
    "lightskyblue": [135, 206, 250],
    "lightslategray": [119, 136, 153],
    "lightslategrey": [119, 136, 153],
    "lightsteelblue": [176, 196, 222],
    "lightyellow": [255, 255, 224],
    "lime": [0, 255, 0],
    "limegreen": [50, 205, 50],
    "linen": [250, 240, 230],
    "magenta": [255, 0, 255],
    "maroon": [128, 0, 0],
    "mediumaquamarine": [102, 205, 170],
    "mediumblue": [0, 0, 205],
    "mediumorchid": [186, 85, 211],
    "mediumpurple": [147, 112, 219],
    "mediumseagreen": [60, 179, 113],
    "mediumslateblue": [123, 104, 238],
    "mediumspringgreen": [0, 250, 154],
    "mediumturquoise": [72, 209, 204],
    "mediumvioletred": [199, 21, 133],
    "midnightblue": [25, 25, 112],
    "mintcream": [245, 255, 250],
    "mistyrose": [255, 228, 225],
    "moccasin": [255, 228, 181],
    "navajowhite": [255, 222, 173],
    "navy": [0, 0, 128],
    "oldlace": [253, 245, 230],
    "olive": [128, 128, 0],
    "olivedrab": [107, 142, 35],
    "orange": [255, 165, 0],
    "orangered": [255, 69, 0],
    "orchid": [218, 112, 214],
    "palegoldenrod": [238, 232, 170],
    "palegreen": [152, 251, 152],
    "paleturquoise": [175, 238, 238],
    "palevioletred": [219, 112, 147],
    "papayawhip": [255, 239, 213],
    "peachpuff": [255, 218, 185],
    "peru": [205, 133, 63],
    "pink": [255, 192, 203],
    "plum": [221, 160, 221],
    "powderblue": [176, 224, 230],
    "purple": [128, 0, 128],
    "rebeccapurple": [102, 51, 153],
    "red": [255, 0, 0],
    "rosybrown": [188, 143, 143],
    "royalblue": [65, 105, 225],
    "saddlebrown": [139, 69, 19],
    "salmon": [250, 128, 114],
    "sandybrown": [244, 164, 96],
    "seagreen": [46, 139, 87],
    "seashell": [255, 245, 238],
    "sienna": [160, 82, 45],
    "silver": [192, 192, 192],
    "skyblue": [135, 206, 235],
    "slateblue": [106, 90, 205],
    "slategray": [112, 128, 144],
    "slategrey": [112, 128, 144],
    "snow": [255, 250, 250],
    "springgreen": [0, 255, 127],
    "steelblue": [70, 130, 180],
    "tan": [210, 180, 140],
    "teal": [0, 128, 128],
    "thistle": [216, 191, 216],
    "tomato": [255, 99, 71],
    "turquoise": [64, 224, 208],
    "violet": [238, 130, 238],
    "wheat": [245, 222, 179],
    "white": [255, 255, 255],
    "whitesmoke": [245, 245, 245],
    "yellow": [255, 255, 0],
    "yellowgreen": [154, 205, 50]
  };

  var conversions = createCommonjsModule(function (module) {
    /* MIT license */
    // NOTE: conversions should only return primitive values (i.e. arrays, or
    //       values that give correct `typeof` results).
    //       do not use box values types (i.e. Number(), String(), etc.)
    var reverseKeywords = {};

    for (var key in colorName) {
      if (colorName.hasOwnProperty(key)) {
        reverseKeywords[colorName[key]] = key;
      }
    }

    var convert = module.exports = {
      rgb: {
        channels: 3,
        labels: 'rgb'
      },
      hsl: {
        channels: 3,
        labels: 'hsl'
      },
      hsv: {
        channels: 3,
        labels: 'hsv'
      },
      hwb: {
        channels: 3,
        labels: 'hwb'
      },
      cmyk: {
        channels: 4,
        labels: 'cmyk'
      },
      xyz: {
        channels: 3,
        labels: 'xyz'
      },
      lab: {
        channels: 3,
        labels: 'lab'
      },
      lch: {
        channels: 3,
        labels: 'lch'
      },
      hex: {
        channels: 1,
        labels: ['hex']
      },
      keyword: {
        channels: 1,
        labels: ['keyword']
      },
      ansi16: {
        channels: 1,
        labels: ['ansi16']
      },
      ansi256: {
        channels: 1,
        labels: ['ansi256']
      },
      hcg: {
        channels: 3,
        labels: ['h', 'c', 'g']
      },
      apple: {
        channels: 3,
        labels: ['r16', 'g16', 'b16']
      },
      gray: {
        channels: 1,
        labels: ['gray']
      }
    }; // hide .channels and .labels properties

    for (var model in convert) {
      if (convert.hasOwnProperty(model)) {
        if (!('channels' in convert[model])) {
          throw new Error('missing channels property: ' + model);
        }

        if (!('labels' in convert[model])) {
          throw new Error('missing channel labels property: ' + model);
        }

        if (convert[model].labels.length !== convert[model].channels) {
          throw new Error('channel and label counts mismatch: ' + model);
        }

        var channels = convert[model].channels;
        var labels = convert[model].labels;
        delete convert[model].channels;
        delete convert[model].labels;
        Object.defineProperty(convert[model], 'channels', {
          value: channels
        });
        Object.defineProperty(convert[model], 'labels', {
          value: labels
        });
      }
    }

    convert.rgb.hsl = function (rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var min = Math.min(r, g, b);
      var max = Math.max(r, g, b);
      var delta = max - min;
      var h;
      var s;
      var l;

      if (max === min) {
        h = 0;
      } else if (r === max) {
        h = (g - b) / delta;
      } else if (g === max) {
        h = 2 + (b - r) / delta;
      } else if (b === max) {
        h = 4 + (r - g) / delta;
      }

      h = Math.min(h * 60, 360);

      if (h < 0) {
        h += 360;
      }

      l = (min + max) / 2;

      if (max === min) {
        s = 0;
      } else if (l <= 0.5) {
        s = delta / (max + min);
      } else {
        s = delta / (2 - max - min);
      }

      return [h, s * 100, l * 100];
    };

    convert.rgb.hsv = function (rgb) {
      var rdif;
      var gdif;
      var bdif;
      var h;
      var s;
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var v = Math.max(r, g, b);
      var diff = v - Math.min(r, g, b);

      var diffc = function (c) {
        return (v - c) / 6 / diff + 1 / 2;
      };

      if (diff === 0) {
        h = s = 0;
      } else {
        s = diff / v;
        rdif = diffc(r);
        gdif = diffc(g);
        bdif = diffc(b);

        if (r === v) {
          h = bdif - gdif;
        } else if (g === v) {
          h = 1 / 3 + rdif - bdif;
        } else if (b === v) {
          h = 2 / 3 + gdif - rdif;
        }

        if (h < 0) {
          h += 1;
        } else if (h > 1) {
          h -= 1;
        }
      }

      return [h * 360, s * 100, v * 100];
    };

    convert.rgb.hwb = function (rgb) {
      var r = rgb[0];
      var g = rgb[1];
      var b = rgb[2];
      var h = convert.rgb.hsl(rgb)[0];
      var w = 1 / 255 * Math.min(r, Math.min(g, b));
      b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));
      return [h, w * 100, b * 100];
    };

    convert.rgb.cmyk = function (rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var c;
      var m;
      var y;
      var k = Math.min(1 - r, 1 - g, 1 - b);
      c = (1 - r - k) / (1 - k) || 0;
      m = (1 - g - k) / (1 - k) || 0;
      y = (1 - b - k) / (1 - k) || 0;
      return [c * 100, m * 100, y * 100, k * 100];
    };
    /**
     * See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
     * */


    function comparativeDistance(x, y) {
      return Math.pow(x[0] - y[0], 2) + Math.pow(x[1] - y[1], 2) + Math.pow(x[2] - y[2], 2);
    }

    convert.rgb.keyword = function (rgb) {
      var reversed = reverseKeywords[rgb];

      if (reversed) {
        return reversed;
      }

      var currentClosestDistance = Infinity;
      var currentClosestKeyword;

      for (var keyword in colorName) {
        if (colorName.hasOwnProperty(keyword)) {
          var value = colorName[keyword]; // Compute comparative distance

          var distance = comparativeDistance(rgb, value); // Check if its less, if so set as closest

          if (distance < currentClosestDistance) {
            currentClosestDistance = distance;
            currentClosestKeyword = keyword;
          }
        }
      }

      return currentClosestKeyword;
    };

    convert.keyword.rgb = function (keyword) {
      return colorName[keyword];
    };

    convert.rgb.xyz = function (rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255; // assume sRGB

      r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : r / 12.92;
      g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : g / 12.92;
      b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : b / 12.92;
      var x = r * 0.4124 + g * 0.3576 + b * 0.1805;
      var y = r * 0.2126 + g * 0.7152 + b * 0.0722;
      var z = r * 0.0193 + g * 0.1192 + b * 0.9505;
      return [x * 100, y * 100, z * 100];
    };

    convert.rgb.lab = function (rgb) {
      var xyz = convert.rgb.xyz(rgb);
      var x = xyz[0];
      var y = xyz[1];
      var z = xyz[2];
      var l;
      var a;
      var b;
      x /= 95.047;
      y /= 100;
      z /= 108.883;
      x = x > 0.008856 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
      y = y > 0.008856 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
      z = z > 0.008856 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
      l = 116 * y - 16;
      a = 500 * (x - y);
      b = 200 * (y - z);
      return [l, a, b];
    };

    convert.hsl.rgb = function (hsl) {
      var h = hsl[0] / 360;
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var t1;
      var t2;
      var t3;
      var rgb;
      var val;

      if (s === 0) {
        val = l * 255;
        return [val, val, val];
      }

      if (l < 0.5) {
        t2 = l * (1 + s);
      } else {
        t2 = l + s - l * s;
      }

      t1 = 2 * l - t2;
      rgb = [0, 0, 0];

      for (var i = 0; i < 3; i++) {
        t3 = h + 1 / 3 * -(i - 1);

        if (t3 < 0) {
          t3++;
        }

        if (t3 > 1) {
          t3--;
        }

        if (6 * t3 < 1) {
          val = t1 + (t2 - t1) * 6 * t3;
        } else if (2 * t3 < 1) {
          val = t2;
        } else if (3 * t3 < 2) {
          val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
        } else {
          val = t1;
        }

        rgb[i] = val * 255;
      }

      return rgb;
    };

    convert.hsl.hsv = function (hsl) {
      var h = hsl[0];
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var smin = s;
      var lmin = Math.max(l, 0.01);
      var sv;
      var v;
      l *= 2;
      s *= l <= 1 ? l : 2 - l;
      smin *= lmin <= 1 ? lmin : 2 - lmin;
      v = (l + s) / 2;
      sv = l === 0 ? 2 * smin / (lmin + smin) : 2 * s / (l + s);
      return [h, sv * 100, v * 100];
    };

    convert.hsv.rgb = function (hsv) {
      var h = hsv[0] / 60;
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var hi = Math.floor(h) % 6;
      var f = h - Math.floor(h);
      var p = 255 * v * (1 - s);
      var q = 255 * v * (1 - s * f);
      var t = 255 * v * (1 - s * (1 - f));
      v *= 255;

      switch (hi) {
        case 0:
          return [v, t, p];

        case 1:
          return [q, v, p];

        case 2:
          return [p, v, t];

        case 3:
          return [p, q, v];

        case 4:
          return [t, p, v];

        case 5:
          return [v, p, q];
      }
    };

    convert.hsv.hsl = function (hsv) {
      var h = hsv[0];
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var vmin = Math.max(v, 0.01);
      var lmin;
      var sl;
      var l = (2 - s) * v;
      lmin = (2 - s) * vmin;
      sl = s * vmin;
      sl /= lmin <= 1 ? lmin : 2 - lmin;
      sl = sl || 0;
      l /= 2;
      return [h, sl * 100, l * 100];
    }; // http://dev.w3.org/csswg/css-color/#hwb-to-rgb


    convert.hwb.rgb = function (hwb) {
      var h = hwb[0] / 360;
      var wh = hwb[1] / 100;
      var bl = hwb[2] / 100;
      var ratio = wh + bl;
      var i;
      var v;
      var f;
      var n; // wh + bl cant be > 1

      if (ratio > 1) {
        wh /= ratio;
        bl /= ratio;
      }

      i = Math.floor(6 * h);
      v = 1 - bl;
      f = 6 * h - i;

      if ((i & 0x01) !== 0) {
        f = 1 - f;
      }

      n = wh + f * (v - wh); // linear interpolation

      var r;
      var g;
      var b;

      switch (i) {
        default:
        case 6:
        case 0:
          r = v;
          g = n;
          b = wh;
          break;

        case 1:
          r = n;
          g = v;
          b = wh;
          break;

        case 2:
          r = wh;
          g = v;
          b = n;
          break;

        case 3:
          r = wh;
          g = n;
          b = v;
          break;

        case 4:
          r = n;
          g = wh;
          b = v;
          break;

        case 5:
          r = v;
          g = wh;
          b = n;
          break;
      }

      return [r * 255, g * 255, b * 255];
    };

    convert.cmyk.rgb = function (cmyk) {
      var c = cmyk[0] / 100;
      var m = cmyk[1] / 100;
      var y = cmyk[2] / 100;
      var k = cmyk[3] / 100;
      var r;
      var g;
      var b;
      r = 1 - Math.min(1, c * (1 - k) + k);
      g = 1 - Math.min(1, m * (1 - k) + k);
      b = 1 - Math.min(1, y * (1 - k) + k);
      return [r * 255, g * 255, b * 255];
    };

    convert.xyz.rgb = function (xyz) {
      var x = xyz[0] / 100;
      var y = xyz[1] / 100;
      var z = xyz[2] / 100;
      var r;
      var g;
      var b;
      r = x * 3.2406 + y * -1.5372 + z * -0.4986;
      g = x * -0.9689 + y * 1.8758 + z * 0.0415;
      b = x * 0.0557 + y * -0.2040 + z * 1.0570; // assume sRGB

      r = r > 0.0031308 ? 1.055 * Math.pow(r, 1.0 / 2.4) - 0.055 : r * 12.92;
      g = g > 0.0031308 ? 1.055 * Math.pow(g, 1.0 / 2.4) - 0.055 : g * 12.92;
      b = b > 0.0031308 ? 1.055 * Math.pow(b, 1.0 / 2.4) - 0.055 : b * 12.92;
      r = Math.min(Math.max(0, r), 1);
      g = Math.min(Math.max(0, g), 1);
      b = Math.min(Math.max(0, b), 1);
      return [r * 255, g * 255, b * 255];
    };

    convert.xyz.lab = function (xyz) {
      var x = xyz[0];
      var y = xyz[1];
      var z = xyz[2];
      var l;
      var a;
      var b;
      x /= 95.047;
      y /= 100;
      z /= 108.883;
      x = x > 0.008856 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
      y = y > 0.008856 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
      z = z > 0.008856 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
      l = 116 * y - 16;
      a = 500 * (x - y);
      b = 200 * (y - z);
      return [l, a, b];
    };

    convert.lab.xyz = function (lab) {
      var l = lab[0];
      var a = lab[1];
      var b = lab[2];
      var x;
      var y;
      var z;
      y = (l + 16) / 116;
      x = a / 500 + y;
      z = y - b / 200;
      var y2 = Math.pow(y, 3);
      var x2 = Math.pow(x, 3);
      var z2 = Math.pow(z, 3);
      y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
      x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
      z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;
      x *= 95.047;
      y *= 100;
      z *= 108.883;
      return [x, y, z];
    };

    convert.lab.lch = function (lab) {
      var l = lab[0];
      var a = lab[1];
      var b = lab[2];
      var hr;
      var h;
      var c;
      hr = Math.atan2(b, a);
      h = hr * 360 / 2 / Math.PI;

      if (h < 0) {
        h += 360;
      }

      c = Math.sqrt(a * a + b * b);
      return [l, c, h];
    };

    convert.lch.lab = function (lch) {
      var l = lch[0];
      var c = lch[1];
      var h = lch[2];
      var a;
      var b;
      var hr = h / 360 * 2 * Math.PI;
      a = c * Math.cos(hr);
      b = c * Math.sin(hr);
      return [l, a, b];
    };

    convert.rgb.ansi16 = function (args) {
      var r = args[0];
      var g = args[1];
      var b = args[2];
      var value = 1 in arguments ? arguments[1] : convert.rgb.hsv(args)[2]; // hsv -> ansi16 optimization

      value = Math.round(value / 50);

      if (value === 0) {
        return 30;
      }

      var ansi = 30 + (Math.round(b / 255) << 2 | Math.round(g / 255) << 1 | Math.round(r / 255));

      if (value === 2) {
        ansi += 60;
      }

      return ansi;
    };

    convert.hsv.ansi16 = function (args) {
      // optimization here; we already know the value and don't need to get
      // it converted for us.
      return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
    };

    convert.rgb.ansi256 = function (args) {
      var r = args[0];
      var g = args[1];
      var b = args[2]; // we use the extended greyscale palette here, with the exception of
      // black and white. normal palette only has 4 greyscale shades.

      if (r === g && g === b) {
        if (r < 8) {
          return 16;
        }

        if (r > 248) {
          return 231;
        }

        return Math.round((r - 8) / 247 * 24) + 232;
      }

      var ansi = 16 + 36 * Math.round(r / 255 * 5) + 6 * Math.round(g / 255 * 5) + Math.round(b / 255 * 5);
      return ansi;
    };

    convert.ansi16.rgb = function (args) {
      var color = args % 10; // handle greyscale

      if (color === 0 || color === 7) {
        if (args > 50) {
          color += 3.5;
        }

        color = color / 10.5 * 255;
        return [color, color, color];
      }

      var mult = (~~(args > 50) + 1) * 0.5;
      var r = (color & 1) * mult * 255;
      var g = (color >> 1 & 1) * mult * 255;
      var b = (color >> 2 & 1) * mult * 255;
      return [r, g, b];
    };

    convert.ansi256.rgb = function (args) {
      // handle greyscale
      if (args >= 232) {
        var c = (args - 232) * 10 + 8;
        return [c, c, c];
      }

      args -= 16;
      var rem;
      var r = Math.floor(args / 36) / 5 * 255;
      var g = Math.floor((rem = args % 36) / 6) / 5 * 255;
      var b = rem % 6 / 5 * 255;
      return [r, g, b];
    };

    convert.rgb.hex = function (args) {
      var integer = ((Math.round(args[0]) & 0xFF) << 16) + ((Math.round(args[1]) & 0xFF) << 8) + (Math.round(args[2]) & 0xFF);
      var string = integer.toString(16).toUpperCase();
      return '000000'.substring(string.length) + string;
    };

    convert.hex.rgb = function (args) {
      var match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);

      if (!match) {
        return [0, 0, 0];
      }

      var colorString = match[0];

      if (match[0].length === 3) {
        colorString = colorString.split('').map(function (char) {
          return char + char;
        }).join('');
      }

      var integer = parseInt(colorString, 16);
      return [integer >> 16 & 0xFF, integer >> 8 & 0xFF, integer & 0xFF];
    };

    convert.rgb.hcg = function (rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var max = Math.max(Math.max(r, g), b);
      var min = Math.min(Math.min(r, g), b);
      var chroma = max - min;
      var grayscale;
      var hue;

      if (chroma < 1) {
        grayscale = min / (1 - chroma);
      } else {
        grayscale = 0;
      }

      if (chroma <= 0) {
        hue = 0;
      } else if (max === r) {
        hue = (g - b) / chroma % 6;
      } else if (max === g) {
        hue = 2 + (b - r) / chroma;
      } else {
        hue = 4 + (r - g) / chroma + 4;
      }

      hue /= 6;
      hue %= 1;
      return [hue * 360, chroma * 100, grayscale * 100];
    };

    convert.hsl.hcg = function (hsl) {
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var c = 1;
      var f = 0;

      if (l < 0.5) {
        c = 2.0 * s * l;
      } else {
        c = 2.0 * s * (1.0 - l);
      }

      if (c < 1.0) {
        f = (l - 0.5 * c) / (1.0 - c);
      }

      return [hsl[0], c * 100, f * 100];
    };

    convert.hsv.hcg = function (hsv) {
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var c = s * v;
      var f = 0;

      if (c < 1.0) {
        f = (v - c) / (1 - c);
      }

      return [hsv[0], c * 100, f * 100];
    };

    convert.hcg.rgb = function (hcg) {
      var h = hcg[0] / 360;
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;

      if (c === 0.0) {
        return [g * 255, g * 255, g * 255];
      }

      var pure = [0, 0, 0];
      var hi = h % 1 * 6;
      var v = hi % 1;
      var w = 1 - v;
      var mg = 0;

      switch (Math.floor(hi)) {
        case 0:
          pure[0] = 1;
          pure[1] = v;
          pure[2] = 0;
          break;

        case 1:
          pure[0] = w;
          pure[1] = 1;
          pure[2] = 0;
          break;

        case 2:
          pure[0] = 0;
          pure[1] = 1;
          pure[2] = v;
          break;

        case 3:
          pure[0] = 0;
          pure[1] = w;
          pure[2] = 1;
          break;

        case 4:
          pure[0] = v;
          pure[1] = 0;
          pure[2] = 1;
          break;

        default:
          pure[0] = 1;
          pure[1] = 0;
          pure[2] = w;
      }

      mg = (1.0 - c) * g;
      return [(c * pure[0] + mg) * 255, (c * pure[1] + mg) * 255, (c * pure[2] + mg) * 255];
    };

    convert.hcg.hsv = function (hcg) {
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;
      var v = c + g * (1.0 - c);
      var f = 0;

      if (v > 0.0) {
        f = c / v;
      }

      return [hcg[0], f * 100, v * 100];
    };

    convert.hcg.hsl = function (hcg) {
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;
      var l = g * (1.0 - c) + 0.5 * c;
      var s = 0;

      if (l > 0.0 && l < 0.5) {
        s = c / (2 * l);
      } else if (l >= 0.5 && l < 1.0) {
        s = c / (2 * (1 - l));
      }

      return [hcg[0], s * 100, l * 100];
    };

    convert.hcg.hwb = function (hcg) {
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;
      var v = c + g * (1.0 - c);
      return [hcg[0], (v - c) * 100, (1 - v) * 100];
    };

    convert.hwb.hcg = function (hwb) {
      var w = hwb[1] / 100;
      var b = hwb[2] / 100;
      var v = 1 - b;
      var c = v - w;
      var g = 0;

      if (c < 1) {
        g = (v - c) / (1 - c);
      }

      return [hwb[0], c * 100, g * 100];
    };

    convert.apple.rgb = function (apple) {
      return [apple[0] / 65535 * 255, apple[1] / 65535 * 255, apple[2] / 65535 * 255];
    };

    convert.rgb.apple = function (rgb) {
      return [rgb[0] / 255 * 65535, rgb[1] / 255 * 65535, rgb[2] / 255 * 65535];
    };

    convert.gray.rgb = function (args) {
      return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
    };

    convert.gray.hsl = convert.gray.hsv = function (args) {
      return [0, 0, args[0]];
    };

    convert.gray.hwb = function (gray) {
      return [0, 100, gray[0]];
    };

    convert.gray.cmyk = function (gray) {
      return [0, 0, 0, gray[0]];
    };

    convert.gray.lab = function (gray) {
      return [gray[0], 0, 0];
    };

    convert.gray.hex = function (gray) {
      var val = Math.round(gray[0] / 100 * 255) & 0xFF;
      var string = ((val << 16) + (val << 8) + val).toString(16).toUpperCase();
      return '000000'.substring(string.length) + string;
    };

    convert.rgb.gray = function (rgb) {
      var val = (rgb[0] + rgb[1] + rgb[2]) / 3;
      return [val / 255 * 100];
    };
  });
  var conversions_1 = conversions.rgb;
  var conversions_2 = conversions.hsl;
  var conversions_3 = conversions.hsv;
  var conversions_4 = conversions.hwb;
  var conversions_5 = conversions.cmyk;
  var conversions_6 = conversions.xyz;
  var conversions_7 = conversions.lab;
  var conversions_8 = conversions.lch;
  var conversions_9 = conversions.hex;
  var conversions_10 = conversions.keyword;
  var conversions_11 = conversions.ansi16;
  var conversions_12 = conversions.ansi256;
  var conversions_13 = conversions.hcg;
  var conversions_14 = conversions.apple;
  var conversions_15 = conversions.gray;

  /*
  	this function routes a model to all other models.

  	all functions that are routed have a property `.conversion` attached
  	to the returned synthetic function. This property is an array
  	of strings, each with the steps in between the 'from' and 'to'
  	color models (inclusive).

  	conversions that are not possible simply are not included.
  */

  function buildGraph() {
    var graph = {}; // https://jsperf.com/object-keys-vs-for-in-with-closure/3

    var models = Object.keys(conversions);

    for (var len = models.length, i = 0; i < len; i++) {
      graph[models[i]] = {
        // http://jsperf.com/1-vs-infinity
        // micro-opt, but this is simple.
        distance: -1,
        parent: null
      };
    }

    return graph;
  } // https://en.wikipedia.org/wiki/Breadth-first_search


  function deriveBFS(fromModel) {
    var graph = buildGraph();
    var queue = [fromModel]; // unshift -> queue -> pop

    graph[fromModel].distance = 0;

    while (queue.length) {
      var current = queue.pop();
      var adjacents = Object.keys(conversions[current]);

      for (var len = adjacents.length, i = 0; i < len; i++) {
        var adjacent = adjacents[i];
        var node = graph[adjacent];

        if (node.distance === -1) {
          node.distance = graph[current].distance + 1;
          node.parent = current;
          queue.unshift(adjacent);
        }
      }
    }

    return graph;
  }

  function link(from, to) {
    return function (args) {
      return to(from(args));
    };
  }

  function wrapConversion(toModel, graph) {
    var path = [graph[toModel].parent, toModel];
    var fn = conversions[graph[toModel].parent][toModel];
    var cur = graph[toModel].parent;

    while (graph[cur].parent) {
      path.unshift(graph[cur].parent);
      fn = link(conversions[graph[cur].parent][cur], fn);
      cur = graph[cur].parent;
    }

    fn.conversion = path;
    return fn;
  }

  var route = function (fromModel) {
    var graph = deriveBFS(fromModel);
    var conversion = {};
    var models = Object.keys(graph);

    for (var len = models.length, i = 0; i < len; i++) {
      var toModel = models[i];
      var node = graph[toModel];

      if (node.parent === null) {
        // no possible conversion, or this node is the source model.
        continue;
      }

      conversion[toModel] = wrapConversion(toModel, graph);
    }

    return conversion;
  };

  var convert = {};
  var models = Object.keys(conversions);

  function wrapRaw(fn) {
    var wrappedFn = function (args) {
      if (args === undefined || args === null) {
        return args;
      }

      if (arguments.length > 1) {
        args = Array.prototype.slice.call(arguments);
      }

      return fn(args);
    }; // preserve .conversion property if there is one


    if ('conversion' in fn) {
      wrappedFn.conversion = fn.conversion;
    }

    return wrappedFn;
  }

  function wrapRounded(fn) {
    var wrappedFn = function (args) {
      if (args === undefined || args === null) {
        return args;
      }

      if (arguments.length > 1) {
        args = Array.prototype.slice.call(arguments);
      }

      var result = fn(args); // we're assuming the result is an array here.
      // see notice in conversions.js; don't use box types
      // in conversion functions.

      if (typeof result === 'object') {
        for (var len = result.length, i = 0; i < len; i++) {
          result[i] = Math.round(result[i]);
        }
      }

      return result;
    }; // preserve .conversion property if there is one


    if ('conversion' in fn) {
      wrappedFn.conversion = fn.conversion;
    }

    return wrappedFn;
  }

  models.forEach(function (fromModel) {
    convert[fromModel] = {};
    Object.defineProperty(convert[fromModel], 'channels', {
      value: conversions[fromModel].channels
    });
    Object.defineProperty(convert[fromModel], 'labels', {
      value: conversions[fromModel].labels
    });
    var routes = route(fromModel);
    var routeModels = Object.keys(routes);
    routeModels.forEach(function (toModel) {
      var fn = routes[toModel];
      convert[fromModel][toModel] = wrapRounded(fn);
      convert[fromModel][toModel].raw = wrapRaw(fn);
    });
  });
  var colorConvert = convert;

  var ansiStyles = createCommonjsModule(function (module) {

    var wrapAnsi16 = function (fn, offset) {
      return function () {
        var code = fn.apply(colorConvert, arguments);
        return "\x1B[" + (code + offset) + "m";
      };
    };

    var wrapAnsi256 = function (fn, offset) {
      return function () {
        var code = fn.apply(colorConvert, arguments);
        return "\x1B[" + (38 + offset) + ";5;" + code + "m";
      };
    };

    var wrapAnsi16m = function (fn, offset) {
      return function () {
        var rgb = fn.apply(colorConvert, arguments);
        return "\x1B[" + (38 + offset) + ";2;" + rgb[0] + ";" + rgb[1] + ";" + rgb[2] + "m";
      };
    };

    function assembleStyles() {
      var codes = new Map();
      var styles = {
        modifier: {
          reset: [0, 0],
          // 21 isn't widely supported and 22 does the same thing
          bold: [1, 22],
          dim: [2, 22],
          italic: [3, 23],
          underline: [4, 24],
          inverse: [7, 27],
          hidden: [8, 28],
          strikethrough: [9, 29]
        },
        color: {
          black: [30, 39],
          red: [31, 39],
          green: [32, 39],
          yellow: [33, 39],
          blue: [34, 39],
          magenta: [35, 39],
          cyan: [36, 39],
          white: [37, 39],
          gray: [90, 39],
          // Bright color
          redBright: [91, 39],
          greenBright: [92, 39],
          yellowBright: [93, 39],
          blueBright: [94, 39],
          magentaBright: [95, 39],
          cyanBright: [96, 39],
          whiteBright: [97, 39]
        },
        bgColor: {
          bgBlack: [40, 49],
          bgRed: [41, 49],
          bgGreen: [42, 49],
          bgYellow: [43, 49],
          bgBlue: [44, 49],
          bgMagenta: [45, 49],
          bgCyan: [46, 49],
          bgWhite: [47, 49],
          // Bright color
          bgBlackBright: [100, 49],
          bgRedBright: [101, 49],
          bgGreenBright: [102, 49],
          bgYellowBright: [103, 49],
          bgBlueBright: [104, 49],
          bgMagentaBright: [105, 49],
          bgCyanBright: [106, 49],
          bgWhiteBright: [107, 49]
        }
      }; // Fix humans

      styles.color.grey = styles.color.gray;

      for (var _i = 0, _Object$keys = Object.keys(styles); _i < _Object$keys.length; _i++) {
        var groupName = _Object$keys[_i];
        var group = styles[groupName];

        for (var _i3 = 0, _Object$keys3 = Object.keys(group); _i3 < _Object$keys3.length; _i3++) {
          var styleName = _Object$keys3[_i3];
          var style = group[styleName];
          styles[styleName] = {
            open: "\x1B[" + style[0] + "m",
            close: "\x1B[" + style[1] + "m"
          };
          group[styleName] = styles[styleName];
          codes.set(style[0], style[1]);
        }

        Object.defineProperty(styles, groupName, {
          value: group,
          enumerable: false
        });
        Object.defineProperty(styles, 'codes', {
          value: codes,
          enumerable: false
        });
      }

      var ansi2ansi = function (n) {
        return n;
      };

      var rgb2rgb = function (r, g, b) {
        return [r, g, b];
      };

      styles.color.close = "\x1B[39m";
      styles.bgColor.close = "\x1B[49m";
      styles.color.ansi = {
        ansi: wrapAnsi16(ansi2ansi, 0)
      };
      styles.color.ansi256 = {
        ansi256: wrapAnsi256(ansi2ansi, 0)
      };
      styles.color.ansi16m = {
        rgb: wrapAnsi16m(rgb2rgb, 0)
      };
      styles.bgColor.ansi = {
        ansi: wrapAnsi16(ansi2ansi, 10)
      };
      styles.bgColor.ansi256 = {
        ansi256: wrapAnsi256(ansi2ansi, 10)
      };
      styles.bgColor.ansi16m = {
        rgb: wrapAnsi16m(rgb2rgb, 10)
      };

      for (var _i2 = 0, _Object$keys2 = Object.keys(colorConvert); _i2 < _Object$keys2.length; _i2++) {
        var key = _Object$keys2[_i2];

        if (typeof colorConvert[key] !== 'object') {
          continue;
        }

        var suite = colorConvert[key];

        if (key === 'ansi16') {
          key = 'ansi';
        }

        if ('ansi16' in suite) {
          styles.color.ansi[key] = wrapAnsi16(suite.ansi16, 0);
          styles.bgColor.ansi[key] = wrapAnsi16(suite.ansi16, 10);
        }

        if ('ansi256' in suite) {
          styles.color.ansi256[key] = wrapAnsi256(suite.ansi256, 0);
          styles.bgColor.ansi256[key] = wrapAnsi256(suite.ansi256, 10);
        }

        if ('rgb' in suite) {
          styles.color.ansi16m[key] = wrapAnsi16m(suite.rgb, 0);
          styles.bgColor.ansi16m[key] = wrapAnsi16m(suite.rgb, 10);
        }
      }

      return styles;
    } // Make the export immutable


    Object.defineProperty(module, 'exports', {
      enumerable: true,
      get: assembleStyles
    });
  });

  var collections = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, '__esModule', {
      value: true
    });

    exports.printIteratorEntries =
    /**
     * Return entries (for example, of a map)
     * with spacing, indentation, and comma
     * without surrounding punctuation (for example, braces)
     */
    function ( // Flow 0.51.0: property `@@iterator` of $Iterator not found in Object
    // To allow simplistic getRecordIterator in immutable.js
    iterator, config, indentation, depth, refs, printer, // Too bad, so sad that separator for ECMAScript Map has been ' => '
    // What a distracting diff if you change a data structure to/from
    separator) {
      if (separator === void 0) {
        separator = ': ';
      }

      var result = '';
      var current = iterator.next();

      if (!current.done) {
        result += config.spacingOuter;
        var indentationNext = indentation + config.indent;

        while (!current.done) {
          var name = printer(current.value[0], config, indentationNext, depth, refs);
          var value = printer(current.value[1], config, indentationNext, depth, refs);
          result += indentationNext + name + separator + value;
          current = iterator.next();

          if (!current.done) {
            result += ',' + config.spacingInner;
          } else if (!config.min) {
            result += ',';
          }
        }

        result += config.spacingOuter + indentation;
      }

      return result;
    }
    /**
     * Return values (for example, of a set)
     * with spacing, indentation, and comma
     * without surrounding punctuation (braces or brackets)
     */
    ;

    exports.printIteratorValues = function (iterator, config, indentation, depth, refs, printer) {
      var result = '';
      var current = iterator.next();

      if (!current.done) {
        result += config.spacingOuter;
        var indentationNext = indentation + config.indent;

        while (!current.done) {
          result += indentationNext + printer(current.value, config, indentationNext, depth, refs);
          current = iterator.next();

          if (!current.done) {
            result += ',' + config.spacingInner;
          } else if (!config.min) {
            result += ',';
          }
        }

        result += config.spacingOuter + indentation;
      }

      return result;
    }
    /**
     * Return items (for example, of an array)
     * with spacing, indentation, and comma
     * without surrounding punctuation (for example, brackets)
     **/
    ;

    exports.printListItems = function (list, config, indentation, depth, refs, printer) {
      var result = '';

      if (list.length) {
        result += config.spacingOuter;
        var indentationNext = indentation + config.indent;

        for (var i = 0; i < list.length; i++) {
          result += indentationNext + printer(list[i], config, indentationNext, depth, refs);

          if (i < list.length - 1) {
            result += ',' + config.spacingInner;
          } else if (!config.min) {
            result += ',';
          }
        }

        result += config.spacingOuter + indentation;
      }

      return result;
    }
    /**
     * Return properties of an object
     * with spacing, indentation, and comma
     * without surrounding punctuation (for example, braces)
     */
    ;

    exports.printObjectProperties = function (val, config, indentation, depth, refs, printer) {
      var result = '';
      var keys = getKeysOfEnumerableProperties(val);

      if (keys.length) {
        result += config.spacingOuter;
        var indentationNext = indentation + config.indent;

        for (var i = 0; i < keys.length; i++) {
          var key = keys[i];
          var name = printer(key, config, indentationNext, depth, refs);
          var value = printer(val[key], config, indentationNext, depth, refs);
          result += indentationNext + name + ': ' + value;

          if (i < keys.length - 1) {
            result += ',' + config.spacingInner;
          } else if (!config.min) {
            result += ',';
          }
        }

        result += config.spacingOuter + indentation;
      }

      return result;
    };
    /**
     * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
     *
     * This source code is licensed under the MIT license found in the
     * LICENSE file in the root directory of this source tree.
     *
     */


    var getKeysOfEnumerableProperties = function (object) {
      var keys = Object.keys(object).sort();

      if (Object.getOwnPropertySymbols) {
        Object.getOwnPropertySymbols(object).forEach(function (symbol) {
          if (Object.getOwnPropertyDescriptor(object, symbol).enumerable) {
            keys.push(symbol);
          }
        });
      }

      return keys;
    };
  });
  unwrapExports(collections);
  var collections_1 = collections.printIteratorEntries;
  var collections_2 = collections.printIteratorValues;
  var collections_3 = collections.printListItems;
  var collections_4 = collections.printObjectProperties;

  var AsymmetricMatcher = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, '__esModule', {
      value: true
    });
    exports.default = exports.test = exports.serialize = void 0;
    var Symbol = commonjsGlobal['jest-symbol-do-not-touch'] || commonjsGlobal.Symbol;
    var asymmetricMatcher = Symbol.for('jest.asymmetricMatcher');
    var SPACE = ' ';

    var serialize = function (val, config, indentation, depth, refs, printer) {
      var stringedValue = val.toString();

      if (stringedValue === 'ArrayContaining' || stringedValue === 'ArrayNotContaining') {
        if (++depth > config.maxDepth) {
          return '[' + stringedValue + ']';
        }

        return stringedValue + SPACE + '[' + (0, collections.printListItems)(val.sample, config, indentation, depth, refs, printer) + ']';
      }

      if (stringedValue === 'ObjectContaining' || stringedValue === 'ObjectNotContaining') {
        if (++depth > config.maxDepth) {
          return '[' + stringedValue + ']';
        }

        return stringedValue + SPACE + '{' + (0, collections.printObjectProperties)(val.sample, config, indentation, depth, refs, printer) + '}';
      }

      if (stringedValue === 'StringMatching' || stringedValue === 'StringNotMatching') {
        return stringedValue + SPACE + printer(val.sample, config, indentation, depth, refs);
      }

      if (stringedValue === 'StringContaining' || stringedValue === 'StringNotContaining') {
        return stringedValue + SPACE + printer(val.sample, config, indentation, depth, refs);
      }

      return val.toAsymmetricMatcher();
    };

    exports.serialize = serialize;

    var test = function (val) {
      return val && val.$$typeof === asymmetricMatcher;
    };

    exports.test = test;
    exports.default = {
      serialize: serialize,
      test: test
    };
  });
  unwrapExports(AsymmetricMatcher);
  var AsymmetricMatcher_1 = AsymmetricMatcher.test;
  var AsymmetricMatcher_2 = AsymmetricMatcher.serialize;

  var ansiRegex = function (options) {
    options = Object.assign({
      onlyFirst: false
    }, options);
    var pattern = ["[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:[a-zA-Z\\d]*(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)", '(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))'].join('|');
    return new RegExp(pattern, options.onlyFirst ? undefined : 'g');
  };

  var ConvertAnsi = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, '__esModule', {
      value: true
    });
    exports.default = exports.serialize = exports.test = void 0;

    var _ansiRegex = _interopRequireDefault(ansiRegex);

    var _ansiStyles = _interopRequireDefault(ansiStyles);

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    /**
     * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
     *
     * This source code is licensed under the MIT license found in the
     * LICENSE file in the root directory of this source tree.
     */


    var toHumanReadableAnsi = function (text) {
      return text.replace((0, _ansiRegex.default)(), function (match) {
        switch (match) {
          case _ansiStyles.default.red.close:
          case _ansiStyles.default.green.close:
          case _ansiStyles.default.cyan.close:
          case _ansiStyles.default.gray.close:
          case _ansiStyles.default.white.close:
          case _ansiStyles.default.yellow.close:
          case _ansiStyles.default.bgRed.close:
          case _ansiStyles.default.bgGreen.close:
          case _ansiStyles.default.bgYellow.close:
          case _ansiStyles.default.inverse.close:
          case _ansiStyles.default.dim.close:
          case _ansiStyles.default.bold.close:
          case _ansiStyles.default.reset.open:
          case _ansiStyles.default.reset.close:
            return '</>';

          case _ansiStyles.default.red.open:
            return '<red>';

          case _ansiStyles.default.green.open:
            return '<green>';

          case _ansiStyles.default.cyan.open:
            return '<cyan>';

          case _ansiStyles.default.gray.open:
            return '<gray>';

          case _ansiStyles.default.white.open:
            return '<white>';

          case _ansiStyles.default.yellow.open:
            return '<yellow>';

          case _ansiStyles.default.bgRed.open:
            return '<bgRed>';

          case _ansiStyles.default.bgGreen.open:
            return '<bgGreen>';

          case _ansiStyles.default.bgYellow.open:
            return '<bgYellow>';

          case _ansiStyles.default.inverse.open:
            return '<inverse>';

          case _ansiStyles.default.dim.open:
            return '<dim>';

          case _ansiStyles.default.bold.open:
            return '<bold>';

          default:
            return '';
        }
      });
    };

    var test = function (val) {
      return typeof val === 'string' && !!val.match((0, _ansiRegex.default)());
    };

    exports.test = test;

    var serialize = function (val, config, indentation, depth, refs, printer) {
      return printer(toHumanReadableAnsi(val), config, indentation, depth, refs);
    };

    exports.serialize = serialize;
    exports.default = {
      serialize: serialize,
      test: test
    };
  });
  unwrapExports(ConvertAnsi);
  var ConvertAnsi_1 = ConvertAnsi.serialize;
  var ConvertAnsi_2 = ConvertAnsi.test;

  var DOMCollection = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, '__esModule', {
      value: true
    });
    exports.default = exports.serialize = exports.test = void 0;

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};
        var ownKeys = Object.keys(source);

        if (typeof Object.getOwnPropertySymbols === 'function') {
          ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
            return Object.getOwnPropertyDescriptor(source, sym).enumerable;
          }));
        }

        ownKeys.forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      }

      return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, {
          value: value,
          enumerable: true,
          configurable: true,
          writable: true
        });
      } else {
        obj[key] = value;
      }

      return obj;
    }

    var OBJECT_NAMES = ['DOMStringMap', 'NamedNodeMap'];
    var ARRAY_REGEXP = /^(HTML\w*Collection|NodeList)$/;

    var testName = function (name) {
      return OBJECT_NAMES.indexOf(name) !== -1 || ARRAY_REGEXP.test(name);
    };

    var test = function (val) {
      return val && val.constructor && val.constructor.name && testName(val.constructor.name);
    }; // Convert array of attribute objects to props object.


    exports.test = test;

    var propsReducer = function (props, attribute) {
      props[attribute.name] = attribute.value;
      return props;
    };

    var serialize = function (collection, config, indentation, depth, refs, printer) {
      var name = collection.constructor.name;

      if (++depth > config.maxDepth) {
        return '[' + name + ']';
      }

      return (config.min ? '' : name + ' ') + (OBJECT_NAMES.indexOf(name) !== -1 ? '{' + (0, collections.printObjectProperties)(name === 'NamedNodeMap' ? Array.prototype.reduce.call(collection, propsReducer, {}) : _objectSpread({}, collection), config, indentation, depth, refs, printer) + '}' : '[' + (0, collections.printListItems)(Array.from(collection), config, indentation, depth, refs, printer) + ']');
    };

    exports.serialize = serialize;
    exports.default = {
      serialize: serialize,
      test: test
    };
  });
  unwrapExports(DOMCollection);
  var DOMCollection_1 = DOMCollection.serialize;
  var DOMCollection_2 = DOMCollection.test;

  var escapeHTML_1 = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, '__esModule', {
      value: true
    });

    exports.default =
    /**
     * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
     *
     * This source code is licensed under the MIT license found in the
     * LICENSE file in the root directory of this source tree.
     */
    function (str) {
      return str.replace(/</g, '&lt;').replace(/>/g, '&gt;');
    };
  });
  unwrapExports(escapeHTML_1);

  var markup = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, '__esModule', {
      value: true
    });
    exports.printElementAsLeaf = exports.printElement = exports.printComment = exports.printText = exports.printChildren = exports.printProps = void 0;

    var _escapeHTML = function (obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    /**
     * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
     *
     * This source code is licensed under the MIT license found in the
     * LICENSE file in the root directory of this source tree.
     */
    // Return empty string if keys is empty.
    (escapeHTML_1);

    // Return empty string if children is empty.
    exports.printProps = function printProps(keys, props, config, indentation, depth, refs, printer) {
      var indentationNext = indentation + config.indent;
      var colors = config.colors;
      return keys.map(function (key) {
        var value = props[key];
        var printed = printer(value, config, indentationNext, depth, refs);

        if (typeof value !== 'string') {
          if (printed.indexOf('\n') !== -1) {
            printed = config.spacingOuter + indentationNext + printed + config.spacingOuter + indentation;
          }

          printed = '{' + printed + '}';
        }

        return config.spacingInner + indentation + colors.prop.open + key + colors.prop.close + '=' + colors.value.open + printed + colors.value.close;
      }).join('');
    };

    exports.printChildren = function printChildren(children, config, indentation, depth, refs, printer) {
      return children.map(function (child) {
        return config.spacingOuter + indentation + (typeof child === 'string' ? printText(child, config) : printer(child, config, indentation, depth, refs));
      }).join('');
    };

    var printText = function (text, config) {
      var contentColor = config.colors.content;
      return contentColor.open + (0, _escapeHTML.default)(text) + contentColor.close;
    };

    exports.printText = printText;

    // Separate the functions to format props, children, and element,
    // so a plugin could override a particular function, if needed.
    // Too bad, so sad: the traditional (but unnecessary) space
    // in a self-closing tagColor requires a second test of printedProps.
    exports.printComment = function printComment(comment, config) {
      var commentColor = config.colors.comment;
      return commentColor.open + '<!--' + (0, _escapeHTML.default)(comment) + '-->' + commentColor.close;
    };

    exports.printElement = function printElement(type, printedProps, printedChildren, config, indentation) {
      var tagColor = config.colors.tag;
      return tagColor.open + '<' + type + (printedProps && tagColor.close + printedProps + config.spacingOuter + indentation + tagColor.open) + (printedChildren ? '>' + tagColor.close + printedChildren + config.spacingOuter + indentation + tagColor.open + '</' + type : (printedProps && !config.min ? '' : ' ') + '/') + '>' + tagColor.close;
    };

    exports.printElementAsLeaf = function printElementAsLeaf(type, config) {
      var tagColor = config.colors.tag;
      return tagColor.open + '<' + type + tagColor.close + ' …' + tagColor.open + ' />' + tagColor.close;
    };
  });
  unwrapExports(markup);
  var markup_1 = markup.printElementAsLeaf;
  var markup_2 = markup.printElement;
  var markup_3 = markup.printComment;
  var markup_4 = markup.printText;
  var markup_5 = markup.printChildren;
  var markup_6 = markup.printProps;

  var DOMElement = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, '__esModule', {
      value: true
    });
    exports.default = exports.serialize = exports.test = void 0;
    /**
     * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
     *
     * This source code is licensed under the MIT license found in the
     * LICENSE file in the root directory of this source tree.
     */

    var TEXT_NODE = 3;
    var COMMENT_NODE = 8;
    var FRAGMENT_NODE = 11;
    var ELEMENT_REGEXP = /^((HTML|SVG)\w*)?Element$/;

    var testNode = function (nodeType, name) {
      return nodeType === 1 && ELEMENT_REGEXP.test(name) || nodeType === TEXT_NODE && name === 'Text' || nodeType === COMMENT_NODE && name === 'Comment' || nodeType === FRAGMENT_NODE && name === 'DocumentFragment';
    };

    var test = function (val) {
      return val && val.constructor && val.constructor.name && testNode(val.nodeType, val.constructor.name);
    };

    exports.test = test;

    function nodeIsText(node) {
      return node.nodeType === TEXT_NODE;
    }

    function nodeIsComment(node) {
      return node.nodeType === COMMENT_NODE;
    }

    function nodeIsFragment(node) {
      return node.nodeType === FRAGMENT_NODE;
    }

    var serialize = function (node, config, indentation, depth, refs, printer) {
      if (nodeIsText(node)) {
        return (0, markup.printText)(node.data, config);
      }

      if (nodeIsComment(node)) {
        return (0, markup.printComment)(node.data, config);
      }

      var type = nodeIsFragment(node) ? "DocumentFragment" : node.tagName.toLowerCase();

      if (++depth > config.maxDepth) {
        return (0, markup.printElementAsLeaf)(type, config);
      }

      return (0, markup.printElement)(type, (0, markup.printProps)(nodeIsFragment(node) ? [] : Array.from(node.attributes).map(function (attr) {
        return attr.name;
      }).sort(), nodeIsFragment(node) ? [] : Array.from(node.attributes).reduce(function (props, attribute) {
        props[attribute.name] = attribute.value;
        return props;
      }, {}), config, indentation + config.indent, depth, refs, printer), (0, markup.printChildren)(Array.prototype.slice.call(node.childNodes || node.children), config, indentation + config.indent, depth, refs, printer), config, indentation);
    };

    exports.serialize = serialize;
    exports.default = {
      serialize: serialize,
      test: test
    };
  });
  unwrapExports(DOMElement);
  var DOMElement_1 = DOMElement.serialize;
  var DOMElement_2 = DOMElement.test;

  var Immutable = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, '__esModule', {
      value: true
    });
    exports.default = exports.test = exports.serialize = void 0;
    /**
     * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
     *
     * This source code is licensed under the MIT license found in the
     * LICENSE file in the root directory of this source tree.
     */
    // SENTINEL constants are from https://github.com/facebook/immutable-js

    var IS_ORDERED_SENTINEL = '@@__IMMUTABLE_ORDERED__@@';

    var getImmutableName = function (name) {
      return 'Immutable.' + name;
    };

    var printAsLeaf = function (name) {
      return '[' + name + ']';
    };

    var SPACE = ' ';
    var LAZY = '…'; // Seq is lazy if it calls a method like filter

    var printImmutableEntries = function (val, config, indentation, depth, refs, printer, type) {
      return ++depth > config.maxDepth ? printAsLeaf(getImmutableName(type)) : getImmutableName(type) + SPACE + '{' + (0, collections.printIteratorEntries)(val.entries(), config, indentation, depth, refs, printer) + '}';
    }; // Record has an entries method because it is a collection in immutable v3.
    // Return an iterator for Immutable Record from version v3 or v4.


    var getRecordEntries = function (val) {
      var i = 0;
      return {
        next: function next() {
          if (i < val._keys.length) {
            var key = val._keys[i++];
            return {
              done: false,
              value: [key, val.get(key)]
            };
          }

          return {
            done: true
          };
        }
      };
    };

    var printImmutableRecord = function (val, config, indentation, depth, refs, printer) {
      // _name property is defined only for an Immutable Record instance
      // which was constructed with a second optional descriptive name arg
      var name = getImmutableName(val._name || 'Record');
      return ++depth > config.maxDepth ? printAsLeaf(name) : name + SPACE + '{' + (0, collections.printIteratorEntries)(getRecordEntries(val), config, indentation, depth, refs, printer) + '}';
    };

    var printImmutableSeq = function (val, config, indentation, depth, refs, printer) {
      var name = getImmutableName('Seq');

      if (++depth > config.maxDepth) {
        return printAsLeaf(name);
      }

      if (val['@@__IMMUTABLE_KEYED__@@']) {
        return name + SPACE + '{' + ( // from Immutable collection of entries or from ECMAScript object
        val._iter || val._object ? (0, collections.printIteratorEntries)(val.entries(), config, indentation, depth, refs, printer) : LAZY) + '}';
      }

      return name + SPACE + '[' + (val._iter || // from Immutable collection of values
      val._array || // from ECMAScript array
      val._collection || // from ECMAScript collection in immutable v4
      val._iterable // from ECMAScript collection in immutable v3
      ? (0, collections.printIteratorValues)(val.values(), config, indentation, depth, refs, printer) : LAZY) + ']';
    };

    var printImmutableValues = function (val, config, indentation, depth, refs, printer, type) {
      return ++depth > config.maxDepth ? printAsLeaf(getImmutableName(type)) : getImmutableName(type) + SPACE + '[' + (0, collections.printIteratorValues)(val.values(), config, indentation, depth, refs, printer) + ']';
    };

    var serialize = function (val, config, indentation, depth, refs, printer) {
      if (val['@@__IMMUTABLE_MAP__@@']) {
        return printImmutableEntries(val, config, indentation, depth, refs, printer, val[IS_ORDERED_SENTINEL] ? 'OrderedMap' : 'Map');
      }

      if (val['@@__IMMUTABLE_LIST__@@']) {
        return printImmutableValues(val, config, indentation, depth, refs, printer, 'List');
      }

      if (val['@@__IMMUTABLE_SET__@@']) {
        return printImmutableValues(val, config, indentation, depth, refs, printer, val[IS_ORDERED_SENTINEL] ? 'OrderedSet' : 'Set');
      }

      if (val['@@__IMMUTABLE_STACK__@@']) {
        return printImmutableValues(val, config, indentation, depth, refs, printer, 'Stack');
      }

      if (val['@@__IMMUTABLE_SEQ__@@']) {
        return printImmutableSeq(val, config, indentation, depth, refs, printer);
      } // For compatibility with immutable v3 and v4, let record be the default.


      return printImmutableRecord(val, config, indentation, depth, refs, printer);
    }; // Explicitly comparing sentinel properties to true avoids false positive
    // when mock identity-obj-proxy returns the key as the value for any key.


    exports.serialize = serialize;

    var test = function (val) {
      return val && (val['@@__IMMUTABLE_ITERABLE__@@'] === true || val['@@__IMMUTABLE_RECORD__@@'] === true);
    };

    exports.test = test;
    exports.default = {
      serialize: serialize,
      test: test
    };
  });
  unwrapExports(Immutable);
  var Immutable_1 = Immutable.test;
  var Immutable_2 = Immutable.serialize;

  var reactIs_production_min = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, "__esModule", {
      value: !0
    });
    var b = "function" === typeof Symbol && Symbol.for,
        c = b ? Symbol.for("react.element") : 60103,
        d = b ? Symbol.for("react.portal") : 60106,
        e = b ? Symbol.for("react.fragment") : 60107,
        f = b ? Symbol.for("react.strict_mode") : 60108,
        g = b ? Symbol.for("react.profiler") : 60114,
        h = b ? Symbol.for("react.provider") : 60109,
        k = b ? Symbol.for("react.context") : 60110,
        l = b ? Symbol.for("react.async_mode") : 60111,
        m = b ? Symbol.for("react.concurrent_mode") : 60111,
        n = b ? Symbol.for("react.forward_ref") : 60112,
        p = b ? Symbol.for("react.suspense") : 60113,
        q = b ? Symbol.for("react.memo") : 60115,
        r = b ? Symbol.for("react.lazy") : 60116;

    function t(a) {
      if ("object" === typeof a && null !== a) {
        var u = a.$$typeof;

        switch (u) {
          case c:
            switch (a = a.type, a) {
              case l:
              case m:
              case e:
              case g:
              case f:
              case p:
                return a;

              default:
                switch (a = a && a.$$typeof, a) {
                  case k:
                  case n:
                  case h:
                    return a;

                  default:
                    return u;
                }

            }

          case r:
          case q:
          case d:
            return u;
        }
      }
    }

    function v(a) {
      return t(a) === m;
    }

    exports.typeOf = t;
    exports.AsyncMode = l;
    exports.ConcurrentMode = m;
    exports.ContextConsumer = k;
    exports.ContextProvider = h;
    exports.Element = c;
    exports.ForwardRef = n;
    exports.Fragment = e;
    exports.Lazy = r;
    exports.Memo = q;
    exports.Portal = d;
    exports.Profiler = g;
    exports.StrictMode = f;
    exports.Suspense = p;

    exports.isValidElementType = function (a) {
      return "string" === typeof a || "function" === typeof a || a === e || a === m || a === g || a === f || a === p || "object" === typeof a && null !== a && (a.$$typeof === r || a.$$typeof === q || a.$$typeof === h || a.$$typeof === k || a.$$typeof === n);
    };

    exports.isAsyncMode = function (a) {
      return v(a) || t(a) === l;
    };

    exports.isConcurrentMode = v;

    exports.isContextConsumer = function (a) {
      return t(a) === k;
    };

    exports.isContextProvider = function (a) {
      return t(a) === h;
    };

    exports.isElement = function (a) {
      return "object" === typeof a && null !== a && a.$$typeof === c;
    };

    exports.isForwardRef = function (a) {
      return t(a) === n;
    };

    exports.isFragment = function (a) {
      return t(a) === e;
    };

    exports.isLazy = function (a) {
      return t(a) === r;
    };

    exports.isMemo = function (a) {
      return t(a) === q;
    };

    exports.isPortal = function (a) {
      return t(a) === d;
    };

    exports.isProfiler = function (a) {
      return t(a) === g;
    };

    exports.isStrictMode = function (a) {
      return t(a) === f;
    };

    exports.isSuspense = function (a) {
      return t(a) === p;
    };
  });
  unwrapExports(reactIs_production_min);
  var reactIs_production_min_1 = reactIs_production_min.typeOf;
  var reactIs_production_min_2 = reactIs_production_min.AsyncMode;
  var reactIs_production_min_3 = reactIs_production_min.ConcurrentMode;
  var reactIs_production_min_4 = reactIs_production_min.ContextConsumer;
  var reactIs_production_min_5 = reactIs_production_min.ContextProvider;
  var reactIs_production_min_6 = reactIs_production_min.Element;
  var reactIs_production_min_7 = reactIs_production_min.ForwardRef;
  var reactIs_production_min_8 = reactIs_production_min.Fragment;
  var reactIs_production_min_9 = reactIs_production_min.Lazy;
  var reactIs_production_min_10 = reactIs_production_min.Memo;
  var reactIs_production_min_11 = reactIs_production_min.Portal;
  var reactIs_production_min_12 = reactIs_production_min.Profiler;
  var reactIs_production_min_13 = reactIs_production_min.StrictMode;
  var reactIs_production_min_14 = reactIs_production_min.Suspense;
  var reactIs_production_min_15 = reactIs_production_min.isValidElementType;
  var reactIs_production_min_16 = reactIs_production_min.isAsyncMode;
  var reactIs_production_min_17 = reactIs_production_min.isConcurrentMode;
  var reactIs_production_min_18 = reactIs_production_min.isContextConsumer;
  var reactIs_production_min_19 = reactIs_production_min.isContextProvider;
  var reactIs_production_min_20 = reactIs_production_min.isElement;
  var reactIs_production_min_21 = reactIs_production_min.isForwardRef;
  var reactIs_production_min_22 = reactIs_production_min.isFragment;
  var reactIs_production_min_23 = reactIs_production_min.isLazy;
  var reactIs_production_min_24 = reactIs_production_min.isMemo;
  var reactIs_production_min_25 = reactIs_production_min.isPortal;
  var reactIs_production_min_26 = reactIs_production_min.isProfiler;
  var reactIs_production_min_27 = reactIs_production_min.isStrictMode;
  var reactIs_production_min_28 = reactIs_production_min.isSuspense;

  var reactIs_development = createCommonjsModule(function (module, exports) {

    (function () {
      Object.defineProperty(exports, '__esModule', {
        value: true
      }); // The Symbol used to tag the ReactElement-like types. If there is no native Symbol
      // nor polyfill, then a plain number is used for performance.

      var hasSymbol = typeof Symbol === 'function' && Symbol.for;
      var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
      var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
      var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
      var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
      var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
      var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
      var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace;
      var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
      var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
      var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
      var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
      var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
      var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;

      /**
       * Forked from fbjs/warning:
       * https://github.com/facebook/fbjs/blob/e66ba20ad5be433eb54423f2b097d829324d9de6/packages/fbjs/src/__forks__/warning.js
       *
       * Only change is we use console.warn instead of console.error,
       * and do nothing when 'console' is not supported.
       * This really simplifies the code.
       * ---
       * Similar to invariant but only logs a warning if the condition is not met.
       * This can be used to log issues in development environments in critical
       * paths. Removing the logging code for production environments will keep the
       * same logic and follow the same code paths.
       */
      var lowPriorityWarning = function () {};

      {
        var printWarning = function (format) {
          for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }

          var argIndex = 0;
          var message = 'Warning: ' + format.replace(/%s/g, function () {
            return args[argIndex++];
          });

          if (typeof console !== 'undefined') {
            console.warn(message);
          }

          try {
            // --- Welcome to debugging React ---
            // This error was thrown as a convenience so that you can use this stack
            // to find the callsite that caused this warning to fire.
            throw new Error(message);
          } catch (x) {}
        };

        lowPriorityWarning = function (condition, format) {
          if (format === undefined) {
            throw new Error('`lowPriorityWarning(condition, format, ...args)` requires a warning ' + 'message argument');
          }

          if (!condition) {
            for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
              args[_key2 - 2] = arguments[_key2];
            }

            printWarning.apply(undefined, [format].concat(args));
          }
        };
      }
      var lowPriorityWarning$1 = lowPriorityWarning;

      function typeOf(object) {
        if (typeof object === 'object' && object !== null) {
          var $$typeof = object.$$typeof;

          switch ($$typeof) {
            case REACT_ELEMENT_TYPE:
              var type = object.type;

              switch (type) {
                case REACT_ASYNC_MODE_TYPE:
                case REACT_CONCURRENT_MODE_TYPE:
                case REACT_FRAGMENT_TYPE:
                case REACT_PROFILER_TYPE:
                case REACT_STRICT_MODE_TYPE:
                case REACT_SUSPENSE_TYPE:
                  return type;

                default:
                  var $$typeofType = type && type.$$typeof;

                  switch ($$typeofType) {
                    case REACT_CONTEXT_TYPE:
                    case REACT_FORWARD_REF_TYPE:
                    case REACT_PROVIDER_TYPE:
                      return $$typeofType;

                    default:
                      return $$typeof;
                  }

              }

            case REACT_LAZY_TYPE:
            case REACT_MEMO_TYPE:
            case REACT_PORTAL_TYPE:
              return $$typeof;
          }
        }

        return undefined;
      } // AsyncMode is deprecated along with isAsyncMode


      var hasWarnedAboutDeprecatedIsAsyncMode = false; // AsyncMode should be deprecated

      function isAsyncMode(object) {
        {
          if (!hasWarnedAboutDeprecatedIsAsyncMode) {
            hasWarnedAboutDeprecatedIsAsyncMode = true;
            lowPriorityWarning$1(false, 'The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
          }
        }
        return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
      }

      function isConcurrentMode(object) {
        return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
      }

      exports.typeOf = typeOf;
      exports.AsyncMode = REACT_ASYNC_MODE_TYPE;
      exports.ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
      exports.ContextConsumer = REACT_CONTEXT_TYPE;
      exports.ContextProvider = REACT_PROVIDER_TYPE;
      exports.Element = REACT_ELEMENT_TYPE;
      exports.ForwardRef = REACT_FORWARD_REF_TYPE;
      exports.Fragment = REACT_FRAGMENT_TYPE;
      exports.Lazy = REACT_LAZY_TYPE;
      exports.Memo = REACT_MEMO_TYPE;
      exports.Portal = REACT_PORTAL_TYPE;
      exports.Profiler = REACT_PROFILER_TYPE;
      exports.StrictMode = REACT_STRICT_MODE_TYPE;
      exports.Suspense = REACT_SUSPENSE_TYPE;

      exports.isValidElementType = function (type) {
        return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
        type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE);
      };

      exports.isAsyncMode = isAsyncMode;
      exports.isConcurrentMode = isConcurrentMode;

      exports.isContextConsumer = function (object) {
        return typeOf(object) === REACT_CONTEXT_TYPE;
      };

      exports.isContextProvider = function (object) {
        return typeOf(object) === REACT_PROVIDER_TYPE;
      };

      exports.isElement = function (object) {
        return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
      };

      exports.isForwardRef = function (object) {
        return typeOf(object) === REACT_FORWARD_REF_TYPE;
      };

      exports.isFragment = function (object) {
        return typeOf(object) === REACT_FRAGMENT_TYPE;
      };

      exports.isLazy = function (object) {
        return typeOf(object) === REACT_LAZY_TYPE;
      };

      exports.isMemo = function (object) {
        return typeOf(object) === REACT_MEMO_TYPE;
      };

      exports.isPortal = function (object) {
        return typeOf(object) === REACT_PORTAL_TYPE;
      };

      exports.isProfiler = function (object) {
        return typeOf(object) === REACT_PROFILER_TYPE;
      };

      exports.isStrictMode = function (object) {
        return typeOf(object) === REACT_STRICT_MODE_TYPE;
      };

      exports.isSuspense = function (object) {
        return typeOf(object) === REACT_SUSPENSE_TYPE;
      };
    })();
  });
  unwrapExports(reactIs_development);
  var reactIs_development_1 = reactIs_development.typeOf;
  var reactIs_development_2 = reactIs_development.AsyncMode;
  var reactIs_development_3 = reactIs_development.ConcurrentMode;
  var reactIs_development_4 = reactIs_development.ContextConsumer;
  var reactIs_development_5 = reactIs_development.ContextProvider;
  var reactIs_development_6 = reactIs_development.Element;
  var reactIs_development_7 = reactIs_development.ForwardRef;
  var reactIs_development_8 = reactIs_development.Fragment;
  var reactIs_development_9 = reactIs_development.Lazy;
  var reactIs_development_10 = reactIs_development.Memo;
  var reactIs_development_11 = reactIs_development.Portal;
  var reactIs_development_12 = reactIs_development.Profiler;
  var reactIs_development_13 = reactIs_development.StrictMode;
  var reactIs_development_14 = reactIs_development.Suspense;
  var reactIs_development_15 = reactIs_development.isValidElementType;
  var reactIs_development_16 = reactIs_development.isAsyncMode;
  var reactIs_development_17 = reactIs_development.isConcurrentMode;
  var reactIs_development_18 = reactIs_development.isContextConsumer;
  var reactIs_development_19 = reactIs_development.isContextProvider;
  var reactIs_development_20 = reactIs_development.isElement;
  var reactIs_development_21 = reactIs_development.isForwardRef;
  var reactIs_development_22 = reactIs_development.isFragment;
  var reactIs_development_23 = reactIs_development.isLazy;
  var reactIs_development_24 = reactIs_development.isMemo;
  var reactIs_development_25 = reactIs_development.isPortal;
  var reactIs_development_26 = reactIs_development.isProfiler;
  var reactIs_development_27 = reactIs_development.isStrictMode;
  var reactIs_development_28 = reactIs_development.isSuspense;

  var reactIs = createCommonjsModule(function (module) {

    module.exports = reactIs_development;
  });

  var ReactElement = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, '__esModule', {
      value: true
    });
    exports.default = exports.test = exports.serialize = void 0;

    var ReactIs = function (obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};

        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }

        newObj.default = obj;
        return newObj;
      }
    }
    /**
     * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
     *
     * This source code is licensed under the MIT license found in the
     * LICENSE file in the root directory of this source tree.
     */
    // Given element.props.children, or subtree during recursive traversal,
    // return flattened array of children.
    (reactIs);

    var getChildren = function (arg, children) {
      if (children === void 0) {
        children = [];
      }

      if (Array.isArray(arg)) {
        arg.forEach(function (item) {
          getChildren(item, children);
        });
      } else if (arg != null && arg !== false) {
        children.push(arg);
      }

      return children;
    };

    var getType = function (element) {
      var type = element.type;

      if (typeof type === 'string') {
        return type;
      }

      if (typeof type === 'function') {
        return type.displayName || type.name || 'Unknown';
      }

      if (ReactIs.isFragment(element)) {
        return 'React.Fragment';
      }

      if (ReactIs.isSuspense(element)) {
        return 'React.Suspense';
      }

      if (typeof type === 'object' && type !== null) {
        if (ReactIs.isContextProvider(element)) {
          return 'Context.Provider';
        }

        if (ReactIs.isContextConsumer(element)) {
          return 'Context.Consumer';
        }

        if (ReactIs.isForwardRef(element)) {
          var functionName = type.render.displayName || type.render.name || '';
          return functionName !== '' ? 'ForwardRef(' + functionName + ')' : 'ForwardRef';
        }

        if (ReactIs.isMemo(type)) {
          var _functionName = type.type.displayName || type.type.name || '';

          return _functionName !== '' ? 'Memo(' + _functionName + ')' : 'Memo';
        }
      }

      return 'UNDEFINED';
    };

    var getPropKeys = function (element) {
      var props = element.props;
      return Object.keys(props).filter(function (key) {
        return key !== 'children' && props[key] !== undefined;
      }).sort();
    };

    var serialize = function (element, config, indentation, depth, refs, printer) {
      return ++depth > config.maxDepth ? (0, markup.printElementAsLeaf)(getType(element), config) : (0, markup.printElement)(getType(element), (0, markup.printProps)(getPropKeys(element), element.props, config, indentation + config.indent, depth, refs, printer), (0, markup.printChildren)(getChildren(element.props.children), config, indentation + config.indent, depth, refs, printer), config, indentation);
    };

    exports.serialize = serialize;

    var test = function (val) {
      return val && ReactIs.isElement(val);
    };

    exports.test = test;
    exports.default = {
      serialize: serialize,
      test: test
    };
  });
  unwrapExports(ReactElement);
  var ReactElement_1 = ReactElement.test;
  var ReactElement_2 = ReactElement.serialize;

  var ReactTestComponent = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, '__esModule', {
      value: true
    });
    exports.default = exports.test = exports.serialize = void 0;
    var Symbol = commonjsGlobal['jest-symbol-do-not-touch'] || commonjsGlobal.Symbol;
    var testSymbol = Symbol.for('react.test.json');

    var getPropKeys = function (object) {
      var props = object.props;
      return props ? Object.keys(props).filter(function (key) {
        return props[key] !== undefined;
      }).sort() : [];
    };

    var serialize = function (object, config, indentation, depth, refs, printer) {
      return ++depth > config.maxDepth ? (0, markup.printElementAsLeaf)(object.type, config) : (0, markup.printElement)(object.type, object.props ? (0, markup.printProps)(getPropKeys(object), object.props, config, indentation + config.indent, depth, refs, printer) : '', object.children ? (0, markup.printChildren)(object.children, config, indentation + config.indent, depth, refs, printer) : '', config, indentation);
    };

    exports.serialize = serialize;

    var test = function (val) {
      return val && val.$$typeof === testSymbol;
    };

    exports.test = test;
    exports.default = {
      serialize: serialize,
      test: test
    };
  });
  unwrapExports(ReactTestComponent);
  var ReactTestComponent_1 = ReactTestComponent.test;
  var ReactTestComponent_2 = ReactTestComponent.serialize;

  var build = createCommonjsModule(function (module) {

    var _ansiStyles = _interopRequireDefault(ansiStyles);

    var _AsymmetricMatcher = _interopRequireDefault(AsymmetricMatcher);

    var _ConvertAnsi = _interopRequireDefault(ConvertAnsi);

    var _DOMCollection = _interopRequireDefault(DOMCollection);

    var _DOMElement = _interopRequireDefault(DOMElement);

    var _Immutable = _interopRequireDefault(Immutable);

    var _ReactElement = _interopRequireDefault(ReactElement);

    var _ReactTestComponent = _interopRequireDefault(ReactTestComponent);

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }

    var Symbol = commonjsGlobal['jest-symbol-do-not-touch'] || commonjsGlobal.Symbol;
    var toString = Object.prototype.toString;
    var toISOString = Date.prototype.toISOString;
    var errorToString = Error.prototype.toString;
    var regExpToString = RegExp.prototype.toString;
    var symbolToString = Symbol.prototype.toString;
    /**
     * Explicitly comparing typeof constructor to function avoids undefined as name
     * when mock identity-obj-proxy returns the key as the value for any key.
     */

    var getConstructorName = function (val) {
      return typeof val.constructor === 'function' && val.constructor.name || 'Object';
    };
    /* global window */

    /** Is val is equal to global window object? Works even if it does not exist :) */


    var isWindow = function (val) {
      return typeof window !== 'undefined' && val === window;
    };

    var SYMBOL_REGEXP = /^Symbol\((.*)\)(.*)$/;
    var NEWLINE_REGEXP = /\n/gi;

    var PrettyFormatPluginError =
    /*#__PURE__*/
    function (_Error) {
      _inheritsLoose(PrettyFormatPluginError, _Error);

      function PrettyFormatPluginError(message, stack) {
        var _this = _Error.call(this, message) || this;

        _this.stack = stack;
        _this.name = _this.constructor.name;
        return _this;
      }

      return PrettyFormatPluginError;
    }(_wrapNativeSuper(Error));

    function isToStringedArrayType(toStringed) {
      return toStringed === '[object Array]' || toStringed === '[object ArrayBuffer]' || toStringed === '[object DataView]' || toStringed === '[object Float32Array]' || toStringed === '[object Float64Array]' || toStringed === '[object Int8Array]' || toStringed === '[object Int16Array]' || toStringed === '[object Int32Array]' || toStringed === '[object Uint8Array]' || toStringed === '[object Uint8ClampedArray]' || toStringed === '[object Uint16Array]' || toStringed === '[object Uint32Array]';
    }

    function printNumber(val) {
      return Object.is(val, -0) ? '-0' : String(val);
    }

    function printBigInt(val) {
      return String(val + "n");
    }

    function printFunction(val, printFunctionName) {
      if (!printFunctionName) {
        return '[Function]';
      }

      return '[Function ' + (val.name || 'anonymous') + ']';
    }

    function printSymbol(val) {
      return symbolToString.call(val).replace(SYMBOL_REGEXP, 'Symbol($1)');
    }

    function printError(val) {
      return '[' + errorToString.call(val) + ']';
    }
    /**
     * The first port of call for printing an object, handles most of the
     * data-types in JS.
     */


    function printBasicValue(val, printFunctionName, escapeRegex, escapeString) {
      if (val === true || val === false) {
        return '' + val;
      }

      if (val === undefined) {
        return 'undefined';
      }

      if (val === null) {
        return 'null';
      }

      var typeOf = typeof val;

      if (typeOf === 'number') {
        return printNumber(val);
      }

      if (typeOf === 'bigint') {
        return printBigInt(val);
      }

      if (typeOf === 'string') {
        if (escapeString) {
          return '"' + val.replace(/"|\\/g, '\\$&') + '"';
        }

        return '"' + val + '"';
      }

      if (typeOf === 'function') {
        return printFunction(val, printFunctionName);
      }

      if (typeOf === 'symbol') {
        return printSymbol(val);
      }

      var toStringed = toString.call(val);

      if (toStringed === '[object WeakMap]') {
        return 'WeakMap {}';
      }

      if (toStringed === '[object WeakSet]') {
        return 'WeakSet {}';
      }

      if (toStringed === '[object Function]' || toStringed === '[object GeneratorFunction]') {
        return printFunction(val, printFunctionName);
      }

      if (toStringed === '[object Symbol]') {
        return printSymbol(val);
      }

      if (toStringed === '[object Date]') {
        return isNaN(+val) ? 'Date { NaN }' : toISOString.call(val);
      }

      if (toStringed === '[object Error]') {
        return printError(val);
      }

      if (toStringed === '[object RegExp]') {
        if (escapeRegex) {
          // https://github.com/benjamingr/RegExp.escape/blob/master/polyfill.js
          return regExpToString.call(val).replace(/[\\^$*+?.()|[\]{}]/g, '\\$&');
        }

        return regExpToString.call(val);
      }

      if (val instanceof Error) {
        return printError(val);
      }

      return null;
    }
    /**
     * Handles more complex objects ( such as objects with circular references.
     * maps and sets etc )
     */


    function printComplexValue(val, config, indentation, depth, refs, hasCalledToJSON) {
      if (refs.indexOf(val) !== -1) {
        return '[Circular]';
      }

      refs = refs.slice();
      refs.push(val);
      var hitMaxDepth = ++depth > config.maxDepth;
      var min = config.min;

      if (config.callToJSON && !hitMaxDepth && val.toJSON && typeof val.toJSON === 'function' && !hasCalledToJSON) {
        return printer(val.toJSON(), config, indentation, depth, refs, true);
      }

      var toStringed = toString.call(val);

      if (toStringed === '[object Arguments]') {
        return hitMaxDepth ? '[Arguments]' : (min ? '' : 'Arguments ') + '[' + (0, collections.printListItems)(val, config, indentation, depth, refs, printer) + ']';
      }

      if (isToStringedArrayType(toStringed)) {
        return hitMaxDepth ? '[' + val.constructor.name + ']' : (min ? '' : val.constructor.name + ' ') + '[' + (0, collections.printListItems)(val, config, indentation, depth, refs, printer) + ']';
      }

      if (toStringed === '[object Map]') {
        return hitMaxDepth ? '[Map]' : 'Map {' + (0, collections.printIteratorEntries)(val.entries(), config, indentation, depth, refs, printer, ' => ') + '}';
      }

      if (toStringed === '[object Set]') {
        return hitMaxDepth ? '[Set]' : 'Set {' + (0, collections.printIteratorValues)(val.values(), config, indentation, depth, refs, printer) + '}';
      } // Avoid failure to serialize global window object in jsdom test environment.
      // For example, not even relevant if window is prop of React element.


      return hitMaxDepth || isWindow(val) ? '[' + getConstructorName(val) + ']' : (min ? '' : getConstructorName(val) + ' ') + '{' + (0, collections.printObjectProperties)(val, config, indentation, depth, refs, printer) + '}';
    }

    function isNewPlugin(plugin) {
      return plugin.serialize != null;
    }

    function printPlugin(plugin, val, config, indentation, depth, refs) {
      var printed;

      try {
        printed = isNewPlugin(plugin) ? plugin.serialize(val, config, indentation, depth, refs, printer) : plugin.print(val, function (valChild) {
          return printer(valChild, config, indentation, depth, refs);
        }, function (str) {
          var indentationNext = indentation + config.indent;
          return indentationNext + str.replace(NEWLINE_REGEXP, '\n' + indentationNext);
        }, {
          edgeSpacing: config.spacingOuter,
          min: config.min,
          spacing: config.spacingInner
        }, config.colors);
      } catch (error) {
        throw new PrettyFormatPluginError(error.message, error.stack);
      }

      if (typeof printed !== 'string') {
        throw new Error("pretty-format: Plugin must return type \"string\" but instead returned \"" + typeof printed + "\".");
      }

      return printed;
    }

    function findPlugin(plugins, val) {
      for (var p = 0; p < plugins.length; p++) {
        try {
          if (plugins[p].test(val)) {
            return plugins[p];
          }
        } catch (error) {
          throw new PrettyFormatPluginError(error.message, error.stack);
        }
      }

      return null;
    }

    function printer(val, config, indentation, depth, refs, hasCalledToJSON) {
      var plugin = findPlugin(config.plugins, val);

      if (plugin !== null) {
        return printPlugin(plugin, val, config, indentation, depth, refs);
      }

      var basicResult = printBasicValue(val, config.printFunctionName, config.escapeRegex, config.escapeString);

      if (basicResult !== null) {
        return basicResult;
      }

      return printComplexValue(val, config, indentation, depth, refs, hasCalledToJSON);
    }

    var DEFAULT_THEME = {
      comment: 'gray',
      content: 'reset',
      prop: 'yellow',
      tag: 'cyan',
      value: 'green'
    };
    var DEFAULT_THEME_KEYS = Object.keys(DEFAULT_THEME);
    var DEFAULT_OPTIONS = {
      callToJSON: true,
      escapeRegex: false,
      escapeString: true,
      highlight: false,
      indent: 2,
      maxDepth: Infinity,
      min: false,
      plugins: [],
      printFunctionName: true,
      theme: DEFAULT_THEME
    };

    function validateOptions(options) {
      Object.keys(options).forEach(function (key) {
        if (!DEFAULT_OPTIONS.hasOwnProperty(key)) {
          throw new Error("pretty-format: Unknown option \"" + key + "\".");
        }
      });

      if (options.min && options.indent !== undefined && options.indent !== 0) {
        throw new Error('pretty-format: Options "min" and "indent" cannot be used together.');
      }

      if (options.theme !== undefined) {
        if (options.theme === null) {
          throw new Error("pretty-format: Option \"theme\" must not be null.");
        }

        if (typeof options.theme !== 'object') {
          throw new Error("pretty-format: Option \"theme\" must be of type \"object\" but instead received \"" + typeof options.theme + "\".");
        }
      }
    }

    var getColorsHighlight = function (options) {
      return DEFAULT_THEME_KEYS.reduce(function (colors, key) {
        var value = options.theme && options.theme[key] !== undefined ? options.theme[key] : DEFAULT_THEME[key];
        var color = _ansiStyles.default[value];

        if (color && typeof color.close === 'string' && typeof color.open === 'string') {
          colors[key] = color;
        } else {
          throw new Error("pretty-format: Option \"theme\" has a key \"" + key + "\" whose value \"" + value + "\" is undefined in ansi-styles.");
        }

        return colors;
      }, Object.create(null));
    };

    var getColorsEmpty = function () {
      return DEFAULT_THEME_KEYS.reduce(function (colors, key) {
        colors[key] = {
          close: '',
          open: ''
        };
        return colors;
      }, Object.create(null));
    };

    var getPrintFunctionName = function (options) {
      return options && options.printFunctionName !== undefined ? options.printFunctionName : DEFAULT_OPTIONS.printFunctionName;
    };

    var getEscapeRegex = function (options) {
      return options && options.escapeRegex !== undefined ? options.escapeRegex : DEFAULT_OPTIONS.escapeRegex;
    };

    var getEscapeString = function (options) {
      return options && options.escapeString !== undefined ? options.escapeString : DEFAULT_OPTIONS.escapeString;
    };

    var getConfig = function (options) {
      return {
        callToJSON: options && options.callToJSON !== undefined ? options.callToJSON : DEFAULT_OPTIONS.callToJSON,
        colors: options && options.highlight ? getColorsHighlight(options) : getColorsEmpty(),
        escapeRegex: getEscapeRegex(options),
        escapeString: getEscapeString(options),
        indent: options && options.min ? '' : createIndent(options && options.indent !== undefined ? options.indent : DEFAULT_OPTIONS.indent),
        maxDepth: options && options.maxDepth !== undefined ? options.maxDepth : DEFAULT_OPTIONS.maxDepth,
        min: options && options.min !== undefined ? options.min : DEFAULT_OPTIONS.min,
        plugins: options && options.plugins !== undefined ? options.plugins : DEFAULT_OPTIONS.plugins,
        printFunctionName: getPrintFunctionName(options),
        spacingInner: options && options.min ? ' ' : '\n',
        spacingOuter: options && options.min ? '' : '\n'
      };
    };

    function createIndent(indent) {
      return new Array(indent + 1).join(' ');
    }
    /**
     * Returns a presentation string of your `val` object
     * @param val any potential JavaScript object
     * @param options Custom settings
     */


    function prettyFormat(val, options) {
      if (options) {
        validateOptions(options);

        if (options.plugins) {
          var plugin = findPlugin(options.plugins, val);

          if (plugin !== null) {
            return printPlugin(plugin, val, getConfig(options), '', 0, []);
          }
        }
      }

      var basicResult = printBasicValue(val, getPrintFunctionName(options), getEscapeRegex(options), getEscapeString(options));

      if (basicResult !== null) {
        return basicResult;
      }

      return printComplexValue(val, getConfig(options), '', 0, []);
    }

    prettyFormat.plugins = {
      AsymmetricMatcher: _AsymmetricMatcher.default,
      ConvertAnsi: _ConvertAnsi.default,
      DOMCollection: _DOMCollection.default,
      DOMElement: _DOMElement.default,
      Immutable: _Immutable.default,
      ReactElement: _ReactElement.default,
      ReactTestComponent: _ReactTestComponent.default
    };
    /* eslint-disable-next-line no-redeclare */

    module.exports = prettyFormat;
  });
  var prettyFormat = unwrapExports(build);

  /*!
   * Shim for MutationObserver interface
   * Author: Graeme Yeates (github.com/megawac)
   * Repository: https://github.com/megawac/MutationObserver.js
   * License: WTFPL V2, 2004 (wtfpl.net).
   * Though credit and staring the repo will make me feel pretty, you can modify and redistribute as you please.
   * Attempts to follow spec (https://www.w3.org/TR/dom/#mutation-observers) as closely as possible for native javascript
   * See https://github.com/WebKit/webkit/blob/master/Source/WebCore/dom/MutationObserver.cpp for current webkit source c++ implementation
   */

  /**
   * prefix bugs:
      - https://bugs.webkit.org/show_bug.cgi?id=85161
      - https://bugzilla.mozilla.org/show_bug.cgi?id=749920
   * Don't use WebKitMutationObserver as Safari (6.0.5-6.1) use a buggy implementation
  */
  var MutationObserver = function (undefined$1) {
    if (typeof window !== 'undefined' && typeof window.MutationObserver !== 'undefined') {
      return window.MutationObserver;
    }
    /**
     * @param {function(Array.<MutationRecord>, MutationObserver)} listener
     * @constructor
     */


    function MutationObserver(listener) {
      /**
       * @type {Array.<Object>}
       * @private
       */
      this._watched = [];
      /** @private */

      this._listener = listener;
    }
    /**
     * Start a recursive timeout function to check all items being observed for mutations
     * @type {MutationObserver} observer
     * @private
     */


    function startMutationChecker(observer) {
      (function check() {
        var mutations = observer.takeRecords();

        if (mutations.length) {
          // fire away
          // calling the listener with context is not spec but currently consistent with FF and WebKit
          observer._listener(mutations, observer);
        }
        /** @private */


        observer._timeout = setTimeout(check, MutationObserver._period);
      })();
    }
    /**
     * Period to check for mutations (~32 times/sec)
     * @type {number}
     * @expose
     */


    MutationObserver._period = 30
    /*ms+runtime*/
    ;
    /**
     * Exposed API
     * @expose
     * @final
     */

    MutationObserver.prototype = {
      /**
       * see https://dom.spec.whatwg.org/#dom-mutationobserver-observe
       * not going to throw here but going to follow the current spec config sets
       * @param {Node|null} $target
       * @param {Object|null} config : MutationObserverInit configuration dictionary
       * @expose
       * @return undefined
       */
      observe: function observe($target, config) {
        /**
         * Using slightly different names so closure can go ham
         * @type {!Object} : A custom mutation config
         */
        var settings = {
          attr: !!(config.attributes || config.attributeFilter || config.attributeOldValue),
          // some browsers enforce that subtree must be set with childList, attributes or characterData.
          // We don't care as spec doesn't specify this rule.
          kids: !!config.childList,
          descendents: !!config.subtree,
          charData: !!(config.characterData || config.characterDataOldValue)
        };
        var watched = this._watched; // remove already observed target element from pool

        for (var i = 0; i < watched.length; i++) {
          if (watched[i].tar === $target) watched.splice(i, 1);
        }

        if (config.attributeFilter) {
          /**
           * converts to a {key: true} dict for faster lookup
           * @type {Object.<String,Boolean>}
           */
          settings.afilter = reduce(config.attributeFilter, function (a, b) {
            a[b] = true;
            return a;
          }, {});
        }

        watched.push({
          tar: $target,
          fn: createMutationSearcher($target, settings)
        }); // reconnect if not connected

        if (!this._timeout) {
          startMutationChecker(this);
        }
      },

      /**
       * Finds mutations since last check and empties the "record queue" i.e. mutations will only be found once
       * @expose
       * @return {Array.<MutationRecord>}
       */
      takeRecords: function takeRecords() {
        var mutations = [];
        var watched = this._watched;

        for (var i = 0; i < watched.length; i++) {
          watched[i].fn(mutations);
        }

        return mutations;
      },

      /**
       * @expose
       * @return undefined
       */
      disconnect: function disconnect() {
        this._watched = []; // clear the stuff being observed

        clearTimeout(this._timeout); // ready for garbage collection

        /** @private */

        this._timeout = null;
      }
    };
    /**
     * Simple MutationRecord pseudoclass. No longer exposing as its not fully compliant
     * @param {Object} data
     * @return {Object} a MutationRecord
     */

    function MutationRecord(data) {
      var settings = {
        // technically these should be on proto so hasOwnProperty will return false for non explicitly props
        type: null,
        target: null,
        addedNodes: [],
        removedNodes: [],
        previousSibling: null,
        nextSibling: null,
        attributeName: null,
        attributeNamespace: null,
        oldValue: null
      };

      for (var prop in data) {
        if (has(settings, prop) && data[prop] !== undefined$1) settings[prop] = data[prop];
      }

      return settings;
    }
    /**
     * Creates a func to find all the mutations
     *
     * @param {Node} $target
     * @param {!Object} config : A custom mutation config
     */


    function createMutationSearcher($target, config) {
      /** type {Elestuct} */
      var $oldstate = clone($target, config); // create the cloned datastructure

      /**
       * consumes array of mutations we can push to
       *
       * @param {Array.<MutationRecord>} mutations
       */

      return function (mutations) {
        var olen = mutations.length,
            dirty;

        if (config.charData && $target.nodeType === 3 && $target.nodeValue !== $oldstate.charData) {
          mutations.push(new MutationRecord({
            type: "characterData",
            target: $target,
            oldValue: $oldstate.charData
          }));
        } // Alright we check base level changes in attributes... easy


        if (config.attr && $oldstate.attr) {
          findAttributeMutations(mutations, $target, $oldstate.attr, config.afilter);
        } // check childlist or subtree for mutations


        if (config.kids || config.descendents) {
          dirty = searchSubtree(mutations, $target, $oldstate, config);
        } // reclone data structure if theres changes


        if (dirty || mutations.length !== olen) {
          /** type {Elestuct} */
          $oldstate = clone($target, config);
        }
      };
    }
    /* attributes + attributeFilter helpers */
    // Check if the environment has the attribute bug (#4) which cause
    // element.attributes.style to always be null.


    var hasAttributeBug = false;

    if (typeof document !== 'undefined') {
      var testElement = document.createElement('i');
      testElement.style.top = 0;
      hasAttributeBug = testElement.attributes.style.value != 'null';
    }
    /**
     * Gets an attribute value in an environment without attribute bug
     *
     * @param {Node} el
     * @param {Attr} attr
     * @return {String} an attribute value
     */


    var getAttributeValue = hasAttributeBug ? function (el, attr) {
      // There is a potential for a warning to occur here if the attribute is a
      // custom attribute in IE<9 with a custom .toString() method. This is
      // just a warning and doesn't affect execution (see #21)
      return attr.value;
    }
    /**
     * Gets an attribute value with special hack for style attribute (see #4)
     *
     * @param {Node} el
     * @param {Attr} attr
     * @return {String} an attribute value
     */
    : function (el, attr) {
      // As with getAttributeSimple there is a potential warning for custom attribtues in IE7.
      return attr.name !== "style" ? attr.value : el.style.cssText;
    };
    /**
     * fast helper to check to see if attributes object of an element has changed
     * doesnt handle the textnode case
     *
     * @param {Array.<MutationRecord>} mutations
     * @param {Node} $target
     * @param {Object.<string, string>} $oldstate : Custom attribute clone data structure from clone
     * @param {Object} filter
     */

    function findAttributeMutations(mutations, $target, $oldstate, filter) {
      var checked = {};
      var attributes = $target.attributes;
      var attr;
      var i = attributes.length;

      while (i--) {
        attr = attributes[i];
        name = attr.name;

        if (!filter || has(filter, name)) {
          if (getAttributeValue($target, attr) !== $oldstate[name]) {
            // The pushing is redundant but gzips very nicely
            mutations.push(MutationRecord({
              type: "attributes",
              target: $target,
              attributeName: name,
              oldValue: $oldstate[name],
              attributeNamespace: attr.namespaceURI // in ie<8 it incorrectly will return undefined

            }));
          }

          checked[name] = true;
        }
      }

      for (var name in $oldstate) {
        if (!checked[name]) {
          mutations.push(MutationRecord({
            target: $target,
            type: "attributes",
            attributeName: name,
            oldValue: $oldstate[name]
          }));
        }
      }
    }
    /**
     * searchSubtree: array of mutations so far, element, element clone, bool
     * synchronous dfs comparision of two nodes
     * This function is applied to any observed element with childList or subtree specified
     * Sorry this is kind of confusing as shit, tried to comment it a bit...
     * codereview.stackexchange.com/questions/38351 discussion of an earlier version of this func
     *
     * @param {Array} mutations
     * @param {Node} $target
     * @param {!Object} $oldstate : A custom cloned node from clone()
     * @param {!Object} config : A custom mutation config
     */


    function searchSubtree(mutations, $target, $oldstate, config) {
      // Track if the tree is dirty and has to be recomputed (#14).
      var dirty;
      /*
       * Helper to identify node rearrangment and stuff...
       * There is no gaurentee that the same node will be identified for both added and removed nodes
       * if the positions have been shuffled.
       * conflicts array will be emptied by end of operation
       */

      function resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes) {
        // the distance between the first conflicting node and the last
        var distance = conflicts.length - 1; // prevents same conflict being resolved twice consider when two nodes switch places.
        // only one should be given a mutation event (note -~ is used as a math.ceil shorthand)

        var counter = -~((distance - numAddedNodes) / 2);
        var $cur;
        var oldstruct;
        var conflict;

        while (conflict = conflicts.pop()) {
          $cur = $kids[conflict.i];
          oldstruct = $oldkids[conflict.j]; // attempt to determine if there was node rearrangement... won't gaurentee all matches
          // also handles case where added/removed nodes cause nodes to be identified as conflicts

          if (config.kids && counter && Math.abs(conflict.i - conflict.j) >= distance) {
            mutations.push(MutationRecord({
              type: "childList",
              target: node,
              addedNodes: [$cur],
              removedNodes: [$cur],
              // haha don't rely on this please
              nextSibling: $cur.nextSibling,
              previousSibling: $cur.previousSibling
            }));
            counter--; // found conflict
          } // Alright we found the resorted nodes now check for other types of mutations


          if (config.attr && oldstruct.attr) findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);

          if (config.charData && $cur.nodeType === 3 && $cur.nodeValue !== oldstruct.charData) {
            mutations.push(MutationRecord({
              type: "characterData",
              target: $cur,
              oldValue: oldstruct.charData
            }));
          } // now look @ subtree


          if (config.descendents) findMutations($cur, oldstruct);
        }
      }
      /**
       * Main worker. Finds and adds mutations if there are any
       * @param {Node} node
       * @param {!Object} old : A cloned data structure using internal clone
       */


      function findMutations(node, old) {
        var $kids = node.childNodes;
        var $oldkids = old.kids;
        var klen = $kids.length; // $oldkids will be undefined for text and comment nodes

        var olen = $oldkids ? $oldkids.length : 0; // if (!olen && !klen) return; // both empty; clearly no changes
        // we delay the intialization of these for marginal performance in the expected case (actually quite signficant on large subtrees when these would be otherwise unused)
        // map of checked element of ids to prevent registering the same conflict twice

        var map; // array of potential conflicts (ie nodes that may have been re arranged)

        var conflicts;
        var id; // element id from getElementId helper

        var idx; // index of a moved or inserted element

        var oldstruct; // current and old nodes

        var $cur;
        var $old; // track the number of added nodes so we can resolve conflicts more accurately

        var numAddedNodes = 0; // iterate over both old and current child nodes at the same time

        var i = 0,
            j = 0; // while there is still anything left in $kids or $oldkids (same as i < $kids.length || j < $oldkids.length;)

        while (i < klen || j < olen) {
          // current and old nodes at the indexs
          $cur = $kids[i];
          oldstruct = $oldkids[j];
          $old = oldstruct && oldstruct.node;

          if ($cur === $old) {
            // expected case - optimized for this case
            // check attributes as specified by config
            if (config.attr && oldstruct.attr)
              /* oldstruct.attr instead of textnode check */
              findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter); // check character data if node is a comment or textNode and it's being observed

            if (config.charData && oldstruct.charData !== undefined$1 && $cur.nodeValue !== oldstruct.charData) {
              mutations.push(MutationRecord({
                type: "characterData",
                target: $cur,
                oldValue: oldstruct.charData
              }));
            } // resolve conflicts; it will be undefined if there are no conflicts - otherwise an array


            if (conflicts) resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes); // recurse on next level of children. Avoids the recursive call when there are no children left to iterate

            if (config.descendents && ($cur.childNodes.length || oldstruct.kids && oldstruct.kids.length)) findMutations($cur, oldstruct);
            i++;
            j++;
          } else {
            // (uncommon case) lookahead until they are the same again or the end of children
            dirty = true;

            if (!map) {
              // delayed initalization (big perf benefit)
              map = {};
              conflicts = [];
            }

            if ($cur) {
              // check id is in the location map otherwise do a indexOf search
              if (!map[id = getElementId($cur)]) {
                // to prevent double checking
                // mark id as found
                map[id] = true; // custom indexOf using comparitor checking oldkids[i].node === $cur

                if ((idx = indexOfCustomNode($oldkids, $cur, j)) === -1) {
                  if (config.kids) {
                    mutations.push(MutationRecord({
                      type: "childList",
                      target: node,
                      addedNodes: [$cur],
                      // $cur is a new node
                      nextSibling: $cur.nextSibling,
                      previousSibling: $cur.previousSibling
                    }));
                    numAddedNodes++;
                  }
                } else {
                  conflicts.push({
                    // add conflict
                    i: i,
                    j: idx
                  });
                }
              }

              i++;
            }

            if ($old && // special case: the changes may have been resolved: i and j appear congurent so we can continue using the expected case
            $old !== $kids[i]) {
              if (!map[id = getElementId($old)]) {
                map[id] = true;

                if ((idx = indexOf($kids, $old, i)) === -1) {
                  if (config.kids) {
                    mutations.push(MutationRecord({
                      type: "childList",
                      target: old.node,
                      removedNodes: [$old],
                      nextSibling: $oldkids[j + 1],
                      // praise no indexoutofbounds exception
                      previousSibling: $oldkids[j - 1]
                    }));
                    numAddedNodes--;
                  }
                } else {
                  conflicts.push({
                    i: idx,
                    j: j
                  });
                }
              }

              j++;
            }
          } // end uncommon case

        } // end loop
        // resolve any remaining conflicts


        if (conflicts) resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
      }

      findMutations($target, $oldstate);
      return dirty;
    }
    /**
     * Utility
     * Cones a element into a custom data structure designed for comparision. https://gist.github.com/megawac/8201012
     *
     * @param {Node} $target
     * @param {!Object} config : A custom mutation config
     * @return {!Object} : Cloned data structure
     */


    function clone($target, config) {
      var recurse = true; // set true so childList we'll always check the first level

      return function copy($target) {
        var elestruct = {
          /** @type {Node} */
          node: $target
        }; // Store current character data of target text or comment node if the config requests
        // those properties to be observed.

        if (config.charData && ($target.nodeType === 3 || $target.nodeType === 8)) {
          elestruct.charData = $target.nodeValue;
        } // its either a element, comment, doc frag or document node
        else {
            // Add attr only if subtree is specified or top level and avoid if
            // attributes is a document object (#13).
            if (config.attr && recurse && $target.nodeType === 1) {
              /**
               * clone live attribute list to an object structure {name: val}
               * @type {Object.<string, string>}
               */
              elestruct.attr = reduce($target.attributes, function (memo, attr) {
                if (!config.afilter || config.afilter[attr.name]) {
                  memo[attr.name] = getAttributeValue($target, attr);
                }

                return memo;
              }, {});
            } // whether we should iterate the children of $target node


            if (recurse && (config.kids || config.charData || config.attr && config.descendents)) {
              /** @type {Array.<!Object>} : Array of custom clone */
              elestruct.kids = map($target.childNodes, copy);
            }

            recurse = config.descendents;
          }

        return elestruct;
      }($target);
    }
    /**
     * indexOf an element in a collection of custom nodes
     *
     * @param {NodeList} set
     * @param {!Object} $node : A custom cloned node
     * @param {number} idx : index to start the loop
     * @return {number}
     */


    function indexOfCustomNode(set, $node, idx) {
      return indexOf(set, $node, idx, JSCompiler_renameProperty("node"));
    } // using a non id (eg outerHTML or nodeValue) is extremely naive and will run into issues with nodes that may appear the same like <li></li>


    var counter = 1; // don't use 0 as id (falsy)

    /** @const */

    var expando = "mo_id";
    /**
     * Attempt to uniquely id an element for hashing. We could optimize this for legacy browsers but it hopefully wont be called enough to be a concern
     *
     * @param {Node} $ele
     * @return {(string|number)}
     */

    function getElementId($ele) {
      try {
        return $ele.id || ($ele[expando] = $ele[expando] || counter++);
      } catch (o_O) {
        // ie <8 will throw if you set an unknown property on a text node
        try {
          return $ele.nodeValue; // naive
        } catch (shitie) {
          // when text node is removed: https://gist.github.com/megawac/8355978 :(
          return counter++;
        }
      }
    }
    /**
     * **map** Apply a mapping function to each item of a set
     * @param {Array|NodeList} set
     * @param {Function} iterator
     */


    function map(set, iterator) {
      var results = [];

      for (var index = 0; index < set.length; index++) {
        results[index] = iterator(set[index], index, set);
      }

      return results;
    }
    /**
     * **Reduce** builds up a single result from a list of values
     * @param {Array|NodeList|NamedNodeMap} set
     * @param {Function} iterator
     * @param {*} [memo] Initial value of the memo.
     */


    function reduce(set, iterator, memo) {
      for (var index = 0; index < set.length; index++) {
        memo = iterator(memo, set[index], index, set);
      }

      return memo;
    }
    /**
     * **indexOf** find index of item in collection.
     * @param {Array|NodeList} set
     * @param {Object} item
     * @param {number} idx
     * @param {string} [prop] Property on set item to compare to item
     */


    function indexOf(set, item, idx, prop) {
      for (;
      /*idx = ~~idx*/
      idx < set.length; idx++) {
        // start idx is always given as this is internal
        if ((prop ? set[idx][prop] : set[idx]) === item) return idx;
      }

      return -1;
    }
    /**
     * @param {Object} obj
     * @param {(string|number)} prop
     * @return {boolean}
     */


    function has(obj, prop) {
      return obj[prop] !== undefined$1; // will be nicely inlined by gcc
    } // GCC hack see https://stackoverflow.com/a/23202438/1517919


    function JSCompiler_renameProperty(a) {
      return a;
    }

    return MutationObserver;
  }(void 0);

  var lib = createCommonjsModule(function (module, exports) {

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0; // Augment Window interface with the Date declaratoin,
    // because typescript does not expose it for now.
    // Check https://github.com/Microsoft/TypeScript/issues/19816 for more info
    // Used to avoid using Jest's fake timers and Date.now mocks
    // See https://github.com/TheBrainFamily/wait-for-expect/issues/4 and
    // https://github.com/TheBrainFamily/wait-for-expect/issues/12 for more info

    var _ref = typeof window !== "undefined" ? window : commonjsGlobal,
        setTimeout = _ref.setTimeout,
        now = _ref.Date.now;
    /**
     * Waits for the expectation to pass and returns a Promise
     *
     * @param  expectation  Function  Expectation that has to complete without throwing
     * @param  timeout  Number  Maximum wait interval, 4500ms by default
     * @param  interval  Number  Wait-between-retries interval, 50ms by default
     * @return  Promise  Promise to return a callback result
     */


    exports.default = function (expectation) {
      var timeout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 4500;
      var interval = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 50;
      var startTime = now();
      return new Promise(function (resolve, reject) {
        var rejectOrRerun = function (error) {
          if (now() - startTime >= timeout) {
            reject(error);
            return;
          } // eslint-disable-next-line no-use-before-define


          setTimeout(runExpectation, interval);
        };

        function runExpectation() {
          try {
            Promise.resolve(expectation()).then(function () {
              return resolve();
            }).catch(rejectOrRerun);
          } catch (error) {
            rejectOrRerun(error);
          }
        }

        setTimeout(runExpectation, 0);
      });
    };

    module.exports = exports.default;
    module.exports.default = exports.default;
  });
  var waitForExpect = unwrapExports(lib);

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function fuzzyMatches(textToMatch, node, matcher, normalizer) {
    if (typeof textToMatch !== 'string') {
      return false;
    }

    var normalizedText = normalizer(textToMatch);

    if (typeof matcher === 'string') {
      return normalizedText.toLowerCase().includes(matcher.toLowerCase());
    } else if (typeof matcher === 'function') {
      return matcher(normalizedText, node);
    } else {
      return matcher.test(normalizedText);
    }
  }

  function matches(textToMatch, node, matcher, normalizer) {
    if (typeof textToMatch !== 'string') {
      return false;
    }

    var normalizedText = normalizer(textToMatch);

    if (typeof matcher === 'string') {
      return normalizedText === matcher;
    } else if (typeof matcher === 'function') {
      return matcher(normalizedText, node);
    } else {
      return matcher.test(normalizedText);
    }
  }

  function getDefaultNormalizer(_temp) {
    var _ref = _temp === void 0 ? {} : _temp,
        _ref$trim = _ref.trim,
        trim = _ref$trim === void 0 ? true : _ref$trim,
        _ref$collapseWhitespa = _ref.collapseWhitespace,
        collapseWhitespace = _ref$collapseWhitespa === void 0 ? true : _ref$collapseWhitespa;

    return function (text) {
      var normalizedText = text;
      normalizedText = trim ? normalizedText.trim() : normalizedText;
      normalizedText = collapseWhitespace ? normalizedText.replace(/\s+/g, ' ') : normalizedText;
      return normalizedText;
    };
  }
  /**
   * Constructs a normalizer to pass to functions in matches.js
   * @param {boolean|undefined} trim The user-specified value for `trim`, without
   * any defaulting having been applied
   * @param {boolean|undefined} collapseWhitespace The user-specified value for
   * `collapseWhitespace`, without any defaulting having been applied
   * @param {Function|undefined} normalizer The user-specified normalizer
   * @returns {Function} A normalizer
   */


  function makeNormalizer(_ref2) {
    var trim = _ref2.trim,
        collapseWhitespace = _ref2.collapseWhitespace,
        normalizer = _ref2.normalizer;

    if (normalizer) {
      // User has specified a custom normalizer
      if (typeof trim !== 'undefined' || typeof collapseWhitespace !== 'undefined') {
        // They've also specified a value for trim or collapseWhitespace
        throw new Error('trim and collapseWhitespace are not supported with a normalizer. ' + 'If you want to use the default trim and collapseWhitespace logic in your normalizer, ' + 'use "getDefaultNormalizer({trim, collapseWhitespace})" and compose that into your normalizer');
      }

      return normalizer;
    } else {
      // No custom normalizer specified. Just use default.
      return getDefaultNormalizer({
        trim: trim,
        collapseWhitespace: collapseWhitespace
      });
    }
  }

  function getNodeText(node) {
    var window = node.ownerDocument.defaultView;

    if (node.matches('input[type=submit], input[type=button]')) {
      return node.value;
    }

    return Array.from(node.childNodes).filter(function (child) {
      return child.nodeType === window.Node.TEXT_NODE && Boolean(child.textContent);
    }).map(function (c) {
      return c.textContent;
    }).join('');
  }

  var _prettyFormat$plugins = prettyFormat.plugins,
      DOMElement$1 = _prettyFormat$plugins.DOMElement,
      DOMCollection$1 = _prettyFormat$plugins.DOMCollection;

  function prettyDOM(htmlElement, maxLength, options) {
    if (htmlElement.documentElement) {
      htmlElement = htmlElement.documentElement;
    }

    var debugContent = prettyFormat(htmlElement, _extends({
      plugins: [DOMElement$1, DOMCollection$1],
      printFunctionName: false,
      highlight: true
    }, options));
    return maxLength !== undefined && htmlElement.outerHTML.length > maxLength ? debugContent.slice(0, maxLength) + "..." : debugContent;
  }
  /* eslint-disable complexity */


  function debugDOM(htmlElement) {
    var limit = 7000;
    var inNode = typeof process !== 'undefined' && process.versions !== undefined && process.versions.node !== undefined;
    /* istanbul ignore next */

    var window = htmlElement.ownerDocument && htmlElement.ownerDocument.defaultView || undefined;
    var inCypress = typeof global !== 'undefined' && global.Cypress || typeof window !== 'undefined' && window.Cypress;
    /* istanbul ignore else */

    if (inCypress) {
      return '';
    } else if (inNode) {
      return prettyDOM(htmlElement, limit);
    } else {
      return prettyDOM(htmlElement, limit, {
        highlight: false
      });
    }
  }
  /* eslint-enable complexity */


  function getElementError(message, container) {
    return new Error([message, debugDOM(container)].filter(Boolean).join('\n\n'));
  }

  function firstResultOrNull(queryFunction) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    var result = queryFunction.apply(void 0, args);
    if (result.length === 0) return null;
    return result[0];
  }

  function queryAllByAttribute(attribute, container, text, _temp) {
    var _ref = _temp === void 0 ? {} : _temp,
        _ref$exact = _ref.exact,
        exact = _ref$exact === void 0 ? true : _ref$exact,
        collapseWhitespace = _ref.collapseWhitespace,
        trim = _ref.trim,
        normalizer = _ref.normalizer;

    var matcher = exact ? matches : fuzzyMatches;
    var matchNormalizer = makeNormalizer({
      collapseWhitespace: collapseWhitespace,
      trim: trim,
      normalizer: normalizer
    });
    return Array.from(container.querySelectorAll("[" + attribute + "]")).filter(function (node) {
      return matcher(node.getAttribute(attribute), node, text, matchNormalizer);
    });
  }

  function queryByAttribute() {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return firstResultOrNull.apply(void 0, [queryAllByAttribute].concat(args));
  }

  var queryHelpers =
  /*#__PURE__*/
  Object.freeze({
    debugDOM: debugDOM,
    getElementError: getElementError,
    firstResultOrNull: firstResultOrNull,
    queryAllByAttribute: queryAllByAttribute,
    queryByAttribute: queryByAttribute
  });

  function newMutationObserver(onMutation) {
    var MutationObserverConstructor = typeof window !== 'undefined' && typeof window.MutationObserver !== 'undefined' ? window.MutationObserver : MutationObserver;
    return new MutationObserverConstructor(onMutation);
  }

  function getDocument() {
    /* istanbul ignore if */
    if (typeof window === 'undefined') {
      throw new Error('Could not find default container');
    }

    return window.document;
  }
  /*
   * There are browsers for which `setImmediate` is not available. This
   * serves as a polyfill of sorts, adopting `setTimeout` as the closest
   * equivalent
   */


  function getSetImmediate() {
    /* istanbul ignore else */
    if (typeof setImmediate === 'function') {
      return setImmediate;
    } else {
      return function (fn) {
        return setTimeout(fn, 0);
      };
    }
  } // It would be cleaner for this to live inside './queries', but
  // other parts of the code assume that all exports from
  // './queries' are query functions.


  var config = {
    testIdAttribute: 'data-testid',
    // this is to support React's async `act` function.
    // forcing react-testing-library to wrap all async functions would've been
    // a total nightmare (consider wrapping every findBy* query and then also
    // updating `within` so those would be wrapped too. Total nightmare).
    // so we have this config option that's really only intended for
    // react-testing-library to use. For that reason, this feature will remain
    // undocumented.
    asyncWrapper: function (cb) {
      return cb();
    }
  };

  function configure(newConfig) {
    if (typeof newConfig === 'function') {
      // Pass the existing config out to the provided function
      // and accept a delta in return
      newConfig = newConfig(config);
    } // Merge the incoming config delta


    config = _extends({}, config, newConfig);
  }

  function getConfig() {
    return config;
  }

  function waitForElement(callback, _temp) {
    var _ref = _temp === void 0 ? {} : _temp,
        _ref$container = _ref.container,
        container = _ref$container === void 0 ? getDocument() : _ref$container,
        _ref$timeout = _ref.timeout,
        timeout = _ref$timeout === void 0 ? 4500 : _ref$timeout,
        _ref$mutationObserver = _ref.mutationObserverOptions,
        mutationObserverOptions = _ref$mutationObserver === void 0 ? {
      subtree: true,
      childList: true,
      attributes: true,
      characterData: true
    } : _ref$mutationObserver;

    return new Promise(function (resolve, reject) {
      if (typeof callback !== 'function') {
        reject(new Error('waitForElement requires a callback as the first parameter'));
        return;
      }

      var lastError;
      var timer = setTimeout(onTimeout, timeout);
      var observer = newMutationObserver(onMutation);
      observer.observe(container, mutationObserverOptions);

      function onDone(error, result) {
        var setImmediate = getSetImmediate();
        clearTimeout(timer);
        setImmediate(function () {
          return observer.disconnect();
        });

        if (error) {
          reject(error);
        } else {
          resolve(result);
        }
      }

      function onMutation() {
        try {
          var result = callback();

          if (result) {
            onDone(null, result);
          } // If `callback` returns falsy value, wait for the next mutation or timeout.

        } catch (error) {
          // Save the callback error to reject the promise with it.
          lastError = error; // If `callback` throws an error, wait for the next mutation or timeout.
        }
      }

      function onTimeout() {
        onDone(lastError || new Error('Timed out in waitForElement.'), null);
      }

      onMutation();
    });
  }

  function waitForElementWrapper() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return getConfig().asyncWrapper(function () {
      return waitForElement.apply(void 0, args);
    });
  } // The queries here should only be things that are accessible to both users who are using a screen reader
  // and those who are not using a screen reader (with the exception of the data-testid attribute query).


  function queryAllLabelsByText(container, text, _temp) {
    var _ref = _temp === void 0 ? {} : _temp,
        _ref$exact = _ref.exact,
        exact = _ref$exact === void 0 ? true : _ref$exact,
        trim = _ref.trim,
        collapseWhitespace = _ref.collapseWhitespace,
        normalizer = _ref.normalizer;

    var matcher = exact ? matches : fuzzyMatches;
    var matchNormalizer = makeNormalizer({
      collapseWhitespace: collapseWhitespace,
      trim: trim,
      normalizer: normalizer
    });
    return Array.from(container.querySelectorAll('label')).filter(function (label) {
      return matcher(label.textContent, label, text, matchNormalizer);
    });
  }

  function queryAllByLabelText(container, text, _temp2) {
    var _ref2 = _temp2 === void 0 ? {} : _temp2,
        _ref2$selector = _ref2.selector,
        selector = _ref2$selector === void 0 ? '*' : _ref2$selector,
        _ref2$exact = _ref2.exact,
        exact = _ref2$exact === void 0 ? true : _ref2$exact,
        collapseWhitespace = _ref2.collapseWhitespace,
        trim = _ref2.trim,
        normalizer = _ref2.normalizer;

    var matchNormalizer = makeNormalizer({
      collapseWhitespace: collapseWhitespace,
      trim: trim,
      normalizer: normalizer
    });
    var labels = queryAllLabelsByText(container, text, {
      exact: exact,
      normalizer: matchNormalizer
    });
    var labelledElements = labels.map(function (label) {
      if (label.control) {
        return label.control;
      }
      /* istanbul ignore if */


      if (label.getAttribute('for')) {
        // we're using this notation because with the # selector we would have to escape special characters e.g. user.name
        // see https://developer.mozilla.org/en-US/docs/Web/API/Document/querySelector#Escaping_special_characters
        // <label for="someId">text</label><input id="someId" />
        // .control support has landed in jsdom (https://github.com/jsdom/jsdom/issues/2175)
        return container.querySelector("[id=\"" + label.getAttribute('for') + "\"]");
      }

      if (label.getAttribute('id')) {
        // <label id="someId">text</label><input aria-labelledby="someId" />
        return container.querySelector("[aria-labelledby~=\"" + label.getAttribute('id') + "\"]");
      }

      if (label.childNodes.length) {
        // <label>text: <input /></label>
        return label.querySelector(selector);
      }

      return null;
    }).filter(function (label) {
      return label !== null;
    }).concat(queryAllByAttribute('aria-label', container, text, {
      exact: exact
    }));
    var possibleAriaLabelElements = queryAllByText(container, text, {
      exact: exact,
      normalizer: matchNormalizer
    }).filter(function (el) {
      return el.tagName !== 'LABEL';
    }); // don't reprocess labels

    var ariaLabelledElements = possibleAriaLabelElements.reduce(function (allLabelledElements, nextLabelElement) {
      var labelId = nextLabelElement.getAttribute('id');
      if (!labelId) return allLabelledElements; // ARIA labels can label multiple elements

      var labelledNodes = Array.from(container.querySelectorAll("[aria-labelledby~=\"" + labelId + "\"]"));
      return allLabelledElements.concat(labelledNodes);
    }, []);
    return Array.from(new Set([].concat(labelledElements, ariaLabelledElements)));
  }

  function queryByLabelText() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return firstResultOrNull.apply(void 0, [queryAllByLabelText].concat(args));
  }

  function queryAllByText(container, text, _temp3) {
    var _ref3 = _temp3 === void 0 ? {} : _temp3,
        _ref3$selector = _ref3.selector,
        selector = _ref3$selector === void 0 ? '*' : _ref3$selector,
        _ref3$exact = _ref3.exact,
        exact = _ref3$exact === void 0 ? true : _ref3$exact,
        collapseWhitespace = _ref3.collapseWhitespace,
        trim = _ref3.trim,
        _ref3$ignore = _ref3.ignore,
        ignore = _ref3$ignore === void 0 ? 'script, style' : _ref3$ignore,
        normalizer = _ref3.normalizer;

    var matcher = exact ? matches : fuzzyMatches;
    var matchNormalizer = makeNormalizer({
      collapseWhitespace: collapseWhitespace,
      trim: trim,
      normalizer: normalizer
    });
    var baseArray = [];

    if (typeof container.matches === 'function' && container.matches(selector)) {
      baseArray = [container];
    }

    return [].concat(baseArray, Array.from(container.querySelectorAll(selector))).filter(function (node) {
      return !ignore || !node.matches(ignore);
    }).filter(function (node) {
      return matcher(getNodeText(node), node, text, matchNormalizer);
    });
  }

  function queryByText() {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return firstResultOrNull.apply(void 0, [queryAllByText].concat(args));
  }

  function queryAllByTitle(container, text, _temp4) {
    var _ref4 = _temp4 === void 0 ? {} : _temp4,
        _ref4$exact = _ref4.exact,
        exact = _ref4$exact === void 0 ? true : _ref4$exact,
        collapseWhitespace = _ref4.collapseWhitespace,
        trim = _ref4.trim,
        normalizer = _ref4.normalizer;

    var matcher = exact ? matches : fuzzyMatches;
    var matchNormalizer = makeNormalizer({
      collapseWhitespace: collapseWhitespace,
      trim: trim,
      normalizer: normalizer
    });
    return Array.from(container.querySelectorAll('[title], svg > title')).filter(function (node) {
      return matcher(node.getAttribute('title'), node, text, matchNormalizer) || matcher(getNodeText(node), node, text, matchNormalizer);
    });
  }

  function queryByTitle() {
    for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    return firstResultOrNull.apply(void 0, [queryAllByTitle].concat(args));
  }

  function queryAllBySelectText(container, text, _temp5) {
    var _ref5 = _temp5 === void 0 ? {} : _temp5,
        _ref5$exact = _ref5.exact,
        exact = _ref5$exact === void 0 ? true : _ref5$exact,
        collapseWhitespace = _ref5.collapseWhitespace,
        trim = _ref5.trim,
        normalizer = _ref5.normalizer;

    var matcher = exact ? matches : fuzzyMatches;
    var matchNormalizer = makeNormalizer({
      collapseWhitespace: collapseWhitespace,
      trim: trim,
      normalizer: normalizer
    });
    return Array.from(container.querySelectorAll('select')).filter(function (selectNode) {
      var selectedOptions = Array.from(selectNode.options).filter(function (option) {
        return option.selected;
      });
      return selectedOptions.some(function (optionNode) {
        return matcher(getNodeText(optionNode), optionNode, text, matchNormalizer);
      });
    });
  }

  function queryBySelectText() {
    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    return firstResultOrNull.apply(void 0, [queryAllBySelectText].concat(args));
  }

  function getTestIdAttribute() {
    return getConfig().testIdAttribute;
  }

  var queryByPlaceholderText = queryByAttribute.bind(null, 'placeholder');
  var queryAllByPlaceholderText = queryAllByAttribute.bind(null, 'placeholder');

  var queryByTestId = function () {
    for (var _len5 = arguments.length, args = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
      args[_key5] = arguments[_key5];
    }

    return queryByAttribute.apply(void 0, [getTestIdAttribute()].concat(args));
  };

  var queryAllByTestId = function () {
    for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
      args[_key6] = arguments[_key6];
    }

    return queryAllByAttribute.apply(void 0, [getTestIdAttribute()].concat(args));
  };

  var queryByValue = queryByAttribute.bind(null, 'value');
  var queryAllByValue = queryAllByAttribute.bind(null, 'value');
  var queryByRole = queryByAttribute.bind(null, 'role');
  var queryAllByRole = queryAllByAttribute.bind(null, 'role');

  function queryAllByAltText(container, alt, _temp6) {
    var _ref6 = _temp6 === void 0 ? {} : _temp6,
        _ref6$exact = _ref6.exact,
        exact = _ref6$exact === void 0 ? true : _ref6$exact,
        collapseWhitespace = _ref6.collapseWhitespace,
        trim = _ref6.trim,
        normalizer = _ref6.normalizer;

    var matcher = exact ? matches : fuzzyMatches;
    var matchNormalizer = makeNormalizer({
      collapseWhitespace: collapseWhitespace,
      trim: trim,
      normalizer: normalizer
    });
    return Array.from(container.querySelectorAll('img,input,area')).filter(function (node) {
      return matcher(node.getAttribute('alt'), node, alt, matchNormalizer);
    });
  }

  function queryByAltText() {
    for (var _len7 = arguments.length, args = new Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
      args[_key7] = arguments[_key7];
    }

    return firstResultOrNull.apply(void 0, [queryAllByAltText].concat(args));
  }

  function queryAllByDisplayValue(container, value, _temp7) {
    var _ref7 = _temp7 === void 0 ? {} : _temp7,
        _ref7$exact = _ref7.exact,
        exact = _ref7$exact === void 0 ? true : _ref7$exact,
        collapseWhitespace = _ref7.collapseWhitespace,
        trim = _ref7.trim,
        normalizer = _ref7.normalizer;

    var matcher = exact ? matches : fuzzyMatches;
    var matchNormalizer = makeNormalizer({
      collapseWhitespace: collapseWhitespace,
      trim: trim,
      normalizer: normalizer
    });
    return Array.from(container.querySelectorAll("input,textarea,select")).filter(function (node) {
      if (node.tagName === 'SELECT') {
        var selectedOptions = Array.from(node.options).filter(function (option) {
          return option.selected;
        });
        return selectedOptions.some(function (optionNode) {
          return matcher(getNodeText(optionNode), optionNode, value, matchNormalizer);
        });
      } else {
        return matcher(node.value, node, value, matchNormalizer);
      }
    });
  }

  function queryByDisplayValue() {
    for (var _len8 = arguments.length, args = new Array(_len8), _key8 = 0; _key8 < _len8; _key8++) {
      args[_key8] = arguments[_key8];
    }

    return firstResultOrNull.apply(void 0, [queryAllByDisplayValue].concat(args));
  } // getters
  // the reason we're not dynamically generating these functions that look so similar:
  // 1. The error messages are specific to each one and depend on arguments
  // 2. The stack trace will look better because it'll have a helpful method name.


  function getAllByTestId(container, id) {
    for (var _len9 = arguments.length, rest = new Array(_len9 > 2 ? _len9 - 2 : 0), _key9 = 2; _key9 < _len9; _key9++) {
      rest[_key9 - 2] = arguments[_key9];
    }

    var els = queryAllByTestId.apply(void 0, [container, id].concat(rest));

    if (!els.length) {
      throw getElementError("Unable to find an element by: [" + getTestIdAttribute() + "=\"" + id + "\"]", container);
    }

    return els;
  }

  function getByTestId() {
    for (var _len10 = arguments.length, args = new Array(_len10), _key10 = 0; _key10 < _len10; _key10++) {
      args[_key10] = arguments[_key10];
    }

    return firstResultOrNull.apply(void 0, [getAllByTestId].concat(args));
  }

  function getAllByTitle(container, title) {
    for (var _len11 = arguments.length, rest = new Array(_len11 > 2 ? _len11 - 2 : 0), _key11 = 2; _key11 < _len11; _key11++) {
      rest[_key11 - 2] = arguments[_key11];
    }

    var els = queryAllByTitle.apply(void 0, [container, title].concat(rest));

    if (!els.length) {
      throw getElementError("Unable to find an element with the title: " + title + ".", container);
    }

    return els;
  }

  function getByTitle() {
    for (var _len12 = arguments.length, args = new Array(_len12), _key12 = 0; _key12 < _len12; _key12++) {
      args[_key12] = arguments[_key12];
    }

    return firstResultOrNull.apply(void 0, [getAllByTitle].concat(args));
  }

  function getAllByValue(container, value) {
    for (var _len13 = arguments.length, rest = new Array(_len13 > 2 ? _len13 - 2 : 0), _key13 = 2; _key13 < _len13; _key13++) {
      rest[_key13 - 2] = arguments[_key13];
    }

    var els = queryAllByValue.apply(void 0, [container, value].concat(rest));

    if (!els.length) {
      throw getElementError("Unable to find an element with the value: " + value + ".", container);
    }

    return els;
  }

  function getByValue() {
    for (var _len14 = arguments.length, args = new Array(_len14), _key14 = 0; _key14 < _len14; _key14++) {
      args[_key14] = arguments[_key14];
    }

    return firstResultOrNull.apply(void 0, [getAllByValue].concat(args));
  }

  function getAllByPlaceholderText(container, text) {
    for (var _len15 = arguments.length, rest = new Array(_len15 > 2 ? _len15 - 2 : 0), _key15 = 2; _key15 < _len15; _key15++) {
      rest[_key15 - 2] = arguments[_key15];
    }

    var els = queryAllByPlaceholderText.apply(void 0, [container, text].concat(rest));

    if (!els.length) {
      throw getElementError("Unable to find an element with the placeholder text of: " + text, container);
    }

    return els;
  }

  function getByPlaceholderText() {
    for (var _len16 = arguments.length, args = new Array(_len16), _key16 = 0; _key16 < _len16; _key16++) {
      args[_key16] = arguments[_key16];
    }

    return firstResultOrNull.apply(void 0, [getAllByPlaceholderText].concat(args));
  }

  function getAllByLabelText(container, text) {
    for (var _len17 = arguments.length, rest = new Array(_len17 > 2 ? _len17 - 2 : 0), _key17 = 2; _key17 < _len17; _key17++) {
      rest[_key17 - 2] = arguments[_key17];
    }

    var els = queryAllByLabelText.apply(void 0, [container, text].concat(rest));

    if (!els.length) {
      var labels = queryAllLabelsByText.apply(void 0, [container, text].concat(rest));

      if (labels.length) {
        throw getElementError("Found a label with the text of: " + text + ", however no form control was found associated to that label. Make sure you're using the \"for\" attribute or \"aria-labelledby\" attribute correctly.", container);
      } else {
        throw getElementError("Unable to find a label with the text of: " + text, container);
      }
    }

    return els;
  }

  function getByLabelText() {
    for (var _len18 = arguments.length, args = new Array(_len18), _key18 = 0; _key18 < _len18; _key18++) {
      args[_key18] = arguments[_key18];
    }

    return firstResultOrNull.apply(void 0, [getAllByLabelText].concat(args));
  }

  function getAllByText(container, text) {
    for (var _len19 = arguments.length, rest = new Array(_len19 > 2 ? _len19 - 2 : 0), _key19 = 2; _key19 < _len19; _key19++) {
      rest[_key19 - 2] = arguments[_key19];
    }

    var els = queryAllByText.apply(void 0, [container, text].concat(rest));

    if (!els.length) {
      throw getElementError("Unable to find an element with the text: " + text + ". This could be because the text is broken up by multiple elements. In this case, you can provide a function for your text matcher to make your matcher more flexible.", container);
    }

    return els;
  }

  function getByText() {
    for (var _len20 = arguments.length, args = new Array(_len20), _key20 = 0; _key20 < _len20; _key20++) {
      args[_key20] = arguments[_key20];
    }

    return firstResultOrNull.apply(void 0, [getAllByText].concat(args));
  }

  function getAllByAltText(container, alt) {
    for (var _len21 = arguments.length, rest = new Array(_len21 > 2 ? _len21 - 2 : 0), _key21 = 2; _key21 < _len21; _key21++) {
      rest[_key21 - 2] = arguments[_key21];
    }

    var els = queryAllByAltText.apply(void 0, [container, alt].concat(rest));

    if (!els.length) {
      throw getElementError("Unable to find an element with the alt text: " + alt, container);
    }

    return els;
  }

  function getByAltText() {
    for (var _len22 = arguments.length, args = new Array(_len22), _key22 = 0; _key22 < _len22; _key22++) {
      args[_key22] = arguments[_key22];
    }

    return firstResultOrNull.apply(void 0, [getAllByAltText].concat(args));
  }

  function getAllByRole(container, id) {
    for (var _len23 = arguments.length, rest = new Array(_len23 > 2 ? _len23 - 2 : 0), _key23 = 2; _key23 < _len23; _key23++) {
      rest[_key23 - 2] = arguments[_key23];
    }

    var els = queryAllByRole.apply(void 0, [container, id].concat(rest));

    if (!els.length) {
      throw getElementError("Unable to find an element by role=" + id, container);
    }

    return els;
  }

  function getByRole() {
    for (var _len24 = arguments.length, args = new Array(_len24), _key24 = 0; _key24 < _len24; _key24++) {
      args[_key24] = arguments[_key24];
    }

    return firstResultOrNull.apply(void 0, [getAllByRole].concat(args));
  }

  function getAllBySelectText(container, text) {
    for (var _len25 = arguments.length, rest = new Array(_len25 > 2 ? _len25 - 2 : 0), _key25 = 2; _key25 < _len25; _key25++) {
      rest[_key25 - 2] = arguments[_key25];
    }

    var els = queryAllBySelectText.apply(void 0, [container, text].concat(rest));

    if (!els.length) {
      throw getElementError("Unable to find a <select> element with the selected option's text: " + text, container);
    }

    return els;
  }

  function getBySelectText() {
    for (var _len26 = arguments.length, args = new Array(_len26), _key26 = 0; _key26 < _len26; _key26++) {
      args[_key26] = arguments[_key26];
    }

    return firstResultOrNull.apply(void 0, [getAllBySelectText].concat(args));
  }

  function getAllByDisplayValue(container, value) {
    for (var _len27 = arguments.length, rest = new Array(_len27 > 2 ? _len27 - 2 : 0), _key27 = 2; _key27 < _len27; _key27++) {
      rest[_key27 - 2] = arguments[_key27];
    }

    var els = queryAllByDisplayValue.apply(void 0, [container, value].concat(rest));

    if (!els.length) {
      throw getElementError("Unable to find an element with the value: " + value + ".", container);
    }

    return els;
  }

  function getByDisplayValue() {
    for (var _len28 = arguments.length, args = new Array(_len28), _key28 = 0; _key28 < _len28; _key28++) {
      args[_key28] = arguments[_key28];
    }

    return firstResultOrNull.apply(void 0, [getAllByDisplayValue].concat(args));
  }

  function makeFinder(getter) {
    return function (container, text, options, waitForElementOptions) {
      return waitForElementWrapper(function () {
        return getter(container, text, options);
      }, waitForElementOptions);
    };
  }

  var findByLabelText = makeFinder(getByLabelText);
  var findAllByLabelText = makeFinder(getAllByLabelText);
  var findByPlaceholderText = makeFinder(getByPlaceholderText);
  var findAllByPlaceholderText = makeFinder(getAllByPlaceholderText);
  var findByText = makeFinder(getByText);
  var findAllByText = makeFinder(getAllByText);
  var findByAltText = makeFinder(getByAltText);
  var findAllByAltText = makeFinder(getAllByAltText);
  var findByTitle = makeFinder(getByTitle);
  var findAllByTitle = makeFinder(getAllByTitle);
  var findByDisplayValue = makeFinder(getByDisplayValue);
  var findAllByDisplayValue = makeFinder(getAllByDisplayValue);
  var findByRole = makeFinder(getByRole);
  var findAllByRole = makeFinder(getAllByRole);
  var findByTestId = makeFinder(getByTestId);
  var findAllByTestId = makeFinder(getAllByTestId);
  /* eslint complexity:["error", 14] */

  var defaultQueries =
  /*#__PURE__*/
  Object.freeze({
    findByLabelText: findByLabelText,
    findAllByLabelText: findAllByLabelText,
    findByPlaceholderText: findByPlaceholderText,
    findAllByPlaceholderText: findAllByPlaceholderText,
    findByText: findByText,
    findAllByText: findAllByText,
    findByAltText: findByAltText,
    findAllByAltText: findAllByAltText,
    findByTitle: findByTitle,
    findAllByTitle: findAllByTitle,
    findByDisplayValue: findByDisplayValue,
    findAllByDisplayValue: findAllByDisplayValue,
    findByRole: findByRole,
    findAllByRole: findAllByRole,
    findByTestId: findByTestId,
    findAllByTestId: findAllByTestId,
    queryByPlaceholderText: queryByPlaceholderText,
    queryAllByPlaceholderText: queryAllByPlaceholderText,
    getByPlaceholderText: getByPlaceholderText,
    getAllByPlaceholderText: getAllByPlaceholderText,
    queryByText: queryByText,
    queryAllByText: queryAllByText,
    getByText: getByText,
    getAllByText: getAllByText,
    queryByLabelText: queryByLabelText,
    queryAllByLabelText: queryAllByLabelText,
    getByLabelText: getByLabelText,
    getAllByLabelText: getAllByLabelText,
    queryByAltText: queryByAltText,
    queryAllByAltText: queryAllByAltText,
    getByAltText: getByAltText,
    getAllByAltText: getAllByAltText,
    queryBySelectText: queryBySelectText,
    queryAllBySelectText: queryAllBySelectText,
    getBySelectText: getBySelectText,
    getAllBySelectText: getAllBySelectText,
    queryByTestId: queryByTestId,
    queryAllByTestId: queryAllByTestId,
    getByTestId: getByTestId,
    getAllByTestId: getAllByTestId,
    queryByTitle: queryByTitle,
    queryAllByTitle: queryAllByTitle,
    getByTitle: getByTitle,
    getAllByTitle: getAllByTitle,
    queryByValue: queryByValue,
    queryAllByValue: queryAllByValue,
    getByValue: getByValue,
    getAllByValue: getAllByValue,
    queryByDisplayValue: queryByDisplayValue,
    queryAllByDisplayValue: queryAllByDisplayValue,
    getByDisplayValue: getByDisplayValue,
    getAllByDisplayValue: getAllByDisplayValue,
    queryByRole: queryByRole,
    queryAllByRole: queryAllByRole,
    getAllByRole: getAllByRole,
    getByRole: getByRole
  });
  /**
   * @typedef {{[key: string]: Function}} FuncMap
   */

  /**
   * @param {HTMLElement} element container
   * @param {FuncMap} queries object of functions
   * @returns {FuncMap} returns object of functions bound to container
   */

  function getQueriesForElement(element, queries) {
    if (queries === void 0) {
      queries = defaultQueries;
    }

    return Object.keys(queries).reduce(function (helpers, key) {
      var fn = queries[key];
      helpers[key] = fn.bind(null, element);
      return helpers;
    }, {});
  }

  function wait(callback, _temp) {
    if (callback === void 0) {
      callback = function () {};
    }

    var _ref = _temp === void 0 ? {} : _temp,
        _ref$timeout = _ref.timeout,
        timeout = _ref$timeout === void 0 ? 4500 : _ref$timeout,
        _ref$interval = _ref.interval,
        interval = _ref$interval === void 0 ? 50 : _ref$interval;

    return waitForExpect(callback, timeout, interval);
  }

  function waitWrapper() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return getConfig().asyncWrapper(function () {
      return wait.apply(void 0, args);
    });
  }

  function waitForElementToBeRemoved(callback, _temp) {
    var _ref = _temp === void 0 ? {} : _temp,
        _ref$container = _ref.container,
        container = _ref$container === void 0 ? getDocument() : _ref$container,
        _ref$timeout = _ref.timeout,
        timeout = _ref$timeout === void 0 ? 4500 : _ref$timeout,
        _ref$mutationObserver = _ref.mutationObserverOptions,
        mutationObserverOptions = _ref$mutationObserver === void 0 ? {
      subtree: true,
      childList: true,
      attributes: true,
      characterData: true
    } : _ref$mutationObserver;

    return new Promise(function (resolve, reject) {
      if (typeof callback !== 'function') {
        reject(new Error('waitForElementToBeRemoved requires a function as the first parameter'));
      }

      var timer = setTimeout(function () {
        onDone(new Error('Timed out in waitForElementToBeRemoved.'), null);
      }, timeout);
      var observer = newMutationObserver(function () {
        try {
          var _result = callback();

          if (!_result || Array.isArray(_result) && !_result.length) {
            onDone(null, true);
          } // If `callback` returns truthy value, wait for the next mutation or timeout.

        } catch (error) {
          onDone(null, true);
        }
      }); // Check if the element is not present synchronously,
      // As the name waitForElementToBeRemoved should check `present` --> `removed`

      try {
        var result = callback();

        if (!result || Array.isArray(result) && !result.length) {
          onDone(new Error('The callback function which was passed did not return an element or non-empty array of elements. waitForElementToBeRemoved requires that the element(s) exist before waiting for removal.'));
        } else {
          // Only observe for mutations only if there is element while checking synchronously
          observer.observe(container, mutationObserverOptions);
        }
      } catch (error) {
        onDone(error);
      }

      function onDone(error, result) {
        var setImmediate = getSetImmediate();
        clearTimeout(timer);
        setImmediate(function () {
          return observer.disconnect();
        });

        if (error) {
          reject(error);
        } else {
          resolve(result);
        }
      }
    });
  }

  function waitForElementToBeRemovedWrapper() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return getConfig().asyncWrapper(function () {
      return waitForElementToBeRemoved.apply(void 0, args);
    });
  }

  function waitForDomChange(_temp) {
    var _ref = _temp === void 0 ? {} : _temp,
        _ref$container = _ref.container,
        container = _ref$container === void 0 ? getDocument() : _ref$container,
        _ref$timeout = _ref.timeout,
        timeout = _ref$timeout === void 0 ? 4500 : _ref$timeout,
        _ref$mutationObserver = _ref.mutationObserverOptions,
        mutationObserverOptions = _ref$mutationObserver === void 0 ? {
      subtree: true,
      childList: true,
      attributes: true,
      characterData: true
    } : _ref$mutationObserver;

    return new Promise(function (resolve, reject) {
      var setImmediate = getSetImmediate();
      var timer = setTimeout(function () {
        onDone(new Error('Timed out in waitForDomChange.'), null);
      }, timeout);
      var observer = newMutationObserver(function (mutationsList) {
        onDone(null, mutationsList);
      });
      observer.observe(container, mutationObserverOptions);

      function onDone(error, result) {
        clearTimeout(timer);
        setImmediate(function () {
          return observer.disconnect();
        });

        if (error) {
          reject(error);
        } else {
          resolve(result);
        }
      }
    });
  }

  function waitForDomChangeWrapper() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return getConfig().asyncWrapper(function () {
      return waitForDomChange.apply(void 0, args);
    });
  }

  var eventMap = {
    // Clipboard Events
    copy: {
      EventType: 'ClipboardEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    cut: {
      EventType: 'ClipboardEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    paste: {
      EventType: 'ClipboardEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    // Composition Events
    compositionEnd: {
      EventType: 'CompositionEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    compositionStart: {
      EventType: 'CompositionEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    compositionUpdate: {
      EventType: 'CompositionEvent',
      defaultInit: {
        bubbles: true,
        cancelable: false
      }
    },
    // Keyboard Events
    keyDown: {
      EventType: 'KeyboardEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true,
        charCode: 0
      }
    },
    keyPress: {
      EventType: 'KeyboardEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true,
        charCode: 0
      }
    },
    keyUp: {
      EventType: 'KeyboardEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true,
        charCode: 0
      }
    },
    // Focus Events
    focus: {
      EventType: 'FocusEvent',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    blur: {
      EventType: 'FocusEvent',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    focusIn: {
      EventType: 'FocusEvent',
      defaultInit: {
        bubbles: true,
        cancelable: false
      }
    },
    focusOut: {
      EventType: 'FocusEvent',
      defaultInit: {
        bubbles: true,
        cancelable: false
      }
    },
    // Form Events
    change: {
      EventType: 'InputEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    input: {
      EventType: 'InputEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    invalid: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: true
      }
    },
    submit: {
      EventType: 'Event',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    // Mouse Events
    click: {
      EventType: 'MouseEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true,
        button: 0
      }
    },
    contextMenu: {
      EventType: 'MouseEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    dblClick: {
      EventType: 'MouseEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    drag: {
      EventType: 'DragEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    dragEnd: {
      EventType: 'DragEvent',
      defaultInit: {
        bubbles: true,
        cancelable: false
      }
    },
    dragEnter: {
      EventType: 'DragEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    dragExit: {
      EventType: 'DragEvent',
      defaultInit: {
        bubbles: true,
        cancelable: false
      }
    },
    dragLeave: {
      EventType: 'DragEvent',
      defaultInit: {
        bubbles: true,
        cancelable: false
      }
    },
    dragOver: {
      EventType: 'DragEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    dragStart: {
      EventType: 'DragEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    drop: {
      EventType: 'DragEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    mouseDown: {
      EventType: 'MouseEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    mouseEnter: {
      EventType: 'MouseEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    mouseLeave: {
      EventType: 'MouseEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    mouseMove: {
      EventType: 'MouseEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    mouseOut: {
      EventType: 'MouseEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    mouseOver: {
      EventType: 'MouseEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    mouseUp: {
      EventType: 'MouseEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    // Selection Events
    select: {
      EventType: 'Event',
      defaultInit: {
        bubbles: true,
        cancelable: false
      }
    },
    // Touch Events
    touchCancel: {
      EventType: 'TouchEvent',
      defaultInit: {
        bubbles: true,
        cancelable: false
      }
    },
    touchEnd: {
      EventType: 'TouchEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    touchMove: {
      EventType: 'TouchEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    touchStart: {
      EventType: 'TouchEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    // UI Events
    scroll: {
      EventType: 'UIEvent',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    // Wheel Events
    wheel: {
      EventType: 'WheelEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    },
    // Media Events
    abort: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    canPlay: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    canPlayThrough: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    durationChange: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    emptied: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    encrypted: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    ended: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    // error: {
    //   EventType: Event,
    //   defaultInit: {bubbles: false, cancelable: false},
    // },
    loadedData: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    loadedMetadata: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    loadStart: {
      EventType: 'ProgressEvent',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    pause: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    play: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    playing: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    progress: {
      EventType: 'ProgressEvent',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    rateChange: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    seeked: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    seeking: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    stalled: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    suspend: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    timeUpdate: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    volumeChange: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    waiting: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    // Image Events
    load: {
      EventType: 'UIEvent',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    error: {
      EventType: 'Event',
      defaultInit: {
        bubbles: false,
        cancelable: false
      }
    },
    // Animation Events
    animationStart: {
      EventType: 'AnimationEvent',
      defaultInit: {
        bubbles: true,
        cancelable: false
      }
    },
    animationEnd: {
      EventType: 'AnimationEvent',
      defaultInit: {
        bubbles: true,
        cancelable: false
      }
    },
    animationIteration: {
      EventType: 'AnimationEvent',
      defaultInit: {
        bubbles: true,
        cancelable: false
      }
    },
    // Transition Events
    transitionEnd: {
      EventType: 'TransitionEvent',
      defaultInit: {
        bubbles: true,
        cancelable: true
      }
    }
  };
  var eventAliasMap = {
    doubleClick: 'dblClick'
  };

  function fireEvent(element, event) {
    return element.dispatchEvent(event);
  }

  Object.keys(eventMap).forEach(function (key) {
    var _eventMap$key = eventMap[key],
        EventType = _eventMap$key.EventType,
        defaultInit = _eventMap$key.defaultInit;
    var eventName = key.toLowerCase();

    fireEvent[key] = function (node, init) {
      var eventInit = _extends({}, defaultInit, init);

      var _eventInit$target = eventInit.target;
      _eventInit$target = _eventInit$target === void 0 ? {} : _eventInit$target;

      var value = _eventInit$target.value,
          files = _eventInit$target.files,
          targetProperties = _objectWithoutPropertiesLoose(_eventInit$target, ["value", "files"]);

      Object.assign(node, targetProperties);

      if (value !== undefined) {
        setNativeValue(node, value);
      }

      if (files !== undefined) {
        // input.files is a read-only property so this is not allowed:
        // input.files = [file]
        // so we have to use this workaround to set the property
        Object.defineProperty(node, 'files', {
          configurable: true,
          enumerable: true,
          writable: true,
          value: files
        });
      } // if the node does not have an owner document, then it probably _is_ the owner document


      var window = (node.ownerDocument || node).defaultView;
      var EventConstructor = window[EventType] || window.Event;
      var event = new EventConstructor(eventName, eventInit);
      return fireEvent(node, event);
    };
  }); // function written after some investigation here:
  // https://github.com/facebook/react/issues/10135#issuecomment-401496776

  function setNativeValue(element, value) {
    var _ref = Object.getOwnPropertyDescriptor(element, 'value') || {},
        valueSetter = _ref.set;

    var prototype = Object.getPrototypeOf(element);

    var _ref2 = Object.getOwnPropertyDescriptor(prototype, 'value') || {},
        prototypeValueSetter = _ref2.set;

    if (prototypeValueSetter && valueSetter !== prototypeValueSetter) {
      prototypeValueSetter.call(element, value);
    }
    /* istanbul ignore next (I don't want to bother) */
    else if (valueSetter) {
        valueSetter.call(element, value);
      } else {
        throw new Error('The given element does not have a value setter');
      }
  }

  Object.keys(eventAliasMap).forEach(function (aliasKey) {
    var key = eventAliasMap[aliasKey];

    fireEvent[aliasKey] = function () {
      return fireEvent[key].apply(fireEvent, arguments);
    };
  });

  // we don't want to warn until react-dom@16.9.0 is actually released
  var reactDomSixteenPointNineIsReleased = false;

  var reactAct;
  var actSupported = false;
  var asyncActSupported = false;

  try {
    reactAct = require('react-dom/test-utils').act;
    actSupported = reactAct !== undefined;
    var originalError = console.error;
    var errorCalled = false;

    console.error = function () {
      errorCalled = true;
    };

    console.error.calls = [];
    /* istanbul ignore next */

    reactAct(function () {
      return {
        then: function then() {}
      };
    }).then(function () {});
    /* istanbul ignore next */

    if (!errorCalled) {
      asyncActSupported = true;
    }

    console.error = originalError;
  } catch (error) {} // ignore, this is to support old versions of react
  // act is supported react-dom@16.8.0
  // so for versions that don't have act from test utils
  // we do this little polyfill. No warnings, but it's
  // better than nothing.


  function actPolyfill(cb) {
    ReactDOM.unstable_batchedUpdates(cb);
    ReactDOM.render(React.createElement("div", null), document.createElement('div'));
  }

  var act = reactAct || actPolyfill;
  var youHaveBeenWarned = false; // this will not avoid warnings that react-dom 16.8.0 logs for triggering
  // state updates asynchronously, but at least we can tell people they need
  // to upgrade to avoid the warnings.

  function asyncActPolyfill() {
    return _asyncActPolyfill.apply(this, arguments);
  } // istanbul ignore next


  function _asyncActPolyfill() {
    _asyncActPolyfill = _asyncToGenerator(
    /*#__PURE__*/
    regenerator.mark(function _callee(cb) {
      return regenerator.wrap(function (_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              // istanbul-ignore-next
              if (!youHaveBeenWarned && actSupported && reactDomSixteenPointNineIsReleased) {
                // if act is supported and async act isn't and they're trying to use async
                // act, then they need to upgrade from 16.8 to 16.9.
                // This is a seemless upgrade, so we'll add a warning
                console.error("It looks like you're using a version of react-dom that supports the \"act\" function, but not an awaitable version of \"act\" which you will need. Please upgrade to at least react-dom@16.9.0 to remove this warning.");
                youHaveBeenWarned = true;
              }

              _context.next = 3;
              return cb();

            case 3:
              // make all effects resolve after
              act(function () {});

            case 4:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));
    return _asyncActPolyfill.apply(this, arguments);
  }

  var asyncAct = asyncActSupported ? reactAct : asyncActPolyfill;
  /* eslint no-console:0 */

  configure({
    asyncWrapper: function () {
      var _asyncWrapper = _asyncToGenerator(
      /*#__PURE__*/
      regenerator.mark(function _callee2(cb) {
        var result;
        return regenerator.wrap(function (_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return asyncAct(
                /*#__PURE__*/
                _asyncToGenerator(
                /*#__PURE__*/
                regenerator.mark(function _callee() {
                  return regenerator.wrap(function (_context) {
                    while (1) {
                      switch (_context.prev = _context.next) {
                        case 0:
                          _context.next = 2;
                          return cb();

                        case 2:
                          result = _context.sent;

                        case 3:
                        case "end":
                          return _context.stop();
                      }
                    }
                  }, _callee);
                })));

              case 2:
                return _context2.abrupt("return", result);

              case 3:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      return function asyncWrapper() {
        return _asyncWrapper.apply(this, arguments);
      };
    }()
  });
  var mountedContainers = new Set();

  function render(ui, _temp) {
    var _ref2 = _temp === void 0 ? {} : _temp,
        container = _ref2.container,
        _ref2$baseElement = _ref2.baseElement,
        baseElement = _ref2$baseElement === void 0 ? container : _ref2$baseElement,
        queries = _ref2.queries,
        _ref2$hydrate = _ref2.hydrate,
        hydrate = _ref2$hydrate === void 0 ? false : _ref2$hydrate,
        WrapperComponent = _ref2.wrapper;

    if (!container) {
      // default to document.body instead of documentElement to avoid output of potentially-large
      // head elements (such as JSS style blocks) in debug output
      baseElement = document.body;
      container = document.body.appendChild(document.createElement('div'));
    } // we'll add it to the mounted containers regardless of whether it's actually
    // added to document.body so the cleanup method works regardless of whether
    // they're passing us a custom container or not.


    mountedContainers.add(container);

    var wrapUiIfNeeded = function (innerElement) {
      return WrapperComponent ? React.createElement(WrapperComponent, null, innerElement) : innerElement;
    };

    act(function () {
      if (hydrate) {
        ReactDOM.hydrate(wrapUiIfNeeded(ui), container);
      } else {
        ReactDOM.render(wrapUiIfNeeded(ui), container);
      }
    });
    return _extends({
      container: container,
      baseElement: baseElement,
      // eslint-disable-next-line no-console
      debug: function debug(el) {
        if (el === void 0) {
          el = baseElement;
        }

        return console.log(prettyDOM(el));
      },
      unmount: function unmount() {
        return ReactDOM.unmountComponentAtNode(container);
      },
      rerender: function rerender(rerenderUi) {
        render(wrapUiIfNeeded(rerenderUi), {
          container: container,
          baseElement: baseElement
        }); // Intentionally do not return anything to avoid unnecessarily complicating the API.
        // folks can use all the same utilities we return in the first place that are bound to the container
      },
      asFragment: function asFragment() {
        /* istanbul ignore if (jsdom limitation) */
        if (typeof document.createRange === 'function') {
          return document.createRange().createContextualFragment(container.innerHTML);
        }

        var template = document.createElement('template');
        template.innerHTML = container.innerHTML;
        return template.content;
      }
    }, getQueriesForElement(baseElement, queries));
  }

  function cleanup() {
    mountedContainers.forEach(cleanupAtContainer);
  } // maybe one day we'll expose this (perhaps even as a utility returned by render).
  // but let's wait until someone asks for it.


  function cleanupAtContainer(container) {
    ReactDOM.unmountComponentAtNode(container);

    if (container.parentNode === document.body) {
      document.body.removeChild(container);
    }

    mountedContainers.delete(container);
  } // react-testing-library's version of fireEvent will call
  // dom-testing-library's version of fireEvent wrapped inside
  // an "act" call so that after all event callbacks have been
  // been called, the resulting useEffect callbacks will also
  // be called.


  function fireEvent$1() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var returnValue;
    act(function () {
      returnValue = fireEvent.apply(void 0, args);
    });
    return returnValue;
  }

  Object.keys(fireEvent).forEach(function (key) {
    fireEvent$1[key] = function () {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      var returnValue;
      act(function () {
        returnValue = fireEvent[key].apply(fireEvent, args);
      });
      return returnValue;
    };
  }); // React event system tracks native mouseOver/mouseOut events for
  // running onMouseEnter/onMouseLeave handlers
  // @link https://github.com/facebook/react/blob/b87aabdfe1b7461e7331abb3601d9e6bb27544bc/packages/react-dom/src/events/EnterLeaveEventPlugin.js#L24-L31

  fireEvent$1.mouseEnter = fireEvent$1.mouseOver;
  fireEvent$1.mouseLeave = fireEvent$1.mouseOut;

  fireEvent$1.select = function (node, init) {
    // React tracks this event only on focused inputs
    node.focus(); // React creates this event when one of the following native events happens
    // - contextMenu
    // - mouseUp
    // - dragEnd
    // - keyUp
    // - keyDown
    // so we can use any here
    // @link https://github.com/facebook/react/blob/b87aabdfe1b7461e7331abb3601d9e6bb27544bc/packages/react-dom/src/events/SelectEventPlugin.js#L203-L224

    fireEvent$1.keyUp(node, init);
  }; // just re-export everything from dom-testing-library
  // thing for people using react-dom@16.8.0. Anyone else doesn't need it and
  // people should just upgrade anyway.

  /* eslint func-name-matching:0 */

  exports.act = act;
  exports.bindElementToQueries = getQueriesForElement;
  exports.cleanup = cleanup;
  exports.configure = configure;
  exports.debugDOM = debugDOM;
  exports.findAllByAltText = findAllByAltText;
  exports.findAllByDisplayValue = findAllByDisplayValue;
  exports.findAllByLabelText = findAllByLabelText;
  exports.findAllByPlaceholderText = findAllByPlaceholderText;
  exports.findAllByRole = findAllByRole;
  exports.findAllByTestId = findAllByTestId;
  exports.findAllByText = findAllByText;
  exports.findAllByTitle = findAllByTitle;
  exports.findByAltText = findByAltText;
  exports.findByDisplayValue = findByDisplayValue;
  exports.findByLabelText = findByLabelText;
  exports.findByPlaceholderText = findByPlaceholderText;
  exports.findByRole = findByRole;
  exports.findByTestId = findByTestId;
  exports.findByText = findByText;
  exports.findByTitle = findByTitle;
  exports.fireEvent = fireEvent$1;
  exports.firstResultOrNull = firstResultOrNull;
  exports.getAllByAltText = getAllByAltText;
  exports.getAllByDisplayValue = getAllByDisplayValue;
  exports.getAllByLabelText = getAllByLabelText;
  exports.getAllByPlaceholderText = getAllByPlaceholderText;
  exports.getAllByRole = getAllByRole;
  exports.getAllBySelectText = getAllBySelectText;
  exports.getAllByTestId = getAllByTestId;
  exports.getAllByText = getAllByText;
  exports.getAllByTitle = getAllByTitle;
  exports.getAllByValue = getAllByValue;
  exports.getByAltText = getByAltText;
  exports.getByDisplayValue = getByDisplayValue;
  exports.getByLabelText = getByLabelText;
  exports.getByPlaceholderText = getByPlaceholderText;
  exports.getByRole = getByRole;
  exports.getBySelectText = getBySelectText;
  exports.getByTestId = getByTestId;
  exports.getByText = getByText;
  exports.getByTitle = getByTitle;
  exports.getByValue = getByValue;
  exports.getDefaultNormalizer = getDefaultNormalizer;
  exports.getElementError = getElementError;
  exports.getNodeText = getNodeText;
  exports.getQueriesForElement = getQueriesForElement;
  exports.prettyDOM = prettyDOM;
  exports.queries = defaultQueries;
  exports.queryAllByAltText = queryAllByAltText;
  exports.queryAllByAttribute = queryAllByAttribute;
  exports.queryAllByDisplayValue = queryAllByDisplayValue;
  exports.queryAllByLabelText = queryAllByLabelText;
  exports.queryAllByPlaceholderText = queryAllByPlaceholderText;
  exports.queryAllByRole = queryAllByRole;
  exports.queryAllBySelectText = queryAllBySelectText;
  exports.queryAllByTestId = queryAllByTestId;
  exports.queryAllByText = queryAllByText;
  exports.queryAllByTitle = queryAllByTitle;
  exports.queryAllByValue = queryAllByValue;
  exports.queryByAltText = queryByAltText;
  exports.queryByAttribute = queryByAttribute;
  exports.queryByDisplayValue = queryByDisplayValue;
  exports.queryByLabelText = queryByLabelText;
  exports.queryByPlaceholderText = queryByPlaceholderText;
  exports.queryByRole = queryByRole;
  exports.queryBySelectText = queryBySelectText;
  exports.queryByTestId = queryByTestId;
  exports.queryByText = queryByText;
  exports.queryByTitle = queryByTitle;
  exports.queryByValue = queryByValue;
  exports.queryHelpers = queryHelpers;
  exports.render = render;
  exports.wait = waitWrapper;
  exports.waitForDomChange = waitForDomChangeWrapper;
  exports.waitForElement = waitForElementWrapper;
  exports.waitForElementToBeRemoved = waitForElementToBeRemovedWrapper;
  exports.within = getQueriesForElement;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=react-testing-library.umd.js.map
