const babylon = require('@babel/parser')

module.exports = (type, plugins) => input =>
  babylon.parse(input, {
    sourceType: 'module',
    plugins: [type].concat(
      plugins || [
        'jsx',
        'objectRestSpread',
        ['decorators', { decoratorsBeforeExport: true }],
        'classProperties',
        'exportExtensions',
        'asyncGenerators',
        'functionBind',
        'functionSent',
        'dynamicImport',
        'optionalCatchBinding',
        'optionalChaining'
      ]
    )
  })
