"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

// Augment Window interface with the Date declaratoin,
// because typescript does not expose it for now.
// Check https://github.com/Microsoft/TypeScript/issues/19816 for more info
// Used to avoid using Jest's fake timers and Date.now mocks
// See https://github.com/TheBrainFamily/wait-for-expect/issues/4 and
// https://github.com/TheBrainFamily/wait-for-expect/issues/12 for more info
var _ref = typeof window !== "undefined" ? window : global,
    setTimeout = _ref.setTimeout,
    now = _ref.Date.now;
/**
 * Waits for the expectation to pass and returns a Promise
 *
 * @param  expectation  Function  Expectation that has to complete without throwing
 * @param  timeout  Number  Maximum wait interval, 4500ms by default
 * @param  interval  Number  Wait-between-retries interval, 50ms by default
 * @return  Promise  Promise to return a callback result
 */


var waitForExpect = function waitForExpect(expectation) {
  var timeout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 4500;
  var interval = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 50;
  var startTime = now();
  return new Promise(function (resolve, reject) {
    var rejectOrRerun = function rejectOrRerun(error) {
      if (now() - startTime >= timeout) {
        reject(error);
        return;
      } // eslint-disable-next-line no-use-before-define


      setTimeout(runExpectation, interval);
    };

    function runExpectation() {
      try {
        Promise.resolve(expectation()).then(function () {
          return resolve();
        }).catch(rejectOrRerun);
      } catch (error) {
        rejectOrRerun(error);
      }
    }

    setTimeout(runExpectation, 0);
  });
};

var _default = waitForExpect;
exports.default = _default;
module.exports = exports.default;
module.exports.default = exports.default;