// @author Norton - 05/2019

// Add an event listener to each DIV within each choice-grid
var choiceGrids = document.querySelectorAll(".choice-grid");

var totalPossibleAnswers = 0;
var answers = {};

clickHandler = function(e) {
            
    e.currentTarget.classList.remove('semiTransparent');

    let checkImage = e.currentTarget.getElementsByClassName('checkbox')[0];
    checkImage.attributes['src'].value = 'images/checked.png';
    
    let choiceId = e.currentTarget.dataset.choiceId;
    let questionId = e.currentTarget.dataset.questionId;

    answers[questionId] = choiceId;
    uncheckOtherChoices(questionId, choiceId);
    checkAnswers();

    e.stopPropagation();
}

choiceGrids.forEach(grid => { 

    totalPossibleAnswers++;
    grid.querySelectorAll('div').forEach(div => {
        div.addEventListener('click', clickHandler, true);
    });
});

uncheckOtherChoices = (questionId, choiceId) => {

    var choices = document.querySelectorAll(`div[data-question-id='${questionId}']`);

    choices.forEach(choice => {
        if (choice.dataset.choiceId != choiceId) {
            choice.classList.add('semiTransparent');
            let checkImage = choice.getElementsByClassName('checkbox')[0];
            checkImage.attributes['src'].value = 'images/unchecked.png';
        }
    });

}

checkAnswers = () => {

    if (Object.keys(answers).length === totalPossibleAnswers) {

        let divs = document.querySelectorAll(".choice-grid div");
        divs.forEach(div => {
                div.removeEventListener('click', clickHandler, true);
        });
        completeQuiz();
    }
}

completeQuiz = () => {

    document.querySelector('#results').style.display = 'flex';

    let answerTally = {};
    for (let answer in answers) {

        let currentAnswer = answers[answer];
        if (answerTally[currentAnswer]) {
            answerTally[currentAnswer]++;
        } else answerTally[currentAnswer] = 1;

    }
    
    // Default to the first answer
    let winner = answers["one"];

    // Is there a clear winner?
    for (let answer in answerTally) {
        if (answerTally[answer] > answerTally[winner]) winner = answer;
    }
    
    // Lookup from constants
    let winnerDetails = RESULTS_MAP[winner];

    document.querySelector("#resultHeader").innerText = winnerDetails.title;
    document.querySelector("#resultExplanation").innerText = winnerDetails.contents;
    
    document.querySelector("#restart").addEventListener('click', restartHandler);
}

restartHandler = function() {

    // document.querySelector('#results').style.display = 'none';
    // answers = {};

    // let divs = document.querySelectorAll(".choice-grid div");
    // divs.forEach(div => {
    //         div.addEventListener('click', clickHandler, true);

    //         let checkImage = div.getElementsByClassName('checkbox')[0];
    //         checkImage.attributes['src'].value = 'images/unchecked.png';

    //         div.classList.remove('semiTransparent');
    // });

    location.reload();
    window.scrollTo(0,0);

}