/* Norton's rendition of the MVC User Mgmt Page (May 2019) */

import { UserManagementController } from './app/controller.js';

class App {

    constructor() {
        this.controller = new UserManagementController();
    }
}

App.prototype.load = function () {

    window.addEventListener('error', (e) => {
        // catches runtime errors, e.g. throw new Error(....);
        this.controller.displayMessage(e.error);
    });

    document.addEventListener('DOMContentLoaded', () => {
        this.controller.load();
    });
}

export { App }; 