/* Norton's rendition of the MVC User Mgmt Page (May 2019) */
import { UserStore } from "./userStore.js";
import { UserDetailsView } from "./views/UserDetailsView.js";
import { UserMasterView } from "./views/UserMasterView.js";
import { Messages } from "./views/Messages.js"

class UserManagementController {

    constructor() {
        this.newUserInProcess = false;
        this.userStore = new UserStore();
        this.userDetailsView = new UserDetailsView(this);
        this.userMasterView = new UserMasterView(this);
        this.messages = new Messages(this);
    }

}

UserManagementController.prototype.displayMessage = function(message) {
    this.messages.updateMessage(message);
}

UserManagementController.prototype.load = function() {

    this.userMasterView.resetUserRows(this.userStore.getAll());
    this.userDetailsView.clearSlate();
    this.userDetailsView.hideInputForm();
}

UserManagementController.prototype.new = function() {

    // throw new Error("Some error occurred.");
    let newId = this.userStore.uniqueId();
    this.userDetailsView.setCurrentUserId(newId);
    this.userDetailsView.clearSlate();
    this.userDetailsView.showInputForm();
    this.newUserInProcess = true;

}

UserManagementController.prototype.save = function(e) {

    e.preventDefault();

    // Check validity on the form
    if (this.userDetailsView.validateForm()) {

        let newUser = {};
        newUser.id = this.userDetailsView.getCurrentUserId();
    
        if (confirm (`Are you sure you want to save changes for user ${newUser.id}?`)) {
    
            newUser = this.userDetailsView.getFormInputValues();

            // newUser.dateCreated = this.userDetailsView.getFormInputValue("dateCreated");
            // newUser.name = this.userDetailsView.getFormInputValue("name");
            // newUser.email = this.userDetailsView.getFormInputValue("email");
            // newUser.gender = this.userDetailsView.getFormInputValue("gender");
            // newUser.age = this.userDetailsView.getFormInputValue("age");
            // newUser.role = this.userDetailsView.getFormInputValue("role");
            // newUser.verified = this.userDetailsView.getFormInputValue("verified");
            
            if (this.newUserInProcess) {
                this.userStore.add(newUser);
            } else {
                this.userStore.update(newUser);
            }
            
            this.newUserInProcess = false;
            this.load();
    
            this.userDetailsView.hideInputForm();
        }
    }
}

UserManagementController.prototype.cancel = function() {
    
    // cancel the edit and reload the same user or clear the 
    // Users Details view if the user was new

    if (this.newUserInProcess) {
        this.userDetailsView.clearSlate();
        this.userDetailsView.hideInputForm();
    } else {
        this.edit(null, this.userDetailsView.getCurrentUserId());
    }

}

UserManagementController.prototype.edit = function(e, id) {

    this.newUserInProcess = false;
    
    let userId;
    if (e) { userId = e.currentTarget.id.slice(1); } else userId = id;

    let currentUser = this.userStore.get(userId);

    this.userDetailsView.populateUserDetails(currentUser);
    this.userDetailsView.showInputForm();
}

UserManagementController.prototype.delete = function(e, id) {
    
    let userId;
    if (e) { userId = e.currentTarget.id.slice(1); } else userId = id;
    let userName = this.userStore.get(userId).name;

    if (confirm("Are you sure you want to delete " + userName + "?")) {
        this.userStore.remove(userId);    
        this.load();
    }
}

export { UserManagementController };