/* Norton's rendition of the MVC User Mgmt Page (May 2019) */

class UserStore {

    constructor() {

        this.userStore = [];

        if (localStorage.getItem('userStore')) {
            this.userStore = JSON.parse(localStorage.getItem('userStore'));
        } else {
            localStorage.setItem('userStore', JSON.stringify(this.userStore));
        }
    }
}

UserStore.prototype.userStore = [];

UserStore.prototype.uniqueId = function() {
    let id = 0;
    for (let user of this.userStore) 
        if (user.id >= id) 
            id = Number(user.id) + 1;
    return id;
}

UserStore.prototype.add = function(object) {
    object.dateCreated = new Date().toISOString();
    this.userStore.push(object);
    this.syncStorage();
}

UserStore.prototype.get = function(id) {
    return this.userStore.find(e => e.id == id);
}

UserStore.prototype.getAll = function() {
    return this.userStore;
}

UserStore.prototype.update = function(object) {
    object.dateUpdated = new Date().toISOString();
    this.remove(object.id);
    this.userStore.push(object);
    this.syncStorage();
}

UserStore.prototype.remove = function(id) {
    this.userStore = this.userStore.filter(u => u.id != id );
    this.syncStorage();
}

UserStore.prototype.syncStorage = function() {
    localStorage.setItem('userStore', JSON.stringify(this.userStore));
}

export { UserStore };