/* Norton's rendition of the MVC User Mgmt Page (May 2019) */

/* Simple 10ms delay, useful for initial loop when 
awaiting an asynchronous load of some resource.
Call from within an async function, i.e., 
var result = await delay(); */
function delay() {
  return new Promise(resolve => {
    setTimeout(() => {
      resolve("resolved");
    }, 10);
  });
}

/* Register Handlebars helpers for views */
function registerHandlebarsHelpers() {
  Handlebars.registerHelper("maleCheck", function(data) {
    let str = "";
    if (data === "male") str = "checked";
    return new Handlebars.SafeString(str);
  });

  Handlebars.registerHelper("femaleCheck", function(data) {
    let str = "";
    if (data === "female") str = "checked";
    return new Handlebars.SafeString(str);
  });

  Handlebars.registerHelper("roleCompare", function(role, compareRole) {
    let str = "";
    if (role === compareRole) str = "selected";
    return new Handlebars.SafeString(str);
  });

  Handlebars.registerHelper("verifiedHelper", function(verified) {
    let str = "";
    if (verified) str = "checked";
    return new Handlebars.SafeString(str);
  });

  Handlebars.registerHelper("iconize", function(data) {
    let str;

    switch (data) {
      case "male":
        str = "<i class='fas fa-male'></i>";
        break;
      case "female":
        str = "<i class='fas fa-female'></i>";
        break;
      default:
        str = "?";
    }
    return new Handlebars.SafeString(str);
  });
}

registerHandlebarsHelpers();
