
import { formatDateHelper } from "./lib/core-vendor/handlebars/helpers/format-date-helper.js"
import { checkCheckboxHelper } from "./lib/core-vendor/handlebars/helpers/check-checkbox-helper.js"
import { checkRadioHelper } from "./lib/core-vendor/handlebars/helpers/check-radio-helper.js"
import { selectOptionHelper } from "./lib/core-vendor/handlebars/helpers/select-option-helper.js"
import { messageBoxController } from "./app/message-box.controller.js"
import { usersController } from "./app/users/users.controller.js";

document.addEventListener("DOMContentLoaded", function(event) {

	Handlebars.registerHelper(formatDateHelper.name, formatDateHelper.helper);
	Handlebars.registerHelper(checkCheckboxHelper.name, checkCheckboxHelper.helper);
	Handlebars.registerHelper(checkRadioHelper.name, checkRadioHelper.helper);
	Handlebars.registerHelper(selectOptionHelper.name, selectOptionHelper.helper);

	messageBoxController.initialize(function() {

		usersController.initialize(function() {

			usersController.load();
		});
	});
});

window.addEventListener("error", function(event) {

	var error = event.error;
	var message = error.message;

	if (error.stack) {

		message = message + "<hr><div class='text-left'>" + error.stack + "</div>";

	}

	messageBoxController.message(message, true);
});
