
import { HandlebarsView } from "../lib/core-vendor/handlebars/handlebars-view.js";
import { dom } from "../lib/core/web/dom.js";

var messageBoxView = new HandlebarsView("app/message-box.template.hbs", "messageBoxPlaceholder");

messageBoxView.render = function(messageData) {

	if (messageData && messageData.message) {

		this.renderToInnerHtml(messageData);

		dom("#messageBoxCloseLink", this.placeholderElement).addEventListener("click", onClose);

	} else {

		this.placeholderElement.innerHTML = "";
	}
};

function onClose(event) {

	event.preventDefault();

	messageBoxView.placeholderElement.innerHTML = "";
}


export { messageBoxView }