
import { HandlebarsView } from "../../lib/core-vendor/handlebars/handlebars-view.js";
import { usersController } from "./users.controller.js";
import { dom } from "../../lib/core/web/dom.js";

var usersDetailsView = new HandlebarsView("app/users/users-details.template.hbs", "usersDetailsPlaceholder");

usersDetailsView.render = function(user) {

	this.renderToInnerHtml(user);

	dom("#newButton", this.placeholderElement).addEventListener("click", onNew);
	dom("#usersDetails", this.placeholderElement).addEventListener("submit", onSubmit);
	dom("#cancelEditButton", this.placeholderElement).addEventListener("click", onCancelEdit);
};

function inBind() {

	var form = dom("#usersDetails");
	var data = dom.getFormData(form);

	var user = {};

	if (data.userId) {

		user.userId = Number.parseInt(data.userId);
	}

	user.name = data.name;
	user.email = data.email;
	user.gender = data.gender;
	user.age = Number.parseInt(data.age);
	user.role = data.role;
	user.verified = data.verified;

	return user;
}

function onNew() {

	usersController.newUser();
}

function onSubmit(event) {

	event.preventDefault();

	var user = inBind();

	usersController.saveUser(user);
}

function onCancelEdit() {

	var user = inBind();

	usersController.cancelEditUser(user.userId);
}


export { usersDetailsView }