
import { HandlebarsView } from "../../lib/core-vendor/handlebars/handlebars-view.js";
import { usersController } from "./users.controller.js";
import { dom } from "../../lib/core/web/dom.js";

var usersMasterView = new HandlebarsView("app/users/users-master.template.hbs", "usersMasterPlaceholder");

usersMasterView.render = function(users) {

	this.renderToInnerHtml(users);

	dom("#usersMaster", this.placeholderElement).addEventListener("click", onClick);
};

function onClick(event) {

	var link = event.target.parentElement;
	var action = link.dataset.action;
	var userId = link.dataset.userId;

	switch (action) {

		case "edit":
			usersController.editUser(userId);
			break;

		case "delete":
			usersController.deleteUser(userId);
			break;
	}

	event.preventDefault();
}


export { usersMasterView }