
import { templateEngine } from "./template-engine.js";

function HandlebarsView(templateUrl, placeholderElementId) {

	this.templateUrl = templateUrl;
	this.placeholderElementId = placeholderElementId;
	this.placeholderElement = null;
	this.compiledTemplate = null;
}

HandlebarsView.prototype.initialize = function(callback) {

	templateEngine.compile(this.templateUrl, function(compiledTemplate) {

		this.compiledTemplate = compiledTemplate;

		if (this.placeholderElementId) {

			this.placeholderElement = document.getElementById(this.placeholderElementId);

		}

		if (callback) {
			
			callback();
		}

	}.bind(this));
}

HandlebarsView.prototype.renderToInnerHtml = function(data) {

	if (this.placeholderElement) {

		this.placeholderElement.innerHTML = templateEngine.buildHtml(this.compiledTemplate, data);
	}
}


export { HandlebarsView }