
var templateEngine = {};

templateEngine.compile = function(templateUrl, callback) {

	var request = new XMLHttpRequest();

	request.onload = function() {

		if (request.readyState !== 4) {

			throw new Error("The request state is not DONE. Ready state: " + request.readyState);
		}

		if (request.status !== 200) {

			throw new Error("The request failed. Status: " + request.statusText);
		}

		var compiledTemplate = Handlebars.compile(request.responseText);

		callback(compiledTemplate);
	};

	request.onerror = function() {

		throw new Error("The request failed. Status: " + request.statusText);
	};

	request.open("GET", templateUrl);
	request.send(null);
}

templateEngine.buildHtml = function(compiledTemplate, data) {

	return compiledTemplate(data);
}


export { templateEngine }