/* Norton's rendition of the MVC User Mgmt Page (June 2019) */
class HomeView {

    constructor(controller) {

        this.controller = controller;
        this.dom = document.getElementById('mainPlaceholder');
        this.templateRetrieved = false;


        fetch("app/views/templates/home.hbs")
        .then(response => response.text())
        .then(text => {
          this.template = Handlebars.compile(text);
          this.templateRetrieved = true;
        });
    }
}


HomeView.prototype.render = async function(callback) {

    while (! this.templateRetrieved) {
        await delay();
    }

    this.dom.innerHTML = this.template();

    callback();
}

export { HomeView };