/* Norton's rendition of the MVC User Mgmt Page (June 2019) */
class UserDetailsView {
  constructor(controller) {
    this.controller = controller;
    this.currentUserId = -1;
    this.templateRetrieved = false;

    fetch("app/views/templates/userDetails.hbs")
      .then(response => response.text())
      .then(text => {
        this.template = Handlebars.compile(text);
        this.templateRetrieved = true;
      });
  }
}

UserDetailsView.prototype.clearSlate = async function() {
  let context = { id: this.currentUserId };

  while (!this.templateRetrieved) await delay();
  document.getElementById("userDetailPlaceholder").innerHTML = this.template(context);
  document.getElementById("name").focus();
  this.addButtonListeners();
};

UserDetailsView.prototype.hideInputForm = async function() {
  while (!this.templateRetrieved) await delay();
  document.getElementById("inputForm").hidden = true;
  document.getElementById("btnSave").hidden = true;
  document.getElementById("btnCancel").hidden = true;
};

UserDetailsView.prototype.showInputForm = function() {
  document.getElementById("inputForm").hidden = false;
  document.getElementById("btnSave").hidden = false;
  document.getElementById("btnCancel").hidden = false;
};

UserDetailsView.prototype.getCurrentUserId = function() {
  return Number(document.getElementById("uniqueId").innerText);
};

UserDetailsView.prototype.setCurrentUserId = function(userId) {
  this.currentUserId = userId;
  document.getElementById("uniqueId").innerText = Number(userId);
};

UserDetailsView.prototype.getFormInputValues = function() {
  let user = {};

  for (let el of document.getElementById("userDetail").elements) {
    switch (el.name) {
      case "id":
        user[el.name] = Number(el.value);
        break;

      case "gender":
        if (el.checked) user[el.name] = el.value;
        break;

      default:
        user[el.name] = el.value;
        break;
    }
  }

  return user;
};

UserDetailsView.prototype.populateUserDetails = async function(currentUser) {
  while (!this.templateRetrieved) await delay();
  document.getElementById("userDetailPlaceholder").innerHTML = this.template(currentUser);
  this.addButtonListeners();
  document.title = "Edit " + currentUser.name;
};

UserDetailsView.prototype.validateForm = function() {
  let form = document.getElementById("userDetail");

  if (!form.checkValidity()) {
    form.reportValidity();
    return false;
  } else return true;
};

UserDetailsView.prototype.addButtonListeners = function() {
  document
    .getElementById("userDetail")
    .addEventListener("submit", this.controller.save.bind(this.controller));

  document
    .getElementById("btnCancel")
    .addEventListener("click", this.controller.cancel.bind(this.controller));
  document.getElementById("name").focus();
};

export { UserDetailsView };
