/* Norton's rendition of the MVC User Mgmt Page (June 2019) */
class UserMasterView {

    constructor(controller) {

        this.controller = controller;
        this.dom = document.getElementById('userMaster');
        this.templateRetrieved = false;

        fetch("app/views/templates/userMaster.hbs").then(response => response.text()).then(text => {
            this.template = Handlebars.compile(text);
            this.templateRetrieved = true;
        });
    }
}


UserMasterView.prototype.resetUserRows = async function(rows) {

    while (! this.templateRetrieved) {
        await delay();
    }

    let context = { 'users': rows };    
    document.getElementById('userMasterPlaceholder').innerHTML = this.template(context);

    document.getElementById("btnNew").addEventListener("click", this.controller.new.bind(this.controller));

    // document.querySelectorAll(".editButton").forEach(el => {
    //     el.addEventListener('click', this.controller.edit.bind(this.controller), false);
    // });

    document.querySelectorAll(".deleteButton").forEach(el => {
        el.addEventListener('click', this.controller.delete.bind(this.controller), false);
    });

    document.title = "User Master View";
}



export { UserMasterView };