/* Norton's rendition of the MVC User Mgmt Page (June 2019) */
class UserSimpleView {

    constructor(controller) {
        this.controller = controller;
        this.dom = document.getElementById('mainPlaceholder');
        this.templateRetrieved = false;

        fetch("app/views/templates/userSimple.hbs").then(response => response.text()).then(text => {
            this.template = Handlebars.compile(text);
            this.templateRetrieved = true;
        });
    }

}


UserSimpleView.prototype.render = async function(callback, userObj) {

    while (! this.templateRetrieved) {
        await delay();
    }

    this.dom.innerHTML = this.template(userObj);
    document.title = "View " + userObj.name;
    callback();
}

export { UserSimpleView };
