
import { usersStore } from "./users-store.js";
import { messageBoxController } from "../components/message-box.controller.js"
import { usersManagementView } from "./users-management.view.js";
import { usersDetailsView } from "./users-details.view.js";
import { usersMasterView } from "./users-master.view.js";
import { userView } from "./user.view.js";
import { router } from "../../lib/core/web/router.js";

var usersController = {};

router.add("/users-management.html", function(request) {

	var isEdit = (request.parameters) ? true : false;

	if (isEdit) {

		var userId = request.parameters.userId;

		usersController.editUser(userId)

	} else {

		usersController.load();
	}
});

router.add("/user.html", function(request) {

	usersController.viewUser(request.parameters.userId);
});

usersController.initialize = function(callback) {

	usersManagementView.initialize(function() {

		usersDetailsView.initialize(function() {

			usersMasterView.initialize(function() {

				userView.initialize(function() {

					usersManagementView.addRenderListener(function(event) {

						router.setRouteLinks(event.placeholderElement);
					});

					usersMasterView.addRenderListener(function(event) {

						router.setRouteLinks(event.placeholderElement);
					});

					userView.addRenderListener(function(event) {

						router.setRouteLinks(event.placeholderElement);
					});

					callback();
				});
			});
		});
	});
};

usersController.load = function() {

	usersManagementView.render();

	usersDetailsView.render();

	var users = usersStore.getAll();

	usersMasterView.render(users);
	messageBoxController.close();
};

usersController.isLoaded = function() {

	return usersManagementView.isRendered();
}

usersController.viewUser = function(userId) {

	var user = usersStore.get(userId);

	userView.render(user);
}

usersController.newUser = function() {

	usersDetailsView.render();
	messageBoxController.close();
}

usersController.editUser = function(userId) {

	if (!usersController.isLoaded()) {

		usersController.load();
	}

	var user = usersStore.get(userId);

	usersDetailsView.render(user);
	messageBoxController.close();
}

usersController.cancelEditUser = function(userId) {

	var userFound = false;

	if (userId) {

		var user = usersStore.get(userId);

		if (user) {

			userFound = true;

			usersDetailsView.render(user);
			messageBoxController.message("Changes to user <strong>" + user.name + "</strong> have been canceled.");
		}
	}

	if (!userFound) {

		usersDetailsView.render();
		messageBoxController.close();
	}
}

usersController.saveUser = function(user) {

	var currentUser = null;

	if (user.userId) {

		currentUser = usersStore.get(user.userId);
	}

	if (currentUser) {

		user.createdDate = currentUser.createdDate;
		user.updatedDate = new Date();

		usersStore.update(user);

		messageBoxController.message("User <strong>" + user.name + "</strong> has been saved.");

	} else {

		user.userId = usersStore.getNextUserId();
		user.createdDate = new Date();
		user.updatedDate = new Date();

		usersStore.add(user);

		messageBoxController.message("User <strong>" + user.name + "</strong> has been created.");
	}

	usersDetailsView.render(user);

	var users = usersStore.getAll();

	usersMasterView.render(users);
}

usersController.deleteUser = function(userId) {

	var user = usersStore.get(userId);

	if (user) {

		usersStore.remove(user.userId);

		messageBoxController.message("User <strong>" + user.name + "</strong> has been deleted.");

		var users = usersStore.getAll();

		usersMasterView.render(users);

	} else {

		messageBoxController.message("User <strong>" + user.name + "</strong> not found.", true);
	}
}


export { usersController }