
import { HashTable } from "../collections/hash-table.js";
import { Request } from "./request.js"

var router = {
	routes: new HashTable()
};

router.add = function(path, handler) {

	if (!path) {

		throw new Error("Path cannot be empty.");
	}

	if (path) {

		if (path.length > 1) {

			path = path.replace(/\/$/, "");
		}

		this.routes.add(path, handler);
	}
};

router.load = function() {

	var location = window.location;

	this.navigateTo(location.pathname, location.search, true);
}

router.navigateTo = function(path, query, isLoad, excludeHistory) {

	var request = new Request(path, query, isLoad);

	if (this.routes.includesKey(request.path)) {

		var historyState = {
			path: request.path,
			query: request.query,
		};

		if (isLoad) {

			history.replaceState(historyState, null, request.url);

		} else if (!excludeHistory) {

			history.pushState(historyState, null, request.url);
		}

		var handler = this.routes[request.path];

		handler(request);
	}
}

router.setRouteLinks = function(element) {

	if (!element) {

		element = document;
	}

	var elements = element.querySelectorAll("a[data-route-link]");

	elements.forEach(function(element) {

		element.addEventListener("click", function(event) {

			event.preventDefault();

			var anchor = event.currentTarget;

			router.navigateTo(anchor.pathname, anchor.search);
		})
	});
}

window.addEventListener("popstate", function(event) {

	if (event.state && event.state.path) {

		router.navigateTo(event.state.path, event.state.query, false, true);
	}
});


export { router }