/* Norton's rendition of the MVC User Mgmt Page (June 2019) */

import { HomeController } from "./app/homeController.js";
import { MessagesController } from "./app/messagesController.js";
import { UserManagementController } from "./app/userManagementController.js";
import { Router } from "./app/router.js";
import { AppController } from "./app/appController.js";

class App {
  constructor() { }
}

App.prototype.load = function() {

    this.router = new Router();
    this.appController = new AppController(() => {
        this.appController.load(() => {

            this.homeController = new HomeController(this.router);
            this.userManagementController = new UserManagementController(this.router);
            this.messageController = new MessagesController();
        
            window.addEventListener("error", e => {
              // catches runtime errors, e.g. throw new Error(....);
              this.messageController.displayMessage(e.error);
            });
        
            window.addEventListener("popstate", e => {
              let { path, query } = e.state;
        
              console.log("test");
              this.router.navigateTo(path, query, true);
            });
        
            // this.homeController.load();

            this.router.navigateTo(window.location.pathname, window.location.search, false);
        });
    });
};

export { App };
