/* Norton's rendition of the MVC User Mgmt Page (June 2019) */
class UserManagementView {

    constructor(controller) {

        this.controller = controller;
        this.dom = document.getElementById('mainPlaceholder');
        this.templateRetrieved = false;

        fetch("app/views/templates/userManage.hbs").then(response => response.text()).then(text => {
            this.template = Handlebars.compile(text);
            this.templateRetrieved = true;
        });
    }
}


UserManagementView.prototype.render = async function(callback, userObj) {

    while (! this.templateRetrieved) {
        await delay();
    }

    if (!userObj) var userObj = {};
    userObj.indexActive = '';
    userObj.userActive = 'active';
    this.dom.innerHTML = this.template(userObj);

    callback();
}

export { UserManagementView };