
import { formatDateHelper } from "./lib/core-vendor/handlebars/helpers/format-date-helper.js"
import { addAttributeNameByBooleanHelper } from "./lib/core-vendor/handlebars/helpers/add-attribute-name-by-boolean-helper.js"
import { addAttributeNameByCompareHelper } from "./lib/core-vendor/handlebars/helpers/add-attribute-name-by-compare-helper.js"
import { appController } from "./app/app.controller.js";
import { homeController } from "./app/home.controller.js";
import { messageBoxController } from "./app/components/message-box.controller.js"
import { usersController } from "./app/users/users.controller.js";
import { router } from "./lib/core/web/router.js";

window.addEventListener("DOMContentLoaded", function(event) {

	appController.initialize(function() {

		appController.load();

		Handlebars.registerHelper(formatDateHelper.name, formatDateHelper.helper);
		Handlebars.registerHelper(addAttributeNameByBooleanHelper.name, addAttributeNameByBooleanHelper.helper);
		Handlebars.registerHelper(addAttributeNameByCompareHelper.name, addAttributeNameByCompareHelper.helper);

		messageBoxController.initialize(function() {

			homeController.initialize(function() {

				usersController.initialize(function() {

					router.load();
				});
			});
		});
	});

});

window.addEventListener("error", function(event) {

	var error = event.error;
	var message = error.message;

	if (error.stack) {

		message = message + "<hr><div class='text-left'>" + error.stack + "</div>";

	}

	messageBoxController.message(message, true);
});
