
import { HtmlView } from "../lib/core/web/html-view.js";
import { dom } from "../lib/core/web/dom.js"
import { ajax } from "../lib/core/web/ajax.js";

var appView = new HtmlView("app/app.head.html");

appView.initialize = function(callback) {

	dom.appendScript("/assets/vendor/handlebars/4.0.12/handlebars.min.js", function() {

		ajax.get("app/partials/navbar.partial.hbs", function(responseText) {

			Handlebars.registerPartial('navbar', responseText);

			HtmlView.prototype.initialize.call(appView, callback);
		});
	});
};

appView.render = function() {

	dom.appendHtml(document.head, this.html);

	var placeholderElement = dom.createElement("div", { id: "appPlaceHolder" });

	document.body.appendChild(placeholderElement);
	document.body.className = "bg-dark text-light";
};

export { appView }