
import { HandlebarsView } from "../../lib/core-vendor/handlebars/handlebars-view.js";
import { usersController } from "./users.controller.js";
import { dom } from "../../lib/core/web/dom.js";

var usersDetailsView = new HandlebarsView("app/users/users-details.template.hbs");

usersDetailsView.render = function(user) {

	if (user && user.userId) {

		document.title = "User Management Edit " + user.userId;
	}

	var placeholderElement = dom("#usersDetailsPlaceholder");

	this.renderToInnerHtml(user, placeholderElement);

	dom("#newButton", placeholderElement).addEventListener("click", onNew);
	dom("#usersDetails", placeholderElement).addEventListener("submit", onSubmit);
	dom("#cancelEditButton", placeholderElement).addEventListener("click", onCancelEdit);
};

function inBind() {

	var form = dom("#usersDetails");
	var data = dom.getFormData(form);

	var user = {};

	if (data.userId) {

		user.userId = Number.parseInt(data.userId);
	}

	user.name = data.name;
	user.email = data.email;
	user.gender = data.gender;
	user.age = Number.parseInt(data.age);
	user.role = data.role;
	user.verified = data.verified;

	return user;
}

function onNew() {

	usersController.newUser();
}

function onSubmit(event) {

	event.preventDefault();

	var user = inBind();

	usersController.saveUser(user);
}

function onCancelEdit() {

	var user = inBind();

	usersController.cancelEditUser(user.userId);
}


export { usersDetailsView }