
import { QueryString } from "./query-string.js";

function Request(path, query, isLoad) {

	if (path.length > 1) {

		var pathAndQuery = path.split("?");

		if (pathAndQuery.length > 1) {

			var queryString = new QueryString(pathAndQuery[1]);

			this.parameters = queryString.parameters;
			this.query = queryString.query;

		} else {

			path = path.replace(/\/$/, "");
		}
	}

	if (query) {

		var queryString = new QueryString(query);

		this.parameters = queryString.parameters;
		this.query = queryString.query;
	}

	this.path = path;
	this.url = this.path;

	if (this.query) {

		this.url += this.query;
	}

	this.isLoad = isLoad;
}


export { Request }