
var moveDirectionDifferentials = [
	{ rowIndex: -1, columnIndex: -1 },
	{ rowIndex: -1, columnIndex: 0 },
	{ rowIndex: -1, columnIndex: 1 },
	{ rowIndex: 0, columnIndex: -1 },
	{ rowIndex: 0, columnIndex: 1 },
	{ rowIndex: 1, columnIndex: -1 },
	{ rowIndex: 1, columnIndex: 0 },
	{ rowIndex: 1, columnIndex: 1 },
];

var grid = [
	["#", "#", "#", "#", "#", "#"],
	["#", " ", "p", "#", " ", "#"],
	["#", " ", "#", " ", "a", "#"],
	["#", " ", "p", "a", " ", "#"],
	["#", " ", "#", "p", " ", "#"],
	["#", "#", "#", "#", "#", "#"],
];

var world = {};

world.turn = function() {

	var currentCell;
	var hasDied;
	var plantTargetCells = [" "];
	var animalTargetCells = [" ", "p"];

	for (var rowIndex = 0; rowIndex < grid.length; rowIndex++) {

		for (var columnIndex = 0; columnIndex < grid[rowIndex].length; columnIndex++) {

			currentCell = grid[rowIndex][columnIndex];

			switch (currentCell) {
				case "p":

					hasDied = tryToDie(rowIndex, columnIndex);

					if (!hasDied) {

						tryToReproduce(rowIndex, columnIndex, currentCell, plantTargetCells);
					}

					break;

				case "a":

					hasDied = tryToDie(rowIndex, columnIndex);

					if (!hasDied) {

						tryToReproduce(rowIndex, columnIndex, currentCell, animalTargetCells);
						tryToMove(rowIndex, columnIndex, animalTargetCells);
					}

					break;
			}
		}
	}
};

world.toString = function() {

	var result = "";

	for (var rowIndex = 0; rowIndex < grid.length; rowIndex++) {

		for (var columnIndex = 0; columnIndex < grid[rowIndex].length; columnIndex++) {

			result += grid[rowIndex][columnIndex];
		}

		result += "\n";
	}

	return result;
};

function tryToDie(rowIndex, columnIndex) {

	var hasDied = Math.random() < 30 / 100;

	if (hasDied) {

		grid[rowIndex][columnIndex] = " ";
	}

	return hasDied;
}

function tryToReproduce(rowIndex, columnIndex, cell, targetCells) {

	var hasReproduced = Math.random() < 30 / 100;

	if (hasReproduced) {

		hasReproduced = false;

		var cellLocation = getRandomNearbyEmptyCellLocation(rowIndex, columnIndex, targetCells);

		if (cellLocation) {

			grid[cellLocation.rowIndex][cellLocation.columnIndex] = cell;
			hasReproduced = true;
		}
	}

	return hasReproduced;
}

function tryToMove(rowIndex, columnIndex, targetCells) {

	var hasMoved = Math.random() < 30 / 100;

	if (hasMoved) {

		hasMoved = false;

		var cellLocation = getRandomNearbyEmptyCellLocation(rowIndex, columnIndex, targetCells);

		if (cellLocation) {

			var cell = grid[rowIndex][columnIndex];

			grid[cellLocation.rowIndex][cellLocation.columnIndex] = cell;
			grid[rowIndex][columnIndex] = " ";

			hasMoved = true;
		}
	}

	return hasMoved;
}

function getRandomNearbyEmptyCellLocation(rowIndex, columnIndex, targetCells) {

	var cellLocation;
	var emptyCells = [];

	for (var index = 0; index < moveDirectionDifferentials.length; index++) {

		var moveDirectionDifferential = moveDirectionDifferentials[index];
		var targetRowIndex = rowIndex + moveDirectionDifferential.rowIndex;
		var targetColumnIndex = columnIndex + moveDirectionDifferential.columnIndex;
		var cell = grid[targetRowIndex][targetColumnIndex];

		for (var indexTargetCells = 0; indexTargetCells < targetCells.length; indexTargetCells++) {

			var targetCell = targetCells[indexTargetCells];

			if (cell === targetCell) {

				cellLocation = {
					rowIndex: targetRowIndex,
					columnIndex: targetColumnIndex
				}
	
				emptyCells.push(cellLocation);
				break;
			}
		}
	}

	if (emptyCells.length > 0) {

		var randomIndex = randomInteger(0, emptyCells.length - 1);
		cellLocation = emptyCells[randomIndex];
	}

	return cellLocation;
}

// The min and max numbers are included in the possible numbers
function randomInteger(min, max) {

	min = Math.ceil(min);
	max = Math.floor(max) + 1;

	return Math.floor(Math.random() * (max - min)) + min;
}